/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.CatchTask;
import ise.antelope.tasks.FinallyTask;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class TryTask
extends Task
implements TaskContainer {
    private Vector tasks = new Vector();
    private Task catchTask = null;
    private Task finallyTask = null;
    private boolean doBreak = true;
    private boolean doPrintMessage = true;
    private String messageProperty = null;
    private boolean doPrintStackTrace = false;
    private String stackTraceProperty = null;

    public void init() {
        this.getProject().addTaskDefinition("catch", CatchTask.class);
        this.getProject().addTaskDefinition("finally", FinallyTask.class);
    }

    public void maybeConfigure() throws BuildException {
        if (this.isInvalid()) {
            super.maybeConfigure();
        } else {
            this.getRuntimeConfigurableWrapper().maybeConfigure(this.getProject(), false);
        }
    }

    public void addTask(Task task) {
        if (task instanceof CatchTask) {
            if (this.catchTask == null) {
                this.catchTask = task;
                return;
            }
            throw new BuildException("Only one Catch allowed per Try.");
        }
        if (task instanceof FinallyTask) {
            if (this.finallyTask == null) {
                this.finallyTask = task;
                return;
            }
            throw new BuildException("Only one Finally allowed per Try.");
        }
        this.tasks.addElement(task);
    }

    public void addCatch(CatchTask catchTask) {
        this.addTask((Task)catchTask);
    }

    public void addFinally(FinallyTask finallyTask) {
        this.addTask((Task)finallyTask);
    }

    public void setBreak(boolean bl) {
        this.doBreak = bl;
    }

    public void setPrintmessage(boolean bl) {
        this.doPrintMessage = bl;
    }

    public void setMessageproperty(String string) {
        this.messageProperty = string;
    }

    public void setPrintstacktrace(boolean bl) {
        this.doPrintStackTrace = bl;
    }

    public void setStacktraceproperty(String string) {
        this.stackTraceProperty = string;
    }

    public void execute() throws BuildException {
        Throwable throwable = null;
        Enumeration enumeration = this.tasks.elements();
        while (enumeration.hasMoreElements()) {
            Task task = (Task)enumeration.nextElement();
            try {
                task.perform();
            }
            catch (Throwable throwable2) {
                block19: {
                    PrintWriter printWriter;
                    StringWriter stringWriter;
                    throwable = throwable2;
                    if (this.messageProperty != null) {
                        this.getProject().setProperty(this.messageProperty, throwable2.getMessage());
                    }
                    if (this.stackTraceProperty != null) {
                        stringWriter = new StringWriter();
                        printWriter = new PrintWriter((Writer)stringWriter, true);
                        throwable2.printStackTrace(printWriter);
                        this.getProject().setProperty(this.stackTraceProperty, stringWriter.toString());
                    }
                    if (this.doPrintStackTrace) {
                        try {
                            this.log("Task '" + task.getTaskName() + "' in target '" + (task.getOwningTarget() == null ? "unknown" : task.getOwningTarget().getName()) + "' failed, task stack trace follows:");
                            stringWriter = new StringWriter();
                            printWriter = new PrintWriter((Writer)stringWriter, true);
                            throwable2.printStackTrace(printWriter);
                            this.log(stringWriter.toString());
                        }
                        catch (Exception exception) {}
                    } else if (this.doPrintMessage) {
                        try {
                            this.log("Task '" + task.getTaskName() + "' in target '" + (task.getOwningTarget() == null ? "unknown" : task.getOwningTarget().getName()) + "' failed, error message is: " + throwable2.getMessage());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.catchTask != null) {
                        try {
                            this.catchTask.perform();
                        }
                        catch (Throwable throwable3) {
                            if (this.finallyTask != null) {
                                try {
                                    this.finallyTask.perform();
                                    break block19;
                                }
                                catch (Exception exception) {
                                    throw new BuildException(throwable.getMessage(), (Throwable)new BuildException(exception.getMessage(), throwable3));
                                }
                            }
                            throw new BuildException(throwable.getMessage(), throwable3);
                        }
                    }
                }
                if (!this.doBreak) continue;
                break;
            }
        }
        if (this.finallyTask != null) {
            this.finallyTask.perform();
        }
    }
}

