/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks.util.math;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;

public class Math {
    private boolean strict = false;
    public static Class BIGDECIMAL_TYPE;
    public static Class BIGINT_TYPE;

    public Math() {
    }

    public Math(boolean bl) {
        this.strict = bl;
    }

    public void setStrict(boolean bl) {
        this.strict = bl;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public static BigDecimal add(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.add(bigDecimal2);
    }

    public static BigInteger add(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.add(bigInteger2);
    }

    public static BigInteger and(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.and(bigInteger2);
    }

    public static int and(int n, int n2) {
        return n & n2;
    }

    public static BigInteger or(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.or(bigInteger2);
    }

    public static int or(int n, int n2) {
        return n | n2;
    }

    public static BigInteger not(BigInteger bigInteger) {
        return bigInteger.not();
    }

    public static int not(int n) {
        return ~n;
    }

    public static BigInteger xor(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.xor(bigInteger2);
    }

    public static int xor(int n, int n2) {
        return n ^ n2;
    }

    public static double add(double d, double d2) {
        return d + d2;
    }

    public static float add(float f, float f2) {
        return f + f2;
    }

    public static long add(long l, long l2) {
        return l + l2;
    }

    public static int add(int n, int n2) {
        return n + n2;
    }

    public static BigInteger add(BigInteger[] bigIntegerArray) {
        if (bigIntegerArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (bigIntegerArray.length == 1) {
            return bigIntegerArray[0];
        }
        BigInteger bigInteger = bigIntegerArray[0];
        for (int i = 1; i < bigIntegerArray.length; ++i) {
            bigInteger = bigInteger.add(bigIntegerArray[i]);
        }
        return bigInteger;
    }

    public static double add(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static float add(float[] fArray) {
        if (fArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fArray.length == 1) {
            return fArray[0];
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            f += fArray[i];
        }
        return f;
    }

    public static long add(long[] lArray) {
        if (lArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (lArray.length == 1) {
            return lArray[0];
        }
        long l = lArray[0];
        for (int i = 1; i < lArray.length; ++i) {
            l += lArray[i];
        }
        return l;
    }

    public static int add(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (nArray.length == 1) {
            return nArray[0];
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public static BigDecimal subtract(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.subtract(bigDecimal2);
    }

    public static BigInteger subtract(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.subtract(bigInteger2);
    }

    public static double subtract(double d, double d2) {
        return d - d2;
    }

    public static float subtract(float f, float f2) {
        return f - f2;
    }

    public static long subtract(long l, long l2) {
        return l - l2;
    }

    public static int subtract(int n, int n2) {
        return n - n2;
    }

    public static BigDecimal subtract(BigDecimal[] bigDecimalArray) {
        if (bigDecimalArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (bigDecimalArray.length == 1) {
            return bigDecimalArray[0];
        }
        BigDecimal bigDecimal = bigDecimalArray[0];
        for (int i = 1; i < bigDecimalArray.length; ++i) {
            bigDecimal = bigDecimal.subtract(bigDecimalArray[i]);
        }
        return bigDecimal;
    }

    public static BigInteger subtract(BigInteger[] bigIntegerArray) {
        if (bigIntegerArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (bigIntegerArray.length == 1) {
            return bigIntegerArray[0];
        }
        BigInteger bigInteger = bigIntegerArray[0];
        for (int i = 1; i < bigIntegerArray.length; ++i) {
            bigInteger = bigInteger.subtract(bigIntegerArray[i]);
        }
        return bigInteger;
    }

    public static double subtract(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d -= dArray[i];
        }
        return d;
    }

    public static float subtract(float[] fArray) {
        if (fArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fArray.length == 1) {
            return fArray[0];
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            f -= fArray[i];
        }
        return f;
    }

    public static long subtract(long[] lArray) {
        if (lArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (lArray.length == 1) {
            return lArray[0];
        }
        long l = lArray[0];
        for (int i = 1; i < lArray.length; ++i) {
            l -= lArray[i];
        }
        return l;
    }

    public static int subtract(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (nArray.length == 1) {
            return nArray[0];
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n -= nArray[i];
        }
        return n;
    }

    public static BigDecimal multiply(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.multiply(bigDecimal2);
    }

    public static BigInteger multiply(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.multiply(bigInteger2);
    }

    public static double multiply(double d, double d2) {
        return d * d2;
    }

    public static float multiply(float f, float f2) {
        return f * f2;
    }

    public static long multiply(long l, long l2) {
        return l * l2;
    }

    public static int multiply(int n, int n2) {
        return n * n2;
    }

    public static BigDecimal multiply(BigDecimal[] bigDecimalArray) {
        if (bigDecimalArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (bigDecimalArray.length == 1) {
            return bigDecimalArray[0];
        }
        BigDecimal bigDecimal = bigDecimalArray[0];
        for (int i = 1; i < bigDecimalArray.length; ++i) {
            bigDecimal = bigDecimal.multiply(bigDecimalArray[i]);
        }
        return bigDecimal;
    }

    public static BigInteger multiply(BigInteger[] bigIntegerArray) {
        if (bigIntegerArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (bigIntegerArray.length == 1) {
            return bigIntegerArray[0];
        }
        BigInteger bigInteger = bigIntegerArray[0];
        for (int i = 1; i < bigIntegerArray.length; ++i) {
            bigInteger = bigInteger.multiply(bigIntegerArray[i]);
        }
        return bigInteger;
    }

    public static double multiply(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d *= dArray[i];
        }
        return d;
    }

    public static float multiply(float[] fArray) {
        if (fArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fArray.length == 1) {
            return fArray[0];
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            f *= fArray[i];
        }
        return f;
    }

    public static long multiply(long[] lArray) {
        if (lArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (lArray.length == 1) {
            return lArray[0];
        }
        long l = lArray[0];
        for (int i = 1; i < lArray.length; ++i) {
            l *= lArray[i];
        }
        return l;
    }

    public static int multiply(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (nArray.length == 1) {
            return nArray[0];
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n *= nArray[i];
        }
        return n;
    }

    public static BigDecimal divide(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        try {
            return bigDecimal.divide(bigDecimal2, 6);
        }
        catch (Throwable throwable) {
            return bigDecimal.divide(bigDecimal2, 6);
        }
    }

    public static BigInteger divide(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.divide(bigInteger2);
    }

    public static double divide(double d, double d2) {
        if (d2 == 0.0) {
            throw new ArithmeticException("/ by zero");
        }
        return d / d2;
    }

    public static float divide(float f, float f2) {
        if (f2 == 0.0f) {
            throw new ArithmeticException("/ by zero");
        }
        return f / f2;
    }

    public static long divide(long l, long l2) {
        if (l2 == 0L) {
            throw new ArithmeticException("/ by zero");
        }
        return l / l2;
    }

    public static int divide(int n, int n2) {
        if (n2 == 0) {
            throw new ArithmeticException("/ by zero");
        }
        return n / n2;
    }

    public static BigDecimal divide(BigDecimal[] bigDecimalArray) {
        if (bigDecimalArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (bigDecimalArray.length == 1) {
            return bigDecimalArray[0];
        }
        BigDecimal bigDecimal = bigDecimalArray[0];
        for (int i = 1; i < bigDecimalArray.length; ++i) {
            bigDecimal = bigDecimal.divide(bigDecimalArray[i], 6);
        }
        return bigDecimal;
    }

    public static BigInteger divide(BigInteger[] bigIntegerArray) {
        if (bigIntegerArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (bigIntegerArray.length == 1) {
            return bigIntegerArray[0];
        }
        BigInteger bigInteger = bigIntegerArray[0];
        for (int i = 1; i < bigIntegerArray.length; ++i) {
            bigInteger = bigInteger.divide(bigIntegerArray[i]);
        }
        return bigInteger;
    }

    public static double divide(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) {
                throw new ArithmeticException("/ by zero");
            }
            d /= dArray[i];
        }
        return d;
    }

    public static float divide(float[] fArray) {
        if (fArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fArray.length == 1) {
            return fArray[0];
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            if (fArray[i] == 0.0f) {
                throw new ArithmeticException("/ by zero");
            }
            f /= fArray[i];
        }
        return f;
    }

    public static long divide(long[] lArray) {
        if (lArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (lArray.length == 1) {
            return lArray[0];
        }
        long l = lArray[0];
        for (int i = 1; i < lArray.length; ++i) {
            if (lArray[i] == 0L) {
                throw new ArithmeticException("/ by zero");
            }
            l /= lArray[i];
        }
        return l;
    }

    public static int divide(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (nArray.length == 1) {
            return nArray[0];
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == 0) {
                throw new ArithmeticException("/ by zero");
            }
            n /= nArray[i];
        }
        return n;
    }

    public static BigInteger mod(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.mod(bigInteger2);
    }

    public static double mod(double d, double d2) {
        return d % d2;
    }

    public static float mod(float f, float f2) {
        return f % f2;
    }

    public static long mod(long l, long l2) {
        return l % l2;
    }

    public static int mod(int n, int n2) {
        return n % n2;
    }

    public static BigInteger mod(BigInteger[] bigIntegerArray) {
        if (bigIntegerArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (bigIntegerArray.length == 1) {
            return bigIntegerArray[0];
        }
        BigInteger bigInteger = bigIntegerArray[0];
        for (int i = 1; i < bigIntegerArray.length; ++i) {
            bigInteger = bigInteger.mod(bigIntegerArray[i]);
        }
        return bigInteger;
    }

    public static double mod(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d %= dArray[i];
        }
        return d;
    }

    public static float mod(float[] fArray) {
        if (fArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fArray.length == 1) {
            return fArray[0];
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            f %= fArray[i];
        }
        return f;
    }

    public static long mod(long[] lArray) {
        if (lArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (lArray.length == 1) {
            return lArray[0];
        }
        long l = lArray[0];
        for (int i = 1; i < lArray.length; ++i) {
            l %= lArray[i];
        }
        return l;
    }

    public static int mod(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (nArray.length == 1) {
            return nArray[0];
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n %= nArray[i];
        }
        return n;
    }

    public static boolean greaterThan(int n, int n2) {
        return n > n2;
    }

    public static boolean greaterThan(long l, long l2) {
        return l > l2;
    }

    public static boolean greaterThan(double d, double d2) {
        return d > d2;
    }

    public static boolean greaterThan(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2) > 0;
    }

    public static boolean greaterThan(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.compareTo(bigDecimal2) > 0;
    }

    public static boolean lessThan(int n, int n2) {
        return n < n2;
    }

    public static boolean lessThan(long l, long l2) {
        return l < l2;
    }

    public static boolean lessThan(double d, double d2) {
        return d < d2;
    }

    public static boolean lessThan(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2) < 0;
    }

    public static boolean lessThan(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.compareTo(bigDecimal2) < 0;
    }

    public static boolean equal(int n, int n2) {
        return n == n2;
    }

    public static boolean equal(long l, long l2) {
        return l == l2;
    }

    public static boolean equal(double d, double d2) {
        return d == d2;
    }

    public static boolean equal(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2) == 0;
    }

    public static boolean equal(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.compareTo(bigDecimal2) == 0;
    }

    public static boolean notEqual(int n, int n2) {
        return n != n2;
    }

    public static boolean notEqual(long l, long l2) {
        return l != l2;
    }

    public static boolean notEqual(double d, double d2) {
        return d != d2;
    }

    public static boolean notEqual(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2) != 0;
    }

    public static boolean notEqual(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.compareTo(bigDecimal2) != 0;
    }

    public static BigInteger factorial(BigInteger bigInteger) {
        if (bigInteger.compareTo(new BigInteger("0")) < 0) {
            throw new IllegalArgumentException("number must be greater than 0");
        }
        BigInteger bigInteger2 = bigInteger;
        bigInteger = bigInteger.subtract(new BigInteger("1"));
        while (bigInteger.toString().compareTo("1") > 0) {
            bigInteger2 = bigInteger2.multiply(bigInteger);
            bigInteger = bigInteger.subtract(new BigInteger("1"));
        }
        return bigInteger2;
    }

    public static int factorial(double d) {
        return Math.factorial((int)d);
    }

    public static int factorial(float f) {
        return Math.factorial((int)f);
    }

    public static int factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("number must be greater than 0");
        }
        int n2 = n--;
        while (n > 1) {
            n2 *= n;
            --n;
        }
        return n2;
    }

    public static BigDecimal min(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.min(bigDecimal2);
    }

    public static BigInteger min(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.min(bigInteger2);
    }

    public static BigDecimal max(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.max(bigDecimal2);
    }

    public static BigInteger max(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.max(bigInteger2);
    }

    public static BigInteger pow(BigInteger bigInteger, BigInteger bigInteger2) {
        int n = bigInteger2.intValue();
        if (n < 1) {
            throw new IllegalArgumentException("Exponent must be greater than 0");
        }
        return bigInteger.pow(bigInteger2.intValue());
    }

    public static BigDecimal pow(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (bigDecimal2.compareTo(new BigDecimal("1")) <= 0) {
            throw new ArithmeticException("Powers of BigDecimals must be integers greater than 1");
        }
        String string = bigDecimal2.toString();
        if (string.indexOf(".") > 0) {
            string = string.substring(0, string.indexOf("."));
        }
        BigInteger bigInteger = new BigInteger(string);
        BigDecimal bigDecimal3 = new BigDecimal(bigDecimal.toString());
        while (bigInteger.compareTo(BigInteger.ONE) > 0) {
            bigDecimal = bigDecimal.multiply(bigDecimal3);
            bigInteger = bigInteger.subtract(BigInteger.ONE);
        }
        return bigDecimal;
    }

    public Number calculate(String string, String[] stringArray) {
        return this.calculate(string, "double", stringArray);
    }

    public Number calculate(String string, String string2, String[] stringArray) {
        try {
            Method method;
            Class[] classArray;
            Object object;
            String string3;
            int n;
            if (stringArray.length >= 2 && (string.equals("add") || string.equals("subtract") || string.equals("multiply") || string.equals("divide") || string.equals("mod"))) {
                return this.calculateArray(string, string2, stringArray);
            }
            if (stringArray.length > 2) {
                throw new IllegalArgumentException("too many operands");
            }
            Class<Object> clazz = this.strict ? Class.forName("java.lang.StrictMath") : Class.forName("java.lang.Math");
            if (string.equals("random")) {
                Method method2 = clazz.getDeclaredMethod(string, new Class[0]);
                Object object2 = method2.invoke(clazz, null);
                return (Number)object2;
            }
            Vector<Candidate> vector = new Vector<Candidate>();
            Method[] methodArray = clazz.getDeclaredMethods();
            for (n = 0; n < methodArray.length; ++n) {
                string3 = methodArray[n].getName();
                if (!string3.equals(string)) continue;
                vector.addElement(new Candidate(clazz, methodArray[n]));
            }
            clazz = this.getClass();
            methodArray = clazz.getDeclaredMethods();
            for (n = 0; n < methodArray.length; ++n) {
                string3 = methodArray[n].getName();
                if (!string3.equals(string)) continue;
                vector.addElement(new Candidate(clazz, methodArray[n]));
            }
            if (vector.size() == 0) {
                throw new RuntimeException("Unknown operation: " + string);
            }
            Class clazz2 = this.getDataType(string2);
            int n2 = -1;
            try {
                for (int i = 0; i <= vector.size() && (n2 = ((Method)(object = (classArray = (Candidate)vector.elementAt(i)).getCandidateMethod())).getParameterTypes().length) != stringArray.length; ++i) {
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Wrong number of arguments, have " + stringArray.length + ", but can't find corresponding method.");
            }
            Class clazz3 = null;
            if (vector.size() == 1) {
                classArray = (Candidate)vector.elementAt(0);
                clazz = classArray.getCandidateClass();
                method = classArray.getCandidateMethod();
                clazz3 = method.getParameterTypes()[0];
            } else {
                classArray = vector.elements();
                while (classArray.hasMoreElements()) {
                    object = (Candidate)classArray.nextElement();
                    clazz = ((Candidate)object).getCandidateClass();
                    method = ((Candidate)object).getCandidateMethod();
                    if (!method.getParameterTypes()[0].equals(clazz2)) continue;
                    clazz3 = clazz2;
                    break;
                }
                if (clazz3 == null) {
                    throw new RuntimeException("Can't find a method with parameters of type " + string2);
                }
            }
            classArray = new Class[n2];
            for (int i = 0; i < n2; ++i) {
                classArray[i] = clazz3;
            }
            method = clazz.getDeclaredMethod(string, classArray);
            Object[] objectArray = this.getParams(clazz3, stringArray);
            try {
                Object object3 = method.invoke((Object)clazz, objectArray);
                if (object3 instanceof Boolean) {
                    object3 = new Integer((Boolean)object3 != false ? 1 : 0);
                }
                return (Number)object3;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable != null && throwable instanceof ArithmeticException) {
                    throw (ArithmeticException)throwable;
                }
                throw invocationTargetException;
            }
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Number calculateArray(String string, String string2, String[] stringArray) {
        try {
            Object object;
            Class<?> clazz = this.getClass();
            Vector<Method> vector = new Vector<Method>();
            Method[] methodArray = clazz.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                object = methodArray[i].getName();
                if (!((String)object).equals(string) || methodArray[i].getParameterTypes().length != 1 || !methodArray[i].getParameterTypes()[0].isArray()) continue;
                vector.addElement(methodArray[i]);
            }
            if (vector.size() == 0) {
                throw new RuntimeException("Unknown operation: " + string);
            }
            Object object2 = this.getDataTypeArray(string2, stringArray.length);
            object = null;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Method method = (Method)enumeration.nextElement();
                if (!method.getParameterTypes()[0].equals(object2.getClass())) continue;
                object = this.getDataType(string2);
                Object[] objectArray = this.getParamsArray((Class)object, stringArray);
                try {
                    Object object3 = method.invoke(clazz, objectArray);
                    return (Number)object3;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getCause();
                    if (throwable == null || !(throwable instanceof ArithmeticException)) throw invocationTargetException;
                    throw (ArithmeticException)throwable;
                    return null;
                }
            }
        }
        catch (Exception exception) {
            if (!(exception instanceof ArithmeticException)) return null;
            throw (ArithmeticException)exception;
        }
    }

    private Class getDataType(String string) {
        if (string == null) {
            return Double.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("bigint")) {
            try {
                return Class.forName("java.math.BigInteger");
            }
            catch (Exception exception) {
            }
        } else if (string.equals("bigdecimal")) {
            try {
                return Class.forName("java.math.BigDecimal");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Double.TYPE;
    }

    private Object getDataTypeArray(String string, int n) {
        if (string == null) {
            return Array.newInstance(Double.TYPE, n);
        }
        if (string.equals("int")) {
            return Array.newInstance(Integer.TYPE, n);
        }
        if (string.equals("long")) {
            return Array.newInstance(Long.TYPE, n);
        }
        if (string.equals("float")) {
            return Array.newInstance(Float.TYPE, n);
        }
        if (string.equals("bigdecimal")) {
            return Array.newInstance(BIGDECIMAL_TYPE, n);
        }
        if (string.equals("bigint")) {
            return Array.newInstance(BIGINT_TYPE, n);
        }
        return Array.newInstance(Double.TYPE, n);
    }

    private Object[] getParams(Class clazz, String[] stringArray) {
        int n = stringArray.length;
        Object[] objectArray = new Object[n];
        if (clazz == BIGDECIMAL_TYPE) {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new BigDecimal(stringArray[i]);
            }
        } else if (clazz == BIGINT_TYPE) {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new BigInteger(stringArray[i]);
            }
        } else if (clazz == Double.TYPE) {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new Double(stringArray[i]);
            }
        } else if (clazz == Long.TYPE) {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new Long(stringArray[i]);
            }
        } else if (clazz == Float.TYPE) {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new Float(stringArray[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new Integer(stringArray[i]);
            }
        }
        if (n > 2) {
            objectArray = new Object[]{objectArray};
        }
        return objectArray;
    }

    private Object[] getParamsArray(Class clazz, String[] stringArray) {
        int n = stringArray.length;
        if (clazz == BIGDECIMAL_TYPE) {
            BigDecimal[] bigDecimalArray = (BigDecimal[])Array.newInstance(clazz, stringArray.length);
            for (int i = 0; i < n; ++i) {
                bigDecimalArray[i] = new BigDecimal(stringArray[i]);
            }
            return new Object[]{bigDecimalArray};
        }
        if (clazz == BIGINT_TYPE) {
            BigInteger[] bigIntegerArray = (BigInteger[])Array.newInstance(clazz, stringArray.length);
            for (int i = 0; i < n; ++i) {
                bigIntegerArray[i] = new BigInteger(stringArray[i]);
            }
            return new Object[]{bigIntegerArray};
        }
        if (clazz == Double.TYPE) {
            double[] dArray = (double[])Array.newInstance(clazz, stringArray.length);
            for (int i = 0; i < n; ++i) {
                Array.setDouble(dArray, i, new Double(stringArray[i]));
            }
            return new Object[]{dArray};
        }
        if (clazz == Long.TYPE) {
            long[] lArray = (long[])Array.newInstance(clazz, stringArray.length);
            for (int i = 0; i < n; ++i) {
                Array.setLong(lArray, i, new Long(stringArray[i]));
            }
            return new Object[]{lArray};
        }
        if (clazz == Float.TYPE) {
            float[] fArray = (float[])Array.newInstance(clazz, stringArray.length);
            for (int i = 0; i < n; ++i) {
                Array.setFloat(fArray, i, new Float(stringArray[i]).floatValue());
            }
            return new Object[]{fArray};
        }
        Object object = Array.newInstance(clazz, stringArray.length);
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].indexOf(".") > 0) {
                stringArray[i] = stringArray[i].substring(0, stringArray[i].indexOf("."));
            }
            Array.setInt(object, i, new Integer(stringArray[i]));
        }
        return new Object[]{object};
    }

    static {
        try {
            BIGDECIMAL_TYPE = Class.forName("java.math.BigDecimal");
        }
        catch (ClassNotFoundException classNotFoundException) {
            BIGDECIMAL_TYPE = null;
        }
        try {
            BIGINT_TYPE = Class.forName("java.math.BigInteger");
        }
        catch (Exception exception) {
            BIGINT_TYPE = null;
        }
    }

    public class Candidate {
        private Class c;
        private Method m;

        public Candidate(Class clazz, Method method) {
            this.c = clazz;
            this.m = method;
        }

        public Class getCandidateClass() {
            return this.c;
        }

        public Method getCandidateMethod() {
            return this.m;
        }
    }
}

