/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import ise.library.GUIUtils;
import ise.library.KappaLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontDialog
extends JDialog {
    public boolean didCancel = false;
    private JLabel sample;
    private String font_name = "Serif";
    private String font_size = "10";
    private boolean bold_on = false;
    private boolean italic_on = false;
    private JList font_list;
    private JComboBox size_list;
    private JTextField font_selection;
    private JTextField size_selection;
    private static JFrame _parent = null;
    private static FontDialog _fd = null;

    public FontDialog(JFrame jFrame) {
        this(jFrame, null);
    }

    public FontDialog(JFrame jFrame, Font font) {
        super(jFrame, "Select Font", true);
        this.createUI(font);
    }

    private void createUI(Font font) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new KappaLayout());
        jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getSource().equals(FontDialog.this.font_list)) {
                    FontDialog.this.font_name = FontDialog.this.font_list.getSelectedValue().toString();
                    FontDialog.this.font_selection.setText(FontDialog.this.font_name);
                }
                FontDialog.this.setSample();
            }
        };
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.font_size = FontDialog.this.size_list.getSelectedItem().toString();
                FontDialog.this.setSample();
            }
        };
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new TitledBorder("Font:"));
        this.font_selection = new JTextField(this.font_name);
        this.font_selection.setEditable(false);
        jPanel2.add((Component)this.font_selection, "North");
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.font_list = new JList<String>(stringArray);
        this.font_list.setSelectionMode(1);
        this.font_list.setSelectedIndex(0);
        this.font_list.addListSelectionListener(listSelectionListener);
        jPanel2.add((Component)new JScrollPane(this.font_list), "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new TitledBorder("Size:"));
        String[] stringArray2 = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "38", "48", "72"};
        this.size_list = new JComboBox<String>(stringArray2);
        this.size_list.setEditable(true);
        this.size_list.addActionListener(actionListener);
        this.size_list.setSelectedIndex(2);
        jPanel3.add((Component)new JScrollPane(this.size_list), "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new KappaLayout());
        jPanel4.setBorder(new TitledBorder("Style:"));
        final JCheckBox jCheckBox = new JCheckBox("Bold");
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.bold_on = jCheckBox.isSelected();
                FontDialog.this.setSample();
            }
        });
        final JCheckBox jCheckBox2 = new JCheckBox("Italic");
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.italic_on = jCheckBox2.isSelected();
                FontDialog.this.setSample();
            }
        });
        jPanel4.add((Component)jCheckBox, "0, 0, 1, 1, W, wh, 5");
        jPanel4.add((Component)jCheckBox2, "0, 1, 1, 1, W, wh, 5");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.setBorder(new TitledBorder("Sample"));
        this.sample = new JLabel("AaBbYyZz", 0);
        jPanel5.add((Component)this.sample, "Center");
        this.setSample();
        KappaLayout kappaLayout = new KappaLayout();
        JPanel jPanel6 = new JPanel(kappaLayout);
        JButton jButton = new JButton("Ok");
        JButton jButton2 = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.didCancel = false;
                FontDialog.this.setVisible(false);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.didCancel = true;
                FontDialog.this.setVisible(false);
            }
        });
        jPanel6.add("0,0,1,1,0,w", jButton);
        jPanel6.add("1,0", KappaLayout.createHorizontalStrut(5, true));
        jPanel6.add("2,0,1,1,0,w", jButton2);
        kappaLayout.makeColumnsSameWidth(0, 2);
        jPanel.add("0, 0, 2, 3, N, wh", jPanel2);
        jPanel.add("2, 0, 1, 1", KappaLayout.createHorizontalStrut(5, true));
        jPanel.add("3, 0, 2, 1, N, w", jPanel3);
        jPanel.add("3, 1, 2, 2, S, wh", jPanel4);
        jPanel.add("0, 3, 1, 1", KappaLayout.createVerticalStrut(5, true));
        jPanel.add("0, 4, 5, 1, 0, wh", jPanel5);
        jPanel.add("5, 4, 1, 1", KappaLayout.createVerticalStrut(72));
        jPanel.add("0, 5, 1, 1", KappaLayout.createVerticalStrut(11));
        jPanel.add("0, 6, 5, 1", jPanel6);
        if (font != null) {
            String string = font.getFamily();
            int n = font.getStyle();
            int n2 = font.getSize();
            this.font_list.setSelectedValue(string, true);
            this.size_list.setSelectedItem(String.valueOf(n2));
            switch (n) {
                case 1: {
                    jCheckBox.setSelected(true);
                    break;
                }
                case 2: {
                    jCheckBox2.setSelected(true);
                    break;
                }
                case 3: {
                    jCheckBox.setSelected(true);
                    jCheckBox2.setSelected(true);
                }
            }
        }
        this.setContentPane(jPanel);
        this.pack();
    }

    private void setSample() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    int n = 0;
                    if (FontDialog.this.bold_on) {
                        ++n;
                    }
                    if (FontDialog.this.italic_on) {
                        n += 2;
                    }
                    int n2 = Integer.valueOf(FontDialog.this.font_size);
                    FontDialog.this.sample.setFont(new Font(FontDialog.this.font_name, n, n2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public Font getSelectedFont() {
        return this.sample.getFont();
    }

    public boolean didCancel() {
        return this.didCancel;
    }

    public static Font showFontDialog() {
        return FontDialog.showFontDialog(null);
    }

    public static Font showFontDialog(JFrame jFrame) {
        return FontDialog.showFontDialog(jFrame, null);
    }

    public static Font showFontDialog(JFrame jFrame, Font font) {
        if (jFrame == null || !jFrame.equals(_parent) || _fd == null) {
            _fd = new FontDialog(jFrame, font);
        }
        _parent = jFrame;
        GUIUtils.center(jFrame, _fd);
        _fd.pack();
        _fd.setVisible(true);
        Font font2 = _fd.getSelectedFont();
        _fd.dispose();
        if (!_fd.didCancel()) {
            return font2;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        FontDialog fontDialog = new FontDialog(jFrame);
        fontDialog.setVisible(true);
        System.out.println(fontDialog.getSelectedFont());
        System.exit(0);
    }
}

