/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class GUIUtils {
    public static void center(Component component, Component component2) {
        int n;
        Rectangle rectangle = component.getBounds();
        Dimension dimension = component2.getSize();
        int n2 = rectangle.x + (rectangle.width - dimension.width) / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = rectangle.y + (rectangle.height - dimension.height) / 2) < 0) {
            n = 0;
        }
        component2.setLocation(n2, n);
    }

    public static void centerOnScreen(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        component.setBounds((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2, dimension2.width, dimension2.height);
    }

    public static void fillScreen(Component component) {
        String string = System.getProperty("java.version");
        if ((string.startsWith("1.4") || string.startsWith("1.5")) && component instanceof Frame) {
            ((Frame)component).setExtendedState(6);
            return;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        component.setSize(dimension);
        GUIUtils.centerOnScreen(component);
    }

    public static Frame getRootFrame(Component component) {
        Container container = component.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = ((Component)container).getParent();
        }
        return null;
    }

    public static JFrame getRootJFrame(Component component) {
        Container container = component.getParent();
        while (container != null) {
            if (container instanceof JFrame) {
                return (JFrame)container;
            }
            container = ((Component)container).getParent();
        }
        return null;
    }

    public static Window getRootWindow(Component component) {
        Container container = component.getParent();
        while (container != null) {
            if (container instanceof Window) {
                return (Window)container;
            }
            container = ((Component)container).getParent();
        }
        return null;
    }

    public static Point getBestAnchorPoint(Component component, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        Point point = new Point(n3, n4);
        SwingUtilities.convertPointToScreen(point, component);
        Dimension dimension = component.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        boolean bl = false;
        boolean bl2 = false;
        if (point.x + dimension.width > dimension2.width && dimension.width < dimension2.width) {
            n3 += dimension2.width - point.x - dimension.width;
            bl = true;
        }
        if (point.y + dimension.height > dimension2.height && dimension.height < dimension2.height) {
            n4 += dimension2.height - point.y - dimension.height;
            bl2 = true;
        }
        if (bl && bl2 && component instanceof JPopupMenu) {
            if (n - dimension.width - 2 > 0) {
                n3 = n - dimension.width - 2;
            } else if (n2 - dimension.height - 2 > 0) {
                n4 = n2 - dimension.height - 2;
            }
        }
        return new Point(n3, n4);
    }

    public static void showPopupMenu(JPopupMenu jPopupMenu, Component component, int n, int n2) {
        Point point = GUIUtils.getBestAnchorPoint(component, n, n2);
        jPopupMenu.show(component, point.x, point.y);
    }
}

