/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import ise.library.UserPreferencesFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;

public class UserPreferences
extends AbstractPreferences {
    private Hashtable root = new Hashtable();
    private Hashtable children = new Hashtable();
    private boolean isRemoved = false;

    public UserPreferences(UserPreferences userPreferences, String string) {
        super(userPreferences, string);
        try {
            this.sync();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void putSpi(String string, String string2) {
        this.root.put(string, string2);
    }

    protected String getSpi(String string) {
        return (String)this.root.get(string);
    }

    protected void removeSpi(String string) {
        this.root.remove(string);
    }

    protected void removeNodeSpi() throws BackingStoreException {
        this.isRemoved = true;
    }

    protected String[] keysSpi() throws BackingStoreException {
        return this.root.keySet().toArray(new String[0]);
    }

    protected String[] childrenNamesSpi() throws BackingStoreException {
        return this.children.keySet().toArray(new String[0]);
    }

    protected AbstractPreferences childSpi(String string) {
        UserPreferences userPreferences = (UserPreferences)this.children.get(string);
        if (userPreferences == null || userPreferences.isRemoved()) {
            try {
                userPreferences = new UserPreferences(this, string);
                this.children.put(string, userPreferences);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                userPreferences = null;
            }
        }
        return userPreferences;
    }

    protected File getDirectory() {
        try {
            String string = this.name();
            if (string == null || string.equals("")) {
                string = "root";
            }
            File file = this.parent() == null ? UserPreferencesFactory.PREFS_ROOT : ((UserPreferences)this.parent()).getDirectory();
            File file2 = new File(file, string);
            file2.mkdirs();
            return file2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void syncSpi() throws BackingStoreException {
    }

    public void sync() throws BackingStoreException {
        try {
            File file;
            if (this.isRemoved()) {
                this.parent().sync();
                return;
            }
            if (this.root == null) {
                this.root = new Hashtable();
            }
            if (!(file = new File(this.getDirectory(), "prefs")).exists()) {
                return;
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            Hashtable hashtable = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
            this.root.putAll(hashtable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void flushSpi() throws BackingStoreException {
        try {
            if (this.root == null || this.root.size() == 0) {
                return;
            }
            if (this.isRemoved()) {
                this.parent().flush();
                return;
            }
            File file = this.getDirectory();
            if (file == null) {
                throw new BackingStoreException("Can't open directory.");
            }
            File file2 = new File(file, "prefs");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file2));
            objectOutputStream.writeObject(this.root);
            objectOutputStream.close();
        }
        catch (BackingStoreException backingStoreException) {
            throw backingStoreException;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isRemoved() {
        return this.isRemoved;
    }
}

