/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.MessageBufferOutputStream;
import java.util.Vector;

final class BufferCache {
    private static final int minBufferLength__ = 1024;
    private static final int minCharBufferLength__ = 256;
    private static int maxMemoryCached__ = 500000;
    private static int maxMemoryCachedPerConnection__ = 500000;
    private int numConnections_ = 1;
    private int memoryCached_ = 0;
    private Vector cachedBuffers_ = new Vector(12, 12);
    private Vector cachedOutputBuffers_ = new Vector(12, 12);
    private Vector cachedCharBuffers_ = new Vector(12, 12);

    BufferCache() {
    }

    synchronized void incrementConnectionCount() {
        ++this.numConnections_;
        maxMemoryCached__ += maxMemoryCachedPerConnection__;
    }

    synchronized void decrementConnectionCount() {
        --this.numConnections_;
        maxMemoryCached__ -= maxMemoryCachedPerConnection__;
    }

    synchronized MessageBufferOutputStream takeOutputBuffer() {
        if (this.cachedOutputBuffers_.isEmpty()) {
            return new MessageBufferOutputStream();
        }
        MessageBufferOutputStream messageBufferOutputStream = (MessageBufferOutputStream)this.cachedOutputBuffers_.firstElement();
        this.cachedOutputBuffers_.removeElementAt(0);
        return messageBufferOutputStream;
    }

    synchronized void returnOutputBuffer(MessageBufferOutputStream messageBufferOutputStream) {
        messageBufferOutputStream.reset();
        this.cachedOutputBuffers_.addElement(messageBufferOutputStream);
    }

    synchronized byte[] takeBuffer(int n) {
        int n2 = 0;
        while (n2 < this.cachedBuffers_.size()) {
            byte[] byArray = (byte[])this.cachedBuffers_.elementAt(n2);
            if (byArray.length >= n) {
                this.cachedBuffers_.removeElementAt(n2);
                this.memoryCached_ -= byArray.length;
                return byArray;
            }
            ++n2;
        }
        return new byte[Math.max(n, 1024)];
    }

    synchronized void returnBuffer(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        boolean bl = false;
        this.memoryCached_ += byArray.length;
        int n = 0;
        while (n < this.cachedBuffers_.size()) {
            if (((byte[])this.cachedBuffers_.elementAt(n)).length > byArray.length) {
                this.cachedBuffers_.insertElementAt(byArray, n);
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.cachedBuffers_.addElement(byArray);
        }
    }

    synchronized char[] takeCharBuffer(int n) {
        int n2 = 0;
        while (n2 < this.cachedCharBuffers_.size()) {
            char[] cArray = (char[])this.cachedCharBuffers_.elementAt(n2);
            if (cArray.length >= n) {
                this.cachedCharBuffers_.removeElementAt(n2);
                return cArray;
            }
            ++n2;
        }
        return new char[Math.max(n, 256)];
    }

    synchronized void returnCharBuffer(char[] cArray) {
        if (cArray == null) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.cachedCharBuffers_.size()) {
            if (((char[])this.cachedCharBuffers_.elementAt(n)).length > cArray.length) {
                this.cachedCharBuffers_.insertElementAt(cArray, n);
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.cachedCharBuffers_.addElement(cArray);
        }
    }
}

