/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.CallableStatement;
import interbase.interclient.CharacterEncodings;
import interbase.interclient.DatabaseMetaData;
import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.EscapeProcessor;
import interbase.interclient.Globals;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.InvalidOperationException;
import interbase.interclient.JDBCNet;
import interbase.interclient.MessageBufferOutputStream;
import interbase.interclient.PreparedStatement;
import interbase.interclient.RecvMessage;
import interbase.interclient.ResultSet;
import interbase.interclient.Statement;
import interbase.interclient.UnsupportedCharacterSetException;
import interbase.interclient.Utils;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;

public final class Connection
implements java.sql.Connection {
    private int sessionRef_ = 0;
    String database_;
    String serverName_;
    int port_;
    int attachmentSQLDialect_;
    private Properties properties_;
    boolean open_ = true;
    boolean readOnly_ = false;
    private int isolation_ = 8;
    private boolean enableRecVersion_ = true;
    private int lockResolution_ = 0;
    private boolean enableAutoCommit_ = true;
    private Hashtable tableLocks_ = null;
    boolean transactionStartedOnClient_ = false;
    boolean transactionStartedOnServer_ = false;
    DatabaseMetaData databaseMetaData_;
    Vector openStatements_;
    Vector openPreparedStatements_;
    private SQLWarning sqlWarnings_ = null;
    JDBCNet jdbcNet_;
    String ianaCharacterEncoding_;
    private static final String defaultEncoding__ = "8859_1";
    public static final int TRANSACTION_NONE = 0;
    public static final int TRANSACTION_READ_UNCOMMITTED = 1;
    public static final int TRANSACTION_READ_COMMITTED = 2;
    public static final int TRANSACTION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_SERIALIZABLE = 8;
    public static final int TRANSACTION_SNAPSHOT = 8;
    public static final int TRANSACTION_SNAPSHOT_TABLE_STABILITY = 16;
    public static final int LOCK_RESOLUTION_WAIT = 0;
    public static final int LOCK_RESOLUTION_NO_WAIT = 1;
    public static final int IGNORE_UNCOMMITTED_RECORD_VERSIONS_ON_READ = 1;
    public static final int RECOGNIZE_UNCOMMITTED_RECORD_VERSIONS_ON_READ = 0;
    public static final int TABLELOCK_SHARED_WRITE = 0;
    public static final int TABLELOCK_SHARED_READ = 1;
    public static final int TABLELOCK_PROTECTED_WRITE = 2;
    public static final int TABLELOCK_PROTECTED_READ = 4;

    Connection(int n, String string, int n2, String string2, Properties properties) throws SQLException {
        this.serverName_ = string;
        this.port_ = n2;
        this.database_ = string2;
        this.properties_ = (Properties)((Hashtable)properties).clone();
        if (this.properties_ == null) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__connection_properties__null__);
        }
        this.addRequiredPropertiesAndSetConverters();
        this.openStatements_ = new Vector();
        this.openPreparedStatements_ = new Vector();
        this.connect(n);
    }

    private void addRequiredPropertiesAndSetConverters() {
        this.ianaCharacterEncoding_ = (String)((Hashtable)this.properties_).get("charSet");
        if (this.ianaCharacterEncoding_ == null || this.ianaCharacterEncoding_.equals("NONE")) {
            this.ianaCharacterEncoding_ = defaultEncoding__;
            ((Hashtable)this.properties_).put("charSet", "NONE");
        }
    }

    void checkForClosedConnection() throws SQLException {
        if (!this.open_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__connection_closed__);
        }
    }

    private void connect(int n) throws SQLException {
        try {
            this.jdbcNet_ = new JDBCNet(n, this.serverName_, this.port_, ByteToCharConverter.getConverter((String)this.ianaCharacterEncoding_), CharToByteConverter.getConverter((String)this.ianaCharacterEncoding_));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharacterSetException(ErrorKey.unsupportedCharacterSet__0__, this.ianaCharacterEncoding_);
        }
        this.databaseMetaData_ = new DatabaseMetaData(this, this.jdbcNet_);
        Date date = new Date();
        try {
            this.remote_ATTACH_DATABASE();
        }
        catch (SQLException sQLException) {
            try {
                this.jdbcNet_.disconnectSocket();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    private void send_properties(MessageBufferOutputStream messageBufferOutputStream, Properties properties) throws SQLException {
        messageBufferOutputStream.writeByte(((Hashtable)properties).size());
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            byte[] byArray;
            String string = (String)enumeration.nextElement();
            if (string.equals("user")) {
                this.databaseMetaData_.userName_ = properties.getProperty(string).toUpperCase();
                messageBufferOutputStream.writeLDSQLText("user");
                byArray = this.jdbcNet_.crypter_.stringCrypt(this.databaseMetaData_.userName_);
                messageBufferOutputStream.writeLDBytes(byArray);
                continue;
            }
            if (string.equals("password")) {
                messageBufferOutputStream.writeLDSQLText(string);
                byArray = this.jdbcNet_.crypter_.stringCrypt(properties.getProperty(string));
                messageBufferOutputStream.writeLDBytes(byArray);
                continue;
            }
            if (string.equals("roleName")) {
                messageBufferOutputStream.writeLDSQLText(string);
                messageBufferOutputStream.writeLDSQLText(properties.getProperty(string).toUpperCase());
                continue;
            }
            if (string.equals("charSet")) {
                messageBufferOutputStream.writeLDSQLText(string);
                messageBufferOutputStream.writeLDSQLText(CharacterEncodings.getInterBaseCharacterSetName(properties.getProperty(string)));
                continue;
            }
            messageBufferOutputStream.writeLDSQLText(string);
            messageBufferOutputStream.writeLDSQLText(properties.getProperty(string));
        }
    }

    private void remote_ATTACH_DATABASE() throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(8);
        this.send_properties(messageBufferOutputStream, this.properties_);
        messageBufferOutputStream.writeShort(this.jdbcNet_.socketTimeout_);
        messageBufferOutputStream.writeLDSQLText(this.database_);
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            this.sessionRef_ = recvMessage.readInt();
            this.databaseMetaData_.databaseProductVersion_ = recvMessage.readLDSQLText();
            this.databaseMetaData_.ibMajorVersion_ = recvMessage.readInt();
            this.databaseMetaData_.odsMajorVersion_ = recvMessage.readInt();
            this.databaseMetaData_.odsMinorVersion_ = recvMessage.readInt();
            this.databaseMetaData_.pageSize_ = recvMessage.readInt();
            this.databaseMetaData_.pageAllocation_ = recvMessage.readInt();
            this.databaseMetaData_.databaseSQLDialect_ = recvMessage.readInt();
            this.attachmentSQLDialect_ = recvMessage.readInt();
            this.databaseMetaData_.databaseReadOnly_ = recvMessage.readBoolean();
            this.setWarning(recvMessage.get_WARNINGS());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
    }

    private boolean isCompatibleIBVersion(String string) {
        int n = 0;
        while (n < Globals.compatibleIBVersions__.length) {
            if (this.databaseMetaData_.ibMajorVersion_ == Globals.compatibleIBVersions__[n]) {
                return true;
            }
            ++n;
        }
        int n2 = string.indexOf(45);
        int n3 = 0;
        while (n3 < Globals.compatibleIBVersions__.length) {
            if (string.charAt(n2 + 2) == String.valueOf(Globals.compatibleIBVersions__[n3]).charAt(0)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        if (this.open_) {
            this.close();
        }
        super.finalize();
    }

    public synchronized java.sql.Statement createStatement() throws SQLException {
        this.checkForClosedConnection();
        Statement statement = new Statement(this.jdbcNet_, this);
        this.openStatements_.addElement(statement);
        return statement;
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkForClosedConnection();
        PreparedStatement preparedStatement = new PreparedStatement(this.jdbcNet_, this, string);
        this.openPreparedStatements_.addElement(preparedStatement);
        return preparedStatement;
    }

    public synchronized java.sql.CallableStatement prepareCall(String string) throws SQLException {
        this.checkForClosedConnection();
        return new CallableStatement(this.jdbcNet_, this, string);
    }

    public String nativeSQL(String string) throws SQLException {
        EscapeProcessor escapeProcessor = new EscapeProcessor();
        return escapeProcessor.doEscapeProcessing(string);
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.checkForClosedConnection();
        this.enableAutoCommit_ = bl;
        if (!this.transactionStartedOnClient_) {
            return;
        }
        this.remote_COMMIT(false);
        this.local_CloseResultSets(this.openStatements_);
        this.local_CloseResultSets(this.openPreparedStatements_);
        this.transactionStartedOnClient_ = false;
        this.transactionStartedOnServer_ = false;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.enableAutoCommit_;
    }

    private void local_CloseStatements(Vector vector) throws SQLException {
        while (vector.size() != 0) {
            ((Statement)vector.lastElement()).local_Close();
        }
    }

    private void local_CloseResultSets(Vector vector) throws SQLException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ResultSet resultSet = ((Statement)enumeration.nextElement()).resultSet_;
            if (resultSet == null) continue;
            resultSet.local_Close();
        }
    }

    void local_Close() throws SQLException {
        this.local_CloseStatements(this.openStatements_);
        this.local_CloseStatements(this.openPreparedStatements_);
        this.open_ = false;
    }

    public synchronized void commit() throws SQLException {
        this.checkForClosedConnection();
        if (this.enableAutoCommit_) {
            return;
        }
        if (!this.transactionStartedOnClient_) {
            return;
        }
        this.remote_COMMIT(false);
        this.local_CloseResultSets(this.openStatements_);
        this.local_CloseResultSets(this.openPreparedStatements_);
        this.transactionStartedOnClient_ = false;
        this.transactionStartedOnServer_ = false;
    }

    private void remote_COMMIT(boolean bl) throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(13);
        messageBufferOutputStream.writeBoolean(bl);
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            this.setWarning(recvMessage.get_WARNINGS());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
    }

    public synchronized void rollback() throws SQLException {
        this.checkForClosedConnection();
        if (this.enableAutoCommit_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__commit_or_rollback_under_autocommit__);
        }
        if (!this.transactionStartedOnClient_) {
            return;
        }
        this.remote_ROLLBACK();
        this.local_CloseResultSets(this.openStatements_);
        this.local_CloseResultSets(this.openPreparedStatements_);
        this.transactionStartedOnClient_ = false;
        this.transactionStartedOnServer_ = false;
    }

    private void remote_ROLLBACK() throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(14);
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            this.setWarning(recvMessage.get_WARNINGS());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
    }

    public synchronized void close() throws SQLException {
        if (!this.open_) {
            return;
        }
        SQLException sQLException = null;
        try {
            this.remote_DETACH_DATABASE();
        }
        catch (SQLException sQLException2) {
            sQLException = Utils.accumulateSQLExceptions(sQLException, sQLException2);
        }
        this.local_Close();
        try {
            this.jdbcNet_.disconnectSocket();
        }
        catch (SQLException sQLException3) {
            sQLException = Utils.accumulateSQLExceptions(sQLException, sQLException3);
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    private void remote_DETACH_DATABASE() throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(9);
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            this.setWarning(recvMessage.get_WARNINGS());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
    }

    public boolean isClosed() throws SQLException {
        return !this.open_;
    }

    public synchronized java.sql.DatabaseMetaData getMetaData() throws SQLException {
        return this.databaseMetaData_;
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.checkForClosedConnection();
        if (this.transactionStartedOnClient_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__transaction_in_progress__);
        }
        this.readOnly_ = bl;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly_;
    }

    public void setCatalog(String string) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.checkForClosedConnection();
        if (this.transactionStartedOnClient_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__transaction_in_progress__);
        }
        switch (n) {
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                this.isolation_ = n;
                break;
            }
            case 1: {
                throw new DriverNotCapableException(ErrorKey.driverNotCapable__isolation__);
            }
            default: {
                throw new InvalidArgumentException(ErrorKey.invalidArgument__isolation_0__, (Object)String.valueOf(n));
            }
        }
    }

    public int getTransactionIsolation() throws SQLException {
        return this.isolation_;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarnings_;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.sqlWarnings_ = null;
    }

    synchronized void setWarning(SQLWarning sQLWarning) {
        if (this.sqlWarnings_ == null) {
            this.sqlWarnings_ = sQLWarning;
        } else {
            this.sqlWarnings_.setNextException(sQLWarning);
        }
    }

    void send_TransactionConfigData(MessageBufferOutputStream messageBufferOutputStream) throws SQLException {
        if (!this.transactionStartedOnServer_) {
            messageBufferOutputStream.writeBoolean(true);
            messageBufferOutputStream.writeBoolean(this.readOnly_);
            messageBufferOutputStream.writeByte(this.isolation_);
            messageBufferOutputStream.writeBoolean(this.enableRecVersion_);
            messageBufferOutputStream.writeByte(this.lockResolution_);
            messageBufferOutputStream.writeBoolean(this.enableAutoCommit_);
            messageBufferOutputStream.writeBoolean(false);
            if (this.tableLocks_ == null) {
                messageBufferOutputStream.writeInt(0);
            } else {
                messageBufferOutputStream.writeInt(this.tableLocks_.size());
                Enumeration enumeration = this.tableLocks_.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    messageBufferOutputStream.writeLDSQLText(string);
                    messageBufferOutputStream.writeByte((Integer)this.tableLocks_.get(string));
                }
            }
        } else {
            messageBufferOutputStream.writeBoolean(false);
        }
    }

    public synchronized java.sql.Statement createStatement(int n, int n2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Map getTypeMap() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setLockResolution(int n) throws SQLException {
        this.checkForClosedConnection();
        if (this.transactionStartedOnClient_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__transaction_in_progress__);
        }
        switch (n) {
            case 0: 
            case 1: {
                this.lockResolution_ = n;
                break;
            }
            default: {
                throw new InvalidArgumentException(ErrorKey.invalidArgument__lock_resolution__);
            }
        }
    }

    public synchronized int getLockResolution() throws SQLException {
        return this.lockResolution_;
    }

    public synchronized void setVersionAcknowledgement(int n) throws SQLException {
        this.checkForClosedConnection();
        if (this.transactionStartedOnClient_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__transaction_in_progress__);
        }
        if (n == 1) {
            this.enableRecVersion_ = true;
        } else if (n == 0) {
            this.enableRecVersion_ = false;
        } else {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__version_acknowledgement_mode__);
        }
    }

    public synchronized int getVersionAcknowledgement() throws SQLException {
        if (this.enableRecVersion_) {
            return 1;
        }
        return 0;
    }

    public synchronized void setTableLock(String string, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized int getTableLock(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void commitRetain() throws SQLException {
        this.checkForClosedConnection();
        if (this.enableAutoCommit_) {
            return;
        }
        if (!this.transactionStartedOnClient_) {
            return;
        }
        this.remote_COMMIT(true);
        this.local_CloseResultSets(this.openStatements_);
        this.local_CloseResultSets(this.openPreparedStatements_);
    }

    public synchronized int getTransactionId() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized boolean inTransaction() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized int getAttachmentSQLDialect() throws SQLException {
        return this.attachmentSQLDialect_;
    }
}

