/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.CharacterEncodingException;
import interbase.interclient.ErrorKey;
import interbase.interclient.UnsupportedCharacterSetException;
import interbase.interclient.Utils;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import sun.io.CharToByteConverter;

final class MessageBufferOutputStream
extends ByteArrayOutputStream {
    private static final int MIN_OUTPUT_BUFFER_SIZE__ = 1024;
    private static final int HEADER_LENGTH__ = 8;
    private CharToByteConverter ctb_;
    private String encoding_;

    MessageBufferOutputStream() {
        super(1024);
        this.count = 8;
    }

    void setConverter(CharToByteConverter charToByteConverter) {
        this.ctb_ = charToByteConverter;
        this.encoding_ = this.ctb_.getCharacterEncoding();
    }

    String getOpcode() {
        return null;
    }

    public synchronized void reset() {
        this.count = 8;
    }

    void writeFirstInt(int n) {
        this.buf[3] = (byte)(n >>> 24 & 0xFF);
        this.buf[2] = (byte)(n >>> 16 & 0xFF);
        this.buf[1] = (byte)(n >>> 8 & 0xFF);
        this.buf[0] = (byte)(n >>> 0 & 0xFF);
    }

    void writeSecondInt(int n) {
        this.buf[7] = (byte)(n >>> 24 & 0xFF);
        this.buf[6] = (byte)(n >>> 16 & 0xFF);
        this.buf[5] = (byte)(n >>> 8 & 0xFF);
        this.buf[4] = (byte)(n >>> 0 & 0xFF);
    }

    int messageSize() {
        return this.size() - 8;
    }

    private void align(int n) {
        int n2 = this.count % n;
        if (n2 != 0) {
            int n3 = 0;
            while (n3 < n - n2) {
                this.write(0);
                ++n3;
            }
        }
    }

    void writeBoolean(boolean bl) {
        this.write(bl ? 1 : 0);
    }

    void writeByte(int n) {
        this.write(n);
    }

    void writeShort(int n) {
        this.align(2);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    void writeChar(int n) {
        this.align(2);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    void writeInt(int n) {
        this.align(4);
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    void writeLong(long l) {
        this.align(8);
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)(l >>> 0) & 0xFF);
    }

    void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    void writeUnicodeChars(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.write(c >>> 8 & 0xFF);
            this.write(c >>> 0 & 0xFF);
            ++n2;
        }
    }

    void writeLDBytes(byte[] byArray) {
        this.writeLDBytes(byArray.length, byArray);
    }

    void writeLDBytes(int n, byte[] byArray) {
        this.writeShort(n + 1);
        this.write(byArray, 0, n);
        this.write(0);
    }

    void writeLDChars(String string, char[] cArray, byte[] byArray) throws SQLException {
        int n = string.length();
        try {
            int n2 = 0;
            while (n2 < n) {
                cArray[n2] = string.charAt(n2);
                ++n2;
            }
            int n3 = this.ctb_.convert(cArray, 0, n, byArray, 0, byArray.length);
            this.writeLDBytes(n3, byArray);
        }
        catch (CharConversionException charConversionException) {
            throw new CharacterEncodingException(ErrorKey.characterEncoding__write_0__, Utils.getMessage(charConversionException));
        }
    }

    void writeLDChars(String string) throws SQLException {
        try {
            this.writeLDBytes(string.getBytes(this.encoding_));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharacterSetException(ErrorKey.unsupportedCharacterSet__0__, this.encoding_);
        }
    }

    void writeLDSQLText(String string) throws SQLException {
        try {
            this.writeLDBytes(string.getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharacterSetException(ErrorKey.unsupportedCharacterSet__0__, "8859_1");
        }
    }

    void writeTimestampId(int[] nArray) {
        this.writeInt(nArray[0]);
        this.writeInt(nArray[1]);
    }

    void writeBlobId(int[] nArray) {
        this.writeInt(nArray[0]);
        this.writeInt(nArray[1]);
    }

    void writeArrayId(int[] nArray) {
        this.writeInt(nArray[0]);
        this.writeInt(nArray[1]);
    }
}

