/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.ColumnIndexOutOfBoundsException;
import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.IBTypes;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.JDBCNet;
import interbase.interclient.MessageBufferOutputStream;
import interbase.interclient.RecvMessage;
import interbase.interclient.ResultSet;
import java.sql.SQLException;

public final class ResultSetMetaData
implements java.sql.ResultSetMetaData {
    ResultSet resultSet_;
    JDBCNet jdbcNet_;
    boolean metaDataRetrieved_ = false;
    boolean[] writables_ = null;
    public static final int columnNoNulls = 0;
    public static final int columnNullable = 1;
    public static final int columnNullableUnknown = 2;

    ResultSetMetaData(ResultSet resultSet, JDBCNet jDBCNet) {
        this.resultSet_ = resultSet;
        this.jdbcNet_ = jDBCNet;
    }

    public int getColumnCount() throws SQLException {
        this.resultSet_.checkForClosedCursor();
        return this.resultSet_.resultCols_;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        return true;
    }

    public boolean isSearchable(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        return false;
    }

    public int isNullable(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        try {
            if (this.resultSet_.resultNullables_[n - 1]) {
                return 1;
            }
            return 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }

    public boolean isSigned(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        try {
            switch (this.resultSet_.resultTypes_[n - 1]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 18: 
                case 19: {
                    return true;
                }
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        try {
            switch (this.resultSet_.resultTypes_[n - 1]) {
                case 1: {
                    return 6;
                }
                case 7: {
                    return 8;
                }
                case 2: {
                    return 11;
                }
                case 6: 
                case 19: {
                    return 13;
                }
                case 3: 
                case 4: 
                case 17: 
                case 18: {
                    return 22;
                }
                case 5: {
                    return 24;
                }
                case 8: 
                case 9: {
                    return this.resultSet_.resultCharLengths_[n - 1];
                }
                case 0: 
                case 10: 
                case 12: 
                case 14: {
                    return 0;
                }
                case 11: 
                case 15: 
                case 16: {
                    return this.resultSet_.resultPrecisions_[n - 1];
                }
            }
            return 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }

    public String getColumnLabel(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        try {
            return this.resultSet_.resultColumnLabels_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }

    public String getColumnName(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        try {
            return this.resultSet_.resultColumnNames_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }

    public String getSchemaName(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        return "";
    }

    public int getPrecision(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        try {
            switch (this.resultSet_.resultTypes_[n - 1]) {
                case 8: 
                case 9: {
                    return this.resultSet_.resultCharLengths_[n - 1];
                }
                case 14: {
                    return this.resultSet_.arrayDescriptors_[n - 1].elementPrecision_;
                }
            }
            return this.resultSet_.resultPrecisions_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }

    public int getScale(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        try {
            switch (this.resultSet_.resultTypes_[n - 1]) {
                case 8: 
                case 9: {
                    return 0;
                }
                case 14: {
                    return this.resultSet_.arrayDescriptors_[n - 1].elementScale_;
                }
            }
            return this.resultSet_.resultScales_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }

    public synchronized String getTableName(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        try {
            return this.resultSet_.resultTableNames_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }

    public String getCatalogName(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        try {
            return IBTypes.getSQLType(this.resultSet_.resultTypes_[n - 1]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        try {
            return IBTypes.getIBTypeName(this.resultSet_.resultTypes_[n - 1]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }

    public boolean isReadOnly(int n) throws SQLException {
        return !this.isWritable(n);
    }

    public synchronized boolean isWritable(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        try {
            if (this.metaDataRetrieved_) {
                return this.writables_[n - 1];
            }
            this.remote_GET_RESULT_COLUMN_META_DATA();
            this.metaDataRetrieved_ = true;
            return this.writables_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        return false;
    }

    private void remote_GET_RESULT_COLUMN_META_DATA() throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(29);
        messageBufferOutputStream.writeInt(this.resultSet_.statement_.statementRef_);
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            int n = this.getColumnCount();
            this.writables_ = new boolean[n];
            int n2 = 0;
            while (n2 < n) {
                this.writables_[n2] = recvMessage.readBoolean();
                ++n2;
            }
            this.resultSet_.setWarning(recvMessage.get_WARNINGS());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
    }

    public synchronized String getColumnClassName(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public int getArrayBaseType(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        try {
            if (this.resultSet_.resultTypes_[n - 1] != 14) {
                throw new InvalidArgumentException(ErrorKey.invalidArgument__not_array_column__);
            }
            if (this.resultSet_.arrayDescriptors_[n - 1] != null) {
                return IBTypes.getSQLType(this.resultSet_.arrayDescriptors_[n - 1].elementDataType_);
            }
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__input_array_metadata__);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }

    public int[][] getArrayDimensions(int n) throws SQLException {
        this.resultSet_.checkForClosedCursor();
        try {
            if (this.resultSet_.resultTypes_[n - 1] != 14) {
                throw new InvalidArgumentException(ErrorKey.invalidArgument__not_array_column__);
            }
            if (this.resultSet_.arrayDescriptors_[n - 1] != null) {
                return this.resultSet_.arrayDescriptors_[n - 1].getDimensions();
            }
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__input_array_metadata__);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }
}

