/*
 * Decompiled with CFR 0.152.
 */
package ymsg.test;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import ymsg.network.AccountLockedException;
import ymsg.network.DirectConnectionHandler;
import ymsg.network.HTTPConnectionHandler;
import ymsg.network.LoginRefusedException;
import ymsg.network.SOCKSConnectionHandler;
import ymsg.network.Session;
import ymsg.network.YahooChatCategory;
import ymsg.network.YahooChatLobby;
import ymsg.network.YahooChatRoom;
import ymsg.network.YahooConference;
import ymsg.network.YahooGroup;
import ymsg.network.YahooUser;
import ymsg.network.event.SessionAdapter;
import ymsg.network.event.SessionChatEvent;
import ymsg.network.event.SessionConferenceEvent;
import ymsg.network.event.SessionErrorEvent;
import ymsg.network.event.SessionEvent;
import ymsg.network.event.SessionExceptionEvent;
import ymsg.network.event.SessionFileTransferEvent;
import ymsg.network.event.SessionFriendEvent;
import ymsg.support.MessageDecoder;

public class TestClient
extends Frame
implements ActionListener,
ItemListener {
    protected TextField[] inputTF;
    protected Label[] inputLab;
    protected TextArea outputTA;
    protected List modeL;
    protected Button sendB;
    protected Button dumpB;
    protected Button lobbyB;
    protected Button confB;
    protected Vector conferences;
    protected YahooChatCategory rootCategory = null;
    protected YahooChatLobby currentLobby = null;
    protected YahooConference currentConf = null;
    protected MessageDecoder decoder;
    private static final String[][] LABELS = new String[][]{{"To", "Message", "-", "-"}, {"To", "-", "-", "-"}, {"Identity", "-", "-", "-"}, {"To", "Filename", "Message", "-"}, {"Friend", "Group", "-", "-"}, {"Friend", "Group", "-", "-"}, {"Friend", "Message", "-", "-"}, {"Friend", "On/off", "-", "-"}, {"To list", "Message", "-", "-"}, {"Room", "-", "-", "-"}, {"Room", "Message", "-", "-"}, {"Room", "To", "Message", "-"}, {"Room", "Message", "-", "-"}, {"Room", "-", "-", "-"}, {"Room:Lobby", "-", "-", "-"}, {"Message", "-", "-", "-"}, {"-", "-", "-", "-"}, {"Username", "Password", "Connect", "-"}, {"-", "-", "-", "-"}, {"-", "-", "-", "-"}, {"-", "-", "-", "-"}, {"-", "-", "-", "-"}};
    private static final int PARAMS = 3;
    private static final String[] MODES = new String[]{"Send message", "Send BUZZ", "Set identity", "Send file tf", "Friend: add", "Friend: remove", "Friend: reject", "Friend: ignore", "Conference: create", "Conference: accept", "Conference: decline", "Conference: extend", "Conference: message", "Conference: leave", "Chat: login", "Chat: message", "Chat: logoff", "Login", "Logoff", "Refresh", "Test 1", "Test 2"};
    private static final int[] MAPPINGS = new int[]{256, 257, 258, 259, 512, 513, 514, 515, 768, 769, 770, 771, 772, 773, 1024, 1025, 1026, 3840, 3841, 3842, 3856, 3857};
    private String[][] inputCache;
    private int currentMode;
    private static final String FT_DIR = "/tmp";
    protected Session session;

    public TestClient(String string, String string2, String string3) {
        super("jYMSG Test Client v2.01 : " + string);
        int n;
        this.addWindowListener(new WindowHandler());
        this.setBackground(new Color(0xCCCCCC));
        this.outputTA = new TextArea(12, 40);
        this.outputTA.setEditable(false);
        Panel panel = new Panel(new BorderLayout());
        Panel panel2 = new Panel(new BorderLayout());
        this.modeL = new List(5);
        this.modeL.addItemListener(this);
        for (n = 0; n < MODES.length; ++n) {
            this.modeL.add(MODES[n]);
        }
        this.sendB = new Button("Send");
        this.sendB.addActionListener(this);
        panel2.add((Component)this.modeL, "Center");
        panel2.add((Component)this.sendB, "East");
        panel.add((Component)panel2, "North");
        this.inputLab = new Label[3];
        this.inputTF = new TextField[3];
        panel2 = new Panel(new BorderLayout());
        Panel panel3 = new Panel(new GridLayout(0, 1));
        panel2.add((Component)panel3, "West");
        Panel panel4 = new Panel(new GridLayout(0, 1));
        panel2.add((Component)panel4, "Center");
        for (n = 0; n < 3; ++n) {
            this.inputLab[n] = new Label("----------------:", 2);
            panel3.add(this.inputLab[n]);
            this.inputTF[n] = new TextField("");
            panel4.add(this.inputTF[n]);
        }
        panel.add((Component)panel2, "Center");
        panel2 = new Panel(new GridLayout(1, 0));
        this.dumpB = new Button("Dump");
        this.dumpB.addActionListener(this);
        panel2.add(this.dumpB);
        this.lobbyB = new Button("Lobby");
        this.lobbyB.addActionListener(this);
        panel2.add(this.lobbyB);
        this.confB = new Button("Conf.");
        this.confB.addActionListener(this);
        panel2.add(this.confB);
        panel.add((Component)panel2, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.outputTA, "Center");
        this.add((Component)panel, "South");
        System.getProperties().put("ymsg.debug", "true");
        this.inputCache = new String[MODES.length][3];
        n = this.findMode(3840);
        this.inputCache[n][0] = string;
        this.inputCache[n][1] = string2;
        this.inputCache[n][2] = string3;
        this.pack();
        this.show();
        this.modeL.select(n);
        this.updateSelectedMode();
        this.decoder = new MessageDecoder();
        this.conferences = new Vector();
    }

    private void setInputCache(int n, int n2, String string) {
        this.inputCache[n][n2] = string;
        if (this.currentMode == n) {
            this.inputTF[n2].setText(string);
        }
    }

    private int findMode(int n) {
        for (int i = 0; i < MAPPINGS.length; ++i) {
            if (MAPPINGS[i] != n) continue;
            return i;
        }
        return -1;
    }

    private void attemptLogin() throws Exception {
        int n = this.findMode(3840);
        String string = this.inputCache[n][0];
        String string2 = this.inputCache[n][1];
        try {
            this.session.login(string, string2);
        }
        catch (AccountLockedException accountLockedException) {
            System.out.println("Your account is locked");
            if (accountLockedException.getWebPage() != null) {
                System.out.println("Please visit: " + accountLockedException.getWebPage().toString());
            }
            throw accountLockedException;
        }
        catch (LoginRefusedException loginRefusedException) {
            System.out.println("Yahoo refused our connection.  Username/password incorrect?");
            throw loginRefusedException;
        }
        if (this.session.getSessionStatus() == 2) {
            System.out.println(this.session.getConnectionHandler().toString());
        } else {
            System.out.println("Sorry, there was a problem connecting");
        }
    }

    protected void updateSelectedMode() {
        int n;
        for (n = 0; n < 3; ++n) {
            this.inputCache[this.currentMode][n] = this.inputTF[n].getText();
        }
        this.currentMode = this.modeL.getSelectedIndex();
        if (this.currentMode < 0) {
            this.currentMode = 0;
        }
        for (n = 0; n < 3; ++n) {
            this.inputLab[n].setText(LABELS[this.currentMode][n] + " :");
            this.inputTF[n].setEnabled(!LABELS[this.currentMode][n].equals("-"));
        }
        for (n = 0; n < 3; ++n) {
            this.inputTF[n].setText(this.inputCache[this.currentMode][n]);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object = actionEvent.getSource();
        String[] stringArray = new String[this.inputTF.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = this.inputTF[n].getText();
        }
        try {
            if (object == this.sendB) {
                n = 0;
                switch (MAPPINGS[this.modeL.getSelectedIndex()]) {
                    case 256: {
                        this.session.sendMessage(stringArray[0], stringArray[1]);
                        n = 2;
                        break;
                    }
                    case 257: {
                        this.session.sendBuzz(stringArray[0]);
                        break;
                    }
                    case 258: {
                        n = 1;
                        break;
                    }
                    case 259: {
                        this.session.sendFileTransfer(stringArray[0], stringArray[1], stringArray[2]);
                        n = 7;
                        break;
                    }
                    case 512: {
                        this.session.addFriend(stringArray[0], stringArray[1]);
                        n = 3;
                        break;
                    }
                    case 513: {
                        this.session.removeFriend(stringArray[0], stringArray[1]);
                        n = 3;
                        break;
                    }
                    case 515: {
                        this.session.ignoreContact(stringArray[0], stringArray[1].equalsIgnoreCase("on"));
                        n = 3;
                        break;
                    }
                    case 768: {
                        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0], ",");
                        String[] stringArray2 = new String[stringTokenizer.countTokens()];
                        for (int i = 0; i < stringArray2.length; ++i) {
                            stringArray2[i] = stringTokenizer.nextToken().trim();
                        }
                        YahooConference yahooConference = this.session.createConference(stringArray2, stringArray[1]);
                        if (!this.conferences.contains(yahooConference)) {
                            this.conferences.addElement(yahooConference);
                        }
                        n = 3;
                        break;
                    }
                    case 769: {
                        this.session.acceptConferenceInvite(this.currentConf);
                        n = 1;
                        break;
                    }
                    case 770: {
                        this.session.declineConferenceInvite(this.currentConf, stringArray[1]);
                        n = 3;
                        break;
                    }
                    case 771: {
                        this.session.extendConference(this.currentConf, stringArray[1], stringArray[2]);
                        n = 6;
                        break;
                    }
                    case 772: {
                        this.session.sendConferenceMessage(this.currentConf, stringArray[1]);
                        n = 2;
                        break;
                    }
                    case 773: {
                        this.session.leaveConference(this.currentConf);
                        n = 1;
                        break;
                    }
                    case 1024: {
                        if (this.currentLobby != null) {
                            this.session.chatLogin(this.currentLobby);
                        }
                        n = 0;
                        break;
                    }
                    case 1025: {
                        this.outputTA.append("[" + this.currentLobby.getNetworkName() + "]\n  " + this.session.getPrimaryIdentity() + " : " + stringArray[0] + "\n");
                        this.session.sendChatMessage(stringArray[0]);
                        n = 1;
                        break;
                    }
                    case 1026: {
                        this.session.chatLogout();
                        n = 0;
                        break;
                    }
                    case 3840: {
                        this.updateSelectedMode();
                        new LoginThread();
                        n = 2;
                        break;
                    }
                    case 3841: {
                        this.session.logout();
                        n = 0;
                        break;
                    }
                    case 3842: {
                        this.session.refreshFriends();
                        n = 0;
                        break;
                    }
                    case 3856: {
                        this.session.__test1(stringArray[0], stringArray[1]);
                        n = 0;
                        break;
                    }
                    case 3857: {
                        this.session.__test2();
                        n = 0;
                        break;
                    }
                    default: {
                        System.err.println("Unknown option selected");
                    }
                }
                for (int i = 0; i < 3; ++i) {
                    if ((n & 1) > 0) {
                        this.inputTF[i].setText("");
                    }
                    n >>= 1;
                }
            } else if (object == this.dumpB) {
                this.dump();
            } else if (object == this.lobbyB) {
                new LobbyChooser();
            } else if (object == this.confB) {
                new ConfChooser();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateSelectedMode();
    }

    public void dump() {
        YahooGroup[] yahooGroupArray = this.session.getGroups();
        for (int i = 0; i < yahooGroupArray.length; ++i) {
            System.out.println(yahooGroupArray[i].getName() + ":");
            Vector vector = yahooGroupArray[i].getMembers();
            for (int j = 0; j < vector.size(); ++j) {
                YahooUser yahooUser = (YahooUser)vector.elementAt(j);
                System.out.println("  " + yahooUser.toString());
            }
        }
        this.dumpUsers();
    }

    void dumpUsers() {
        Hashtable hashtable = this.session.getUsers();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println(string + " ==> " + ((YahooUser)hashtable.get(string)).toString());
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-u:")) {
                string = stringArray[i].substring(3);
            }
            if (stringArray[i].startsWith("-p:")) {
                string2 = stringArray[i].substring(3);
            }
            if (!stringArray[i].startsWith("-m:")) continue;
            string3 = stringArray[i].substring(3);
        }
        if (stringArray.length == 0) {
            System.out.println("Usage: [-u:<username>] [-p:<password>] [-m:<direct|socks|http>]");
        }
        TestClient testClient = new TestClient(string, string2, string3);
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            TestClient.this.hide();
            TestClient.this.dispose();
            System.exit(0);
        }
    }

    class LoginThread
    extends Thread {
        LoginThread() {
            this.start();
        }

        public void run() {
            int n = TestClient.this.findMode(3840);
            String string = TestClient.this.inputCache[n][2];
            TestClient.this.session = string.equals("socks") ? new Session(new SOCKSConnectionHandler("autoproxy", 1080)) : (string.equals("http") ? new Session(new HTTPConnectionHandler("proxy", 8080)) : (string.equals("direct") ? new Session(new DirectConnectionHandler()) : new Session()));
            TestClient.this.session.addSessionListener(new SessionHandler());
            try {
                TestClient.this.attemptLogin();
                TestClient.this.dump();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class Selector
    extends Frame
    implements ActionListener {
        List selectorL;
        Vector list;
        int selected;
        String title;

        Selector(Vector vector, String string) {
            super("Selector");
            this.list = vector;
            this.title = string;
            this.selected = -1;
            this.initGfx();
        }

        int getSelected() {
            while (this.selected < 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.setVisible(false);
            this.dispose();
            return this.selected;
        }

        void initGfx() {
            this.selectorL = new List(20);
            this.selectorL.addActionListener(this);
            this.selectorL.setMultipleMode(false);
            for (int i = 0; i < this.list.size(); ++i) {
                this.selectorL.add(this.list.elementAt(i).toString());
            }
            this.setLayout(new BorderLayout());
            this.add((Component)this.selectorL, "Center");
            this.add((Component)new Label("Select an item from the list: " + this.title), "North");
            this.pack();
            this.show();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.selected = this.selectorL.getSelectedIndex();
        }
    }

    class ConfChooser
    extends Thread {
        ConfChooser() {
            this.start();
        }

        public void run() {
            if (TestClient.this.conferences.size() <= 0) {
                return;
            }
            Selector selector = new Selector(TestClient.this.conferences, "Choose a conference");
            TestClient.this.currentConf = (YahooConference)TestClient.this.conferences.elementAt(selector.getSelected());
            int n = TestClient.this.findMode(768);
            for (int i = 1; i < 6; ++i) {
                TestClient.this.setInputCache(n + i, 0, TestClient.this.currentConf.getName());
            }
        }
    }

    class LobbyChooser
    extends Thread {
        LobbyChooser() {
            this.start();
        }

        public void run() {
            try {
                YahooChatLobby yahooChatLobby;
                int n;
                Selector selector;
                if (TestClient.this.rootCategory == null) {
                    TestClient.this.rootCategory = YahooChatCategory.loadCategories(TestClient.this.session);
                }
                YahooChatCategory yahooChatCategory = TestClient.this.rootCategory;
                String string = "<Root>";
                while (yahooChatCategory.getCategories().size() > 0) {
                    selector = new Selector(yahooChatCategory.getCategories(), string);
                    n = selector.getSelected();
                    yahooChatCategory = (YahooChatCategory)yahooChatCategory.getCategories().elementAt(n);
                    string = string + "->[" + yahooChatCategory.getName() + "]";
                }
                selector = new Selector(yahooChatCategory.getPublicRooms(), "Public rooms");
                n = selector.getSelected();
                YahooChatRoom yahooChatRoom = (YahooChatRoom)yahooChatCategory.getPublicRooms().elementAt(n);
                selector = new Selector(yahooChatRoom.getLobbies(), yahooChatRoom.getName() + " lobbies");
                n = selector.getSelected();
                TestClient.this.currentLobby = yahooChatLobby = (YahooChatLobby)yahooChatRoom.getLobbies().elementAt(n);
                TestClient.this.setInputCache(TestClient.this.findMode(1024), 0, TestClient.this.currentLobby.getNetworkName());
                System.out.println(TestClient.this.currentLobby.toString());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    class SessionHandler
    extends SessionAdapter {
        SessionHandler() {
        }

        public void messageReceived(SessionEvent sessionEvent) {
            TestClient.this.outputTA.append(sessionEvent.getFrom() + " : " + TestClient.this.decoder.decodeToText(sessionEvent.getMessage()) + "\n");
        }

        public void errorPacketReceived(SessionErrorEvent sessionErrorEvent) {
            if (sessionErrorEvent.getService() != 133) {
                TestClient.this.outputTA.append("ERROR : " + sessionErrorEvent.getMessage() + "\n");
                System.err.println(sessionErrorEvent.toString());
            }
        }

        public void inputExceptionThrown(SessionExceptionEvent sessionExceptionEvent) {
            TestClient.this.outputTA.append("ERROR : " + sessionExceptionEvent.getMessage() + "\n");
            System.err.println(sessionExceptionEvent.toString());
        }

        public void offlineMessageReceived(SessionEvent sessionEvent) {
            TestClient.this.outputTA.append("At " + sessionEvent.getTimestamp().toString() + "\n");
            TestClient.this.outputTA.append(sessionEvent.getFrom() + " : " + TestClient.this.decoder.decodeToText(sessionEvent.getMessage()) + "\n");
        }

        public void fileTransferReceived(SessionFileTransferEvent sessionFileTransferEvent) {
            this.messageReceived(sessionFileTransferEvent);
            System.out.println(sessionFileTransferEvent.getLocation().toString());
            try {
                TestClient.this.session.saveFileTransferTo(sessionFileTransferEvent, TestClient.FT_DIR);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void connectionClosed(SessionEvent sessionEvent) {
            TestClient.this.setVisible(false);
            TestClient.this.dispose();
        }

        public void listReceived(SessionEvent sessionEvent) {
            TestClient.this.dump();
        }

        public void friendsUpdateReceived(SessionFriendEvent sessionFriendEvent) {
            YahooUser[] yahooUserArray = sessionFriendEvent.getFriends();
            for (int i = 0; i < yahooUserArray.length; ++i) {
                System.out.println("Updated: " + yahooUserArray[i].toString());
            }
        }

        public void friendAddedReceived(SessionFriendEvent sessionFriendEvent) {
            System.out.println(sessionFriendEvent.toString());
        }

        public void friendRemovedReceived(SessionFriendEvent sessionFriendEvent) {
            System.out.println(sessionFriendEvent.toString());
        }

        public void conferenceInviteReceived(SessionConferenceEvent sessionConferenceEvent) {
            System.out.println(sessionConferenceEvent.toString());
            try {
                TestClient.this.session.declineConferenceInvite(sessionConferenceEvent.getRoom(), "Sorry!");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void conferenceLogonReceived(SessionConferenceEvent sessionConferenceEvent) {
            System.out.println(sessionConferenceEvent.toString());
        }

        public void conferenceLogoffReceived(SessionConferenceEvent sessionConferenceEvent) {
            System.out.println(sessionConferenceEvent.toString());
        }

        public void conferenceMessageReceived(SessionConferenceEvent sessionConferenceEvent) {
            System.out.println(sessionConferenceEvent.toString());
        }

        public void chatLogonReceived(SessionChatEvent sessionChatEvent) {
            TestClient.this.outputTA.append("[" + sessionChatEvent.getLobby().getNetworkName() + "]\n  " + sessionChatEvent.getChatUser().getId() + " joined\n");
        }

        public void chatLogoffReceived(SessionChatEvent sessionChatEvent) {
            TestClient.this.outputTA.append("[" + sessionChatEvent.getLobby().getNetworkName() + "]\n  " + sessionChatEvent.getChatUser().getId() + " has left\n");
        }

        public void chatMessageReceived(SessionChatEvent sessionChatEvent) {
            TestClient.this.outputTA.append("[" + sessionChatEvent.getLobby().getNetworkName() + "]\n  " + sessionChatEvent.getChatUser().getId() + " : " + TestClient.this.decoder.decodeToText(sessionChatEvent.getMessage()) + "\n");
        }
    }
}

