/*
 * Decompiled with CFR 0.152.
 */
package ymsg.test;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class YahooNetworkMonitor
implements Runnable {
    ServerSocket socketListener;
    Connection toServer;
    Connection toClient;
    private static final String HOST = "scs.msg.yahoo.com";
    private static final int PORT = 5050;
    private static final int LISTEN = 5128;

    YahooNetworkMonitor() {
        new Thread(this).start();
    }

    public void run() {
        try {
            System.out.println("Listening for client on 5128 and directing to scs.msg.yahoo.com:5050");
            this.socketListener = new ServerSocket(5128);
            while (true) {
                this.toClient = new Connection("S<<--C", this.socketListener.accept());
                this.toServer = new Connection("S-->>C", new Socket(HOST, 5050));
                this.toClient.setPipe(this.toServer);
                this.toServer.setPipe(this.toClient);
                this.toClient.start();
                this.toServer.start();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public void shutdown() throws IOException {
        this.toServer.stop();
        this.toClient.stop();
    }

    static synchronized void dump(byte[] byArray, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            String string2 = "0" + Integer.toHexString(byArray[i]);
            System.out.print(string2.substring(string2.length() - 2) + " ");
            string = byArray[i] >= 32 && byArray[i] <= 126 ? string + (char)byArray[i] : string + ".";
            if (i + 1 == n) {
                while (i % 20 != 19) {
                    System.out.print("   ");
                    ++i;
                }
            }
            if ((i + 1) % 20 != 0 && i + 1 < n) continue;
            System.out.print(" " + string + "\n");
            string = "";
        }
    }

    static synchronized void dump(byte[] byArray, int n, String string) {
        System.out.println(string + "\n01-02-03-04-05-06-07-08-09-10-11-12-13-14-15-16-17-18-19-20");
        YahooNetworkMonitor.dump(byArray, n);
    }

    public static void main(String[] stringArray) {
        new YahooNetworkMonitor();
    }

    private class Connection
    implements Runnable {
        Socket socket;
        DataInputStream in;
        DataOutputStream out;
        String name;
        Thread thread;
        Connection pipe;
        boolean quitFlag = false;

        Connection(String string, Socket socket) throws IOException {
            this.name = string;
            this.socket = socket;
            System.out.println("Connection [" + this.name + "]: " + this.socket.toString());
            this.in = new DataInputStream(this.socket.getInputStream());
            this.out = new DataOutputStream(this.socket.getOutputStream());
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
        }

        void setPipe(Connection connection) {
            this.pipe = connection;
        }

        void start() {
            this.thread.start();
        }

        void stop() throws IOException {
            this.quitFlag = true;
            this.socket.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                byte[] byArray = new byte[10240];
                System.out.println("Thread [" + this.name + "] starting.");
                while (!this.quitFlag) {
                    int n = this.in.read(byArray);
                    this.pipe.out.write(byArray, 0, n);
                    YahooNetworkMonitor.dump(byArray, n, this.name);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                System.out.println("Thread [" + this.name + "] ending.");
                try {
                    YahooNetworkMonitor.this.shutdown();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

