/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.util.Map;
import java.util.WeakHashMap;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.Introspector;
import jodd.util.ref.ReferenceMap;
import jodd.util.ref.ReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakIntrospector
implements Introspector {
    protected Map<ClassLoader, Map<String, ClassDescriptor>> cache = new WeakHashMap<ClassLoader, Map<String, ClassDescriptor>>();

    protected Map<String, ClassDescriptor> getClassDescriptorMap(Class type) {
        Map<String, ClassDescriptor> map;
        ClassLoader loader = type.getClassLoader();
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if ((map = this.cache.get(loader)) == null) {
            map = new ReferenceMap<String, ClassDescriptor>(ReferenceType.WEAK, ReferenceType.WEAK);
            this.cache.put(loader, map);
        }
        return map;
    }

    @Override
    public ClassDescriptor lookup(Class type) {
        Map<String, ClassDescriptor> map = this.getClassDescriptorMap(type);
        ClassDescriptor cd = map.get(type.getName());
        if (cd == null) {
            cd = this.describeClass(type);
            cd.increaseUsageCount();
            map.put(type.getName(), cd);
        }
        return cd;
    }

    @Override
    public ClassDescriptor register(Class type) {
        Map<String, ClassDescriptor> map = this.getClassDescriptorMap(type);
        ClassDescriptor cd = this.describeClass(type);
        map.put(type.getName(), cd);
        return cd;
    }

    protected ClassDescriptor describeClass(Class type) {
        return new ClassDescriptor(type, true);
    }

    @Override
    public void reset() {
        this.cache.clear();
    }
}

