/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.instrument.ClassInstrumenter;
import net.sourceforge.cobertura.instrument.InstrumentationAgent;
import net.sourceforge.cobertura.instrument.ProjectDataUtil;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;

public class CoberturaClassFileTransformer
implements ClassFileTransformer {
    private static final String _HAS_BEEN_INSTRUMENTED_CLASS_NAME = "net/sourceforge/cobertura/coveragedata/HasBeenInstrumented";
    private Pattern[] _excludePatterns;
    private Pattern[] _includePatterns;
    private ConcurrentMap<ClassLoader, ProjectData> _projectDatas = new ConcurrentHashMap<ClassLoader, ProjectData>();

    public CoberturaClassFileTransformer(String[] includes, String[] excludes, final File lockFile) {
        Pattern pattern;
        this._includePatterns = new Pattern[includes.length];
        int i = 0;
        while (i < includes.length) {
            this._includePatterns[i] = pattern = Pattern.compile(includes[i]);
            ++i;
        }
        this._excludePatterns = new Pattern[excludes.length];
        i = 0;
        while (i < excludes.length) {
            this._excludePatterns[i] = pattern = Pattern.compile(excludes[i]);
            ++i;
        }
        ProjectDataUtil.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                File dataFile = CoverageDataFileHandler.getDefaultDataFile();
                Collection projectDatas = CoberturaClassFileTransformer.this._projectDatas.values();
                ProjectDataUtil.mergeSave(dataFile, lockFile, projectDatas.toArray(new ProjectData[projectDatas.size()]));
                CoberturaClassFileTransformer.this._projectDatas.clear();
            }
        });
    }

    public boolean matches(String className) {
        Matcher matcher;
        int n;
        int n2;
        Pattern[] patternArray;
        if (this._excludePatterns.length != 0) {
            patternArray = this._excludePatterns;
            n2 = this._excludePatterns.length;
            n = 0;
            while (n < n2) {
                Pattern excludePattern = patternArray[n];
                matcher = excludePattern.matcher(className);
                if (matcher.matches()) {
                    return false;
                }
                ++n;
            }
        }
        if (this._includePatterns.length != 0) {
            patternArray = this._includePatterns;
            n2 = this._includePatterns.length;
            n = 0;
            while (n < n2) {
                Pattern includePattern = patternArray[n];
                matcher = includePattern.matcher(className);
                if (matcher.matches()) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader classLoader, String className, Class<?> refinedClass, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        try {
            if (this.matches(className)) {
                ClassWriter classWriter;
                ProjectData previousProjectData;
                InstrumentationAgent.recordInstrumentation(classLoader, className, classfileBuffer);
                ProjectData projectData = (ProjectData)this._projectDatas.get(classLoader);
                if (projectData == null && (previousProjectData = this._projectDatas.putIfAbsent(classLoader, projectData = new ProjectData())) != null) {
                    projectData = previousProjectData;
                }
                Object classVisitor = classWriter = new ClassWriter(1);
                if (!InstrumentationAgent.isStaticallyInstrumented()) {
                    classVisitor = new RemoveHasBeenInstrumentedClassVisitor((ClassVisitor)classVisitor);
                }
                classVisitor = new ClassInstrumenter(projectData, (ClassVisitor)classVisitor, Collections.emptyList(), Collections.emptyList());
                ClassReader classReader = new ClassReader(classfileBuffer);
                ProjectData projectData2 = projectData;
                synchronized (projectData2) {
                    classReader.accept((ClassVisitor)classVisitor, 0);
                }
                return classWriter.toByteArray();
            }
            if (className.equals("net/sourceforge/cobertura/coveragedata/TouchCollector")) {
                ClassWriter classWriter = new ClassWriter(1);
                TouchCollectorClassVisitor classVisitor = new TouchCollectorClassVisitor((ClassVisitor)classWriter);
                ClassReader classReader = new ClassReader(classfileBuffer);
                classReader.accept((ClassVisitor)classVisitor, 0);
                return classWriter.toByteArray();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
        return null;
    }

    private static class RemoveHasBeenInstrumentedClassVisitor
    extends ClassAdapter {
        public RemoveHasBeenInstrumentedClassVisitor(ClassVisitor classVisitor) {
            super(classVisitor);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            ArrayList<String> interfacesList;
            if ((access & 0x20) != 0 && (interfacesList = new ArrayList<String>(Arrays.asList(interfaces))).remove(CoberturaClassFileTransformer._HAS_BEEN_INSTRUMENTED_CLASS_NAME)) {
                interfaces = interfacesList.toArray(new String[interfacesList.size()]);
                super.visit(version, access, name, signature, superName, interfaces);
                return;
            }
            super.visit(version, access, name, signature, superName, interfaces);
        }
    }

    private static class TouchCollectorCLINITVisitor
    extends MethodAdapter {
        public TouchCollectorCLINITVisitor(MethodVisitor methodVisitor) {
            super(methodVisitor);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 184 && owner.equals("net/sourceforge/cobertura/coveragedata/ProjectData") && name.equals("initialize") && desc.equals("()V")) {
                owner = "net/sourceforge/cobertura/instrument/InstrumentationAgent";
            }
            super.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class TouchCollectorClassVisitor
    extends ClassAdapter {
        public TouchCollectorClassVisitor(ClassVisitor classVisitor) {
            super(classVisitor);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            Object methodVisitor = this.cv.visitMethod(access, name, desc, signature, exceptions);
            if (methodVisitor != null && name.equals("<clinit>")) {
                methodVisitor = new TouchCollectorCLINITVisitor((MethodVisitor)methodVisitor);
            }
            return methodVisitor;
        }
    }
}

