/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.LineData;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.instrument.CoberturaClassFileTransformer;
import net.sourceforge.cobertura.instrument.ProjectDataUtil;

public class InstrumentationAgent {
    private static CoberturaClassFileTransformer _coberturaClassFileTransformer;
    private static boolean _dynamicallyInstrumented;
    private static String[] _excludes;
    private static String[] _includes;
    private static Instrumentation _instrumentation;
    private static File _lockFile;
    private static List<OriginalClassDefinition> _originalClassDefinitions;
    private static boolean _staticallyInstrumented;

    static {
        File dataFile = CoverageDataFileHandler.getDefaultDataFile();
        File parentFolder = dataFile.getParentFile();
        if (!parentFolder.exists()) {
            parentFolder.mkdirs();
        }
        _lockFile = new File(parentFolder, "lock");
        try {
            _lockFile.createNewFile();
        }
        catch (IOException ioe) {
            throw new ExceptionInInitializerError(ioe);
        }
    }

    public static synchronized void assertCoverage(boolean includeInnerClasses, Class<?> ... classes) {
        if (!_dynamicallyInstrumented) {
            return;
        }
        File dataFile = CoverageDataFileHandler.getDefaultDataFile();
        try {
            ProjectData projectData = ProjectDataUtil.captureProjectData(dataFile, _lockFile);
            Class<?>[] classArray = classes;
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?>[] declaredClasses;
                Class<?> clazz = classArray[n2];
                ClassData classData = projectData.getClassData(clazz.getName());
                InstrumentationAgent._assertClassDataCoverage(clazz, classData);
                Class<?>[] classArray2 = declaredClasses = clazz.getDeclaredClasses();
                int n3 = declaredClasses.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?> declaredClass = classArray2[n4];
                    classData = projectData.getClassData(declaredClass.getName());
                    InstrumentationAgent._assertClassDataCoverage(declaredClass, classData);
                    ++n4;
                }
                ++n2;
            }
        }
        finally {
            System.clearProperty("cobertura.parent.dynamically.instrumented");
            System.clearProperty("junit.code.coverage");
            _dynamicallyInstrumented = false;
            _instrumentation.removeTransformer(_coberturaClassFileTransformer);
            _coberturaClassFileTransformer = null;
            if (_originalClassDefinitions == null) {
                return;
            }
            try {
                ArrayList<ClassDefinition> classDefinitions = new ArrayList<ClassDefinition>(_originalClassDefinitions.size());
                int i = 0;
                while (i < _originalClassDefinitions.size()) {
                    OriginalClassDefinition originalClassDefinition = _originalClassDefinitions.get(i);
                    ClassDefinition classDefinition = originalClassDefinition.toClassDefinition();
                    if (classDefinition != null) {
                        classDefinitions.add(classDefinition);
                    }
                    ++i;
                }
                _originalClassDefinitions = null;
                _instrumentation.redefineClasses(classDefinitions.toArray(new ClassDefinition[classDefinitions.size()]));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to uninstrument classes", e);
            }
        }
    }

    public static synchronized void dynamicallyInstrument(String[] includes, String[] excludes) throws UnmodifiableClassException {
        if (_instrumentation == null || _dynamicallyInstrumented) {
            return;
        }
        if (includes == null) {
            includes = _includes;
        }
        if (excludes == null) {
            excludes = _excludes;
        }
        if (_coberturaClassFileTransformer == null) {
            _coberturaClassFileTransformer = new CoberturaClassFileTransformer(includes, excludes, _lockFile);
        }
        _instrumentation.addTransformer(_coberturaClassFileTransformer, true);
        Class[] allLoadedClasses = _instrumentation.getAllLoadedClasses();
        ArrayList<Class> modifiableClasses = new ArrayList<Class>();
        Class[] classArray = allLoadedClasses;
        int n = allLoadedClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class loadedClass = classArray[n2];
            if (_instrumentation.isModifiableClass(loadedClass)) {
                String className = loadedClass.getName();
                if (_coberturaClassFileTransformer.matches(className = className.replace('.', '/'))) {
                    modifiableClasses.add(loadedClass);
                }
            }
            ++n2;
        }
        if (!modifiableClasses.isEmpty()) {
            _instrumentation.retransformClasses(modifiableClasses.toArray(new Class[modifiableClasses.size()]));
        }
        _dynamicallyInstrumented = true;
        _originalClassDefinitions = null;
        System.setProperty("cobertura.parent.dynamically.instrumented", "true");
        System.setProperty("junit.code.coverage", "true");
    }

    public static void initialize() {
        ProjectDataUtil.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                File dataFile = CoverageDataFileHandler.getDefaultDataFile();
                ProjectData projectData = ProjectDataUtil.collectProjectData();
                ProjectDataUtil.mergeSave(dataFile, _lockFile, projectData);
            }
        });
    }

    public static boolean isStaticallyInstrumented() {
        return _staticallyInstrumented;
    }

    public static synchronized void premain(String agentArguments, Instrumentation instrumentation) {
        String[] arguments = agentArguments.split(";");
        String[] includes = arguments[0].split(",");
        String[] excludes = arguments[1].split(",");
        boolean coberturaParentDynamicallyInstrumented = Boolean.getBoolean("cobertura.parent.dynamically.instrumented");
        boolean junitCodeCoverage = Boolean.getBoolean("junit.code.coverage");
        boolean bl = _staticallyInstrumented = !coberturaParentDynamicallyInstrumented && junitCodeCoverage;
        if (junitCodeCoverage) {
            CoberturaClassFileTransformer coberturaClassFileTransformer = new CoberturaClassFileTransformer(includes, excludes, _lockFile);
            instrumentation.addTransformer(coberturaClassFileTransformer);
        } else if (instrumentation.isRedefineClassesSupported() && instrumentation.isRetransformClassesSupported()) {
            _instrumentation = instrumentation;
            _includes = includes;
            _excludes = excludes;
            File dataFile = CoverageDataFileHandler.getDefaultDataFile();
            dataFile.delete();
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("Current JVM is not capable for dynamic ");
            sb.append("instrumententation. Instrumentation ");
            if (instrumentation.isRetransformClassesSupported()) {
                sb.append("supports ");
            } else {
                sb.append("does not support ");
            }
            sb.append("restranforming classes. Instrumentation ");
            if (instrumentation.isRedefineClassesSupported()) {
                sb.append("supports ");
            } else {
                sb.append("does not support ");
            }
            sb.append("redefining classes. Dynamic instrumententation is ");
            sb.append("disabled.");
            System.out.println(sb.toString());
        }
    }

    public static synchronized void recordInstrumentation(ClassLoader classLoader, String name, byte[] bytes) {
        if (!_dynamicallyInstrumented) {
            return;
        }
        if (_originalClassDefinitions == null) {
            _originalClassDefinitions = new ArrayList<OriginalClassDefinition>();
        }
        OriginalClassDefinition originalClassDefinition = new OriginalClassDefinition(classLoader, name, bytes);
        _originalClassDefinitions.add(originalClassDefinition);
    }

    private static void _assertClassDataCoverage(Class<?> clazz, ClassData classData) {
        if (classData == null) {
            throw new RuntimeException("Class " + clazz.getName() + " has no coverage data");
        }
        if (classData.getBranchCoverageRate() != 1.0 || classData.getLineCoverageRate() != 1.0) {
            System.out.printf("%n[Cobertura] %s is not fully covered.%n[Cobertura]Branch coverage rate : %.2f, line coverage rate : %.2f.%n[Cobertura]Please rerun test with -Djunit.code.coverage=true to see coverage report.%n", classData.getName(), classData.getBranchCoverageRate(), classData.getLineCoverageRate());
            SortedSet coverageDatas = classData.getLines();
            for (CoverageData coverageData : coverageDatas) {
                LineData lineData;
                if (!(coverageData instanceof LineData) || (lineData = (LineData)coverageData).isCovered()) continue;
                System.out.printf("[Cobertura] %s line %d is not covered %n", classData.getName(), lineData.getLineNumber());
            }
            throw new AssertionError((Object)(String.valueOf(classData.getName()) + " is not fully covered"));
        }
        System.out.printf("[Cobertura] %s is fully covered.%n", classData.getName());
    }

    private static class OriginalClassDefinition {
        private final byte[] _bytes;
        private final ClassLoader _classLoader;
        private final String _className;

        public OriginalClassDefinition(ClassLoader classLoader, String className, byte[] bytes) {
            this._classLoader = classLoader;
            this._className = className.replace('/', '.');
            this._bytes = bytes;
        }

        public ClassDefinition toClassDefinition() throws ClassNotFoundException {
            try {
                Class<?> clazz = Class.forName(this._className, true, this._classLoader);
                return new ClassDefinition(clazz, this._bytes);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }
}

