/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.coveragedata.TouchCollector;

public class ProjectDataUtil {
    private static final int _RETRY_TIMES = 10;
    private static List<Runnable> _shutdownHooks = new CopyOnWriteArrayList<Runnable>();

    static {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (ProjectDataUtil.class.getClassLoader() == systemClassLoader) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    for (Runnable runnable : _shutdownHooks) {
                        runnable.run();
                    }
                }
            });
        }
    }

    public static void addShutdownHook(Runnable runnable) {
        List<Runnable> shutdownHooks = ProjectDataUtil._getShutdownHooks();
        shutdownHooks.add(runnable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProjectData captureProjectData(File dataFile, File lockFile) {
        for (Runnable runnable : ProjectDataUtil._getShutdownHooks()) {
            runnable.run();
        }
        String string = ProjectDataUtil.class.getName().intern();
        synchronized (string) {
            FileLock fileLock = ProjectDataUtil._lockFile(lockFile);
            try {
                if (dataFile.exists()) {
                    ProjectData projectData = ProjectDataUtil._readProjectData(dataFile);
                    return projectData;
                }
                ProjectData projectData = new ProjectData();
                return projectData;
            }
            finally {
                ProjectDataUtil._unlockFile(fileLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectData collectProjectData() {
        ProjectData projectData = new ProjectData();
        PrintStream printStream = new PrintStream(new ByteArrayOutputStream());
        FileDescriptor fileDescriptor = FileDescriptor.out;
        synchronized (fileDescriptor) {
            PrintStream stdOut = System.out;
            System.setOut(printStream);
            try {
                TouchCollector.applyTouchesOnProjectData((ProjectData)projectData);
            }
            finally {
                System.setOut(stdOut);
            }
        }
        return projectData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeSave(File dataFile, File lockFile, ProjectData ... projectDatas) {
        String string = ProjectDataUtil.class.getName().intern();
        synchronized (string) {
            FileLock fileLock = ProjectDataUtil._lockFile(lockFile);
            try {
                ProjectData masterProjectData = null;
                masterProjectData = dataFile.exists() ? ProjectDataUtil._readProjectData(dataFile) : new ProjectData();
                ProjectData[] projectDataArray = projectDatas;
                int n = projectDatas.length;
                int n2 = 0;
                while (n2 < n) {
                    ProjectData projectData = projectDataArray[n2];
                    masterProjectData.merge((CoverageData)projectData);
                    ++n2;
                }
                ProjectDataUtil._writeProjectData(masterProjectData, dataFile);
            }
            finally {
                ProjectDataUtil._unlockFile(fileLock);
            }
        }
    }

    private static List<Runnable> _getShutdownHooks() {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (ProjectDataUtil.class.getClassLoader() == systemClassLoader) {
            return _shutdownHooks;
        }
        try {
            Class<?> clazz = systemClassLoader.loadClass(ProjectDataUtil.class.getName());
            Field field = clazz.getDeclaredField("_shutdownHooks");
            field.setAccessible(true);
            return (List)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static FileLock _lockFile(File file) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            FileChannel fileChannel = randomAccessFile.getChannel();
            return fileChannel.lock();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * Loose catch block
     */
    private static ProjectData _readProjectData(File dataFile) {
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        int i = 0;
        while (i < 10) {
            ProjectData projectData;
            block23: {
                fileInputStream = new FileInputStream(dataFile);
                objectInputStream = new ObjectInputStream(fileInputStream);
                projectData = (ProjectData)objectInputStream.readObject();
                if (objectInputStream == null) break block23;
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            return projectData;
            catch (IOException iOException) {
                block24: {
                    if (objectInputStream == null) break block24;
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException3) {}
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
                {
                    catch (Throwable throwable) {
                        if (objectInputStream != null) {
                            try {
                                objectInputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                }
            }
            ++i;
        }
        throw new IllegalStateException("Unable to load project data after retry for 10 times");
    }

    private static void _unlockFile(FileLock fileLock) {
        try {
            fileLock.release();
            FileChannel fileChannel = fileLock.channel();
            fileChannel.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void _writeProjectData(ProjectData projectData, File dataFile) {
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(dataFile);
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(projectData);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (objectOutputStream != null) {
            try {
                objectOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

