/*
 * Decompiled with CFR 0.152.
 */
package com.dumbster.smtp;

import com.dumbster.smtp.SmtpActionType;
import com.dumbster.smtp.SmtpMessage;
import com.dumbster.smtp.SmtpRequest;
import com.dumbster.smtp.SmtpResponse;
import com.dumbster.smtp.SmtpState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleSmtpServer
implements Runnable {
    private List receivedMail = new ArrayList();
    public static final int DEFAULT_SMTP_PORT = 25;
    private volatile boolean stopped = true;
    private ServerSocket serverSocket;
    private int port = 25;
    private static final int TIMEOUT = 500;

    public SimpleSmtpServer(int n) {
        this.port = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.stopped = false;
        try {
            Object object;
            BufferedReader bufferedReader;
            try {
                this.serverSocket = new ServerSocket(this.port);
                this.serverSocket.setSoTimeout(500);
                bufferedReader = null;
                object = this;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                SimpleSmtpServer simpleSmtpServer = this;
                synchronized (simpleSmtpServer) {
                    this.notifyAll();
                    throw throwable;
                }
            }
            synchronized (object) {
                this.notifyAll();
            }
            while (true) {
                if (this.isStopped()) {
                    return;
                }
                Socket socket = null;
                try {
                    socket = this.serverSocket.accept();
                }
                catch (Exception exception) {
                    if (socket == null) continue;
                    socket.close();
                    continue;
                }
                bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                object = new PrintWriter(socket.getOutputStream());
                SimpleSmtpServer simpleSmtpServer = this;
                synchronized (simpleSmtpServer) {
                    List list = this.handleTransaction((PrintWriter)object, bufferedReader);
                    this.receivedMail.addAll(list);
                }
                socket.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        finally {
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public synchronized void stop() {
        this.stopped = true;
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {}
    }

    private List handleTransaction(PrintWriter printWriter, BufferedReader bufferedReader) throws IOException {
        SmtpState smtpState = SmtpState.CONNECT;
        SmtpRequest smtpRequest = new SmtpRequest(SmtpActionType.CONNECT, "", smtpState);
        SmtpResponse smtpResponse = smtpRequest.execute();
        SimpleSmtpServer.sendResponse(printWriter, smtpResponse);
        smtpState = smtpResponse.getNextState();
        ArrayList<SmtpMessage> arrayList = new ArrayList<SmtpMessage>();
        SmtpMessage smtpMessage = new SmtpMessage();
        while (smtpState != SmtpState.CONNECT) {
            String string = bufferedReader.readLine();
            if (string == null) break;
            SmtpRequest smtpRequest2 = SmtpRequest.createRequest(string, smtpState);
            SmtpResponse smtpResponse2 = smtpRequest2.execute();
            smtpState = smtpResponse2.getNextState();
            SimpleSmtpServer.sendResponse(printWriter, smtpResponse2);
            String string2 = smtpRequest2.getParams();
            smtpMessage.store(smtpResponse2, string2);
            if (smtpState != SmtpState.QUIT) continue;
            arrayList.add(smtpMessage);
            smtpMessage = new SmtpMessage();
        }
        return arrayList;
    }

    private static void sendResponse(PrintWriter printWriter, SmtpResponse smtpResponse) {
        if (smtpResponse.getCode() > 0) {
            int n = smtpResponse.getCode();
            String string = smtpResponse.getMessage();
            printWriter.print(n + " " + string + "\r\n");
            printWriter.flush();
        }
    }

    public synchronized Iterator getReceivedEmail() {
        return this.receivedMail.iterator();
    }

    public synchronized int getReceivedEmailSize() {
        return this.receivedMail.size();
    }

    public static SimpleSmtpServer start() {
        return SimpleSmtpServer.start(25);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleSmtpServer start(int n) {
        SimpleSmtpServer simpleSmtpServer = new SimpleSmtpServer(n);
        Thread thread = new Thread(simpleSmtpServer);
        thread.start();
        SimpleSmtpServer simpleSmtpServer2 = simpleSmtpServer;
        synchronized (simpleSmtpServer2) {
            try {
                simpleSmtpServer.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return simpleSmtpServer;
    }
}

