/*
 * Decompiled with CFR 0.152.
 */
package com.dumbster.smtp;

public class SmtpActionType {
    private byte value;
    private static final byte CONNECT_BYTE = 1;
    private static final byte EHLO_BYTE = 2;
    private static final byte MAIL_BYTE = 3;
    private static final byte RCPT_BYTE = 4;
    private static final byte DATA_BYTE = 5;
    private static final byte DATA_END_BYTE = 6;
    private static final byte QUIT_BYTE = 7;
    private static final byte UNREC_BYTE = 8;
    private static final byte BLANK_LINE_BYTE = 9;
    private static final byte RSET_BYTE = -1;
    private static final byte VRFY_BYTE = -2;
    private static final byte EXPN_BYTE = -3;
    private static final byte HELP_BYTE = -4;
    private static final byte NOOP_BYTE = -5;
    public static final SmtpActionType CONNECT = new SmtpActionType(1);
    public static final SmtpActionType EHLO = new SmtpActionType(2);
    public static final SmtpActionType MAIL = new SmtpActionType(3);
    public static final SmtpActionType RCPT = new SmtpActionType(4);
    public static final SmtpActionType DATA = new SmtpActionType(5);
    public static final SmtpActionType DATA_END = new SmtpActionType(6);
    public static final SmtpActionType UNRECOG = new SmtpActionType(8);
    public static final SmtpActionType QUIT = new SmtpActionType(7);
    public static final SmtpActionType BLANK_LINE = new SmtpActionType(9);
    public static final SmtpActionType RSET = new SmtpActionType(-1);
    public static final SmtpActionType VRFY = new SmtpActionType(-2);
    public static final SmtpActionType EXPN = new SmtpActionType(-3);
    public static final SmtpActionType HELP = new SmtpActionType(-4);
    public static final SmtpActionType NOOP = new SmtpActionType(-5);

    private SmtpActionType(byte by) {
        this.value = by;
    }

    public boolean isStateless() {
        return this.value < 0;
    }

    public String toString() {
        switch (this.value) {
            case 1: {
                return "Connect";
            }
            case 2: {
                return "EHLO";
            }
            case 3: {
                return "MAIL";
            }
            case 4: {
                return "RCPT";
            }
            case 5: {
                return "DATA";
            }
            case 6: {
                return ".";
            }
            case 7: {
                return "QUIT";
            }
            case -1: {
                return "RSET";
            }
            case -2: {
                return "VRFY";
            }
            case -3: {
                return "EXPN";
            }
            case -4: {
                return "HELP";
            }
            case -5: {
                return "NOOP";
            }
            case 8: {
                return "Unrecognized command / data";
            }
            case 9: {
                return "Blank line";
            }
        }
        return "Unknown";
    }
}

