/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ant;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Union;
import org.sonar.ant.SonarTask;

public final class Utils {
    private Utils() {
    }

    public static String convertResourceCollectionToString(ResourceCollection c) {
        String[] list = new Union(c).list();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(list[i]);
        }
        return sb.toString();
    }

    public static URL getJarPath() {
        String pathToClass = "/" + SonarTask.class.getName().replace('.', '/') + ".class";
        URL url = SonarTask.class.getResource(pathToClass);
        if (url != null) {
            String path = url.toString();
            String uri = null;
            if (path.startsWith("jar:file:")) {
                int bang = path.indexOf(33);
                uri = path.substring(4, bang);
            } else if (path.startsWith("file:")) {
                int tail = path.indexOf(pathToClass);
                uri = path.substring(0, tail);
            }
            if (uri != null) {
                try {
                    return new URL(uri);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static int getAntLoggerLever(Project project) {
        try {
            Vector listeners = project.getBuildListeners();
            for (BuildListener listener : listeners) {
                if (!(listener instanceof DefaultLogger)) continue;
                DefaultLogger logger = (DefaultLogger)listener;
                Field field = DefaultLogger.class.getDeclaredField("msgOutputLevel");
                field.setAccessible(true);
                return (Integer)field.get(logger);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 2;
    }
}

