/*
 * Decompiled with CFR 0.152.
 */
package com.java2html;

import com.java2html.Helper;
import java.io.FileWriter;
import java.io.IOException;

public class HTMLFileWriter
extends FileWriter {
    private boolean htmlMode = false;
    private int lineCount = 0;
    private final int convertTabsToSpacesCount;
    private int skipNewLineCharacter = 0;
    private boolean useLineNumbers = true;
    private final int lineNumberMargin;
    private int charCount = 0;

    public void setHTMLMode(boolean bl) {
        this.htmlMode = bl;
    }

    public HTMLFileWriter(String string, int n, int n2) throws Exception {
        super(string);
        if (n > 64) {
            throw new Exception("Margin too Large");
        }
        if (n < 0) {
            throw new Exception("Margin too Small");
        }
        if (n2 > 64) {
            throw new Exception("TabSize too Large");
        }
        if (n2 < 1) {
            throw new Exception("TabSize too Small");
        }
        if (n == 0) {
            this.useLineNumbers = false;
        }
        this.lineNumberMargin = n;
        this.convertTabsToSpacesCount = n2;
    }

    public void write(StringBuffer stringBuffer) {
        this.write(stringBuffer.toString());
    }

    public void write(String string) {
        try {
            if (this.htmlMode) {
                super.write(this.getHTMLParsedText(string));
            } else {
                super.write(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeLineNumber(StringBuffer stringBuffer) {
        stringBuffer.append(Helper.lineSep);
        ++this.lineCount;
        if (this.useLineNumbers) {
            int n;
            int n2 = this.lineCount;
            int n3 = 10;
            for (int i = this.lineNumberMargin; i > 1; --i) {
                n3 *= 10;
            }
            String string = "" + (n2 %= n3);
            stringBuffer.append("<FONT ID=\"LN\">");
            if (this.lineCount < n3) {
                stringBuffer.append(n2);
                for (n = this.lineNumberMargin - string.length(); n > 0; --n) {
                    stringBuffer.append(' ');
                }
            } else {
                while (n > 0) {
                    stringBuffer.append('0');
                    --n;
                }
                stringBuffer.append(string);
            }
            stringBuffer.append("</FONT>");
        }
        stringBuffer.append("<A NAME=\"" + this.lineCount + "\"></A>");
    }

    public String getFirstLineNumber() {
        StringBuffer stringBuffer = new StringBuffer();
        ++this.lineCount;
        if (this.useLineNumbers) {
            String string = "" + this.lineCount;
            stringBuffer.append("<FONT ID=\"LN\">" + this.lineCount);
            for (int i = this.lineNumberMargin - string.length(); i > 0; --i) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("</FONT>");
        }
        stringBuffer.append("<A NAME=\"" + this.lineCount + "\"></A>");
        return stringBuffer.toString();
    }

    private String getHTMLParsedText(String string) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        block8: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    ++this.charCount;
                    continue block8;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    ++this.charCount;
                    continue block8;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    ++this.charCount;
                    continue block8;
                }
                case '\r': {
                    this.charCount = 0;
                    this.writeLineNumber(stringBuffer);
                    this.skipNewLineCharacter = 2;
                    continue block8;
                }
                case '\n': {
                    this.charCount = 0;
                    if (this.skipNewLineCharacter != 0) continue block8;
                    this.writeLineNumber(stringBuffer);
                    continue block8;
                }
                case '\t': {
                    n = this.convertTabsToSpacesCount - this.charCount % this.convertTabsToSpacesCount;
                    while (n > 0) {
                        stringBuffer.append(' ');
                        --n;
                        ++this.charCount;
                    }
                    continue block8;
                }
                default: {
                    stringBuffer.append(c);
                    ++this.charCount;
                }
            }
            if (this.skipNewLineCharacter <= 0) continue;
            --this.skipNewLineCharacter;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        HTMLFileWriter hTMLFileWriter = new HTMLFileWriter("test.html", 4, 4);
        hTMLFileWriter.setHTMLMode(true);
        hTMLFileWriter.write("<PRE><H1> This is {@value}  an &amp; Test </TEST></H1>" + Helper.lineSep);
        hTMLFileWriter.setHTMLMode(false);
        hTMLFileWriter.write("<PRE><H1> This is {@value}  an &amp; Test </TEST></H1>" + Helper.lineSep);
        hTMLFileWriter.close();
    }
}

