/**
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, version 2.1, dated February 1999.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the latest version of the GNU Lesser General
 * Public License as published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program (LICENSE.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Based on code generated by Agitar build: Agitator Version 1.0.2.000071 (Build date: Jan 12, 2007) [1.0.2.000071]
 */
package org.jamwiki;

import org.junit.Test;
import static org.junit.Assert.*;

public class WikiMessageTest extends JAMWikiUnitTest {

	/**
	 *
	 */
	@Test
	public void testConstructor() throws Throwable {
		WikiMessage wikiMessage = new WikiMessage("testWikiMessageKey");
		assertEquals("wikiMessage.getKey()", "testWikiMessageKey", wikiMessage.getKey());
		assertNull("wikiMessage.getParams()", wikiMessage.getParams());
	}

	/**
	 *
	 */
	@Test
	public void testConstructor1() throws Throwable {
		String[] strings = new String[1];
		WikiMessage wikiMessage = new WikiMessage("testWikiMessageKey", strings);
		assertEquals("wikiMessage.getKey()", "testWikiMessageKey", wikiMessage.getKey());
		assertEquals("wikiMessage.getParams().length", 1, wikiMessage.getParams().length);
	}

	/**
	 *
	 */
	@Test
	public void testConstructor2() throws Throwable {
		WikiMessage wikiMessage = new WikiMessage("testWikiMessageKey", (String[]) null);
		assertEquals("wikiMessage.getKey()", "testWikiMessageKey", wikiMessage.getKey());
		assertNull("wikiMessage.getParams()", wikiMessage.getParams());
	}

	/**
	 *
	 */
	@Test
	public void testConstructor3() throws Throwable {
		String[] strings = new String[0];
		WikiMessage wikiMessage = new WikiMessage("testWikiMessageKey", strings);
		assertEquals("wikiMessage.getKey()", "testWikiMessageKey", wikiMessage.getKey());
		assertEquals("wikiMessage.getParams().length", 0, wikiMessage.getParams().length);
	}

	/**
	 *
	 */
	@Test
	public void testConstructor4() throws Throwable {
		WikiMessage wikiMessage = new WikiMessage("testWikiMessageKey", "testWikiMessageParam1");
		assertEquals("wikiMessage.getKey()", "testWikiMessageKey", wikiMessage.getKey());
		assertEquals("wikiMessage.getParams().length", 1, wikiMessage.getParams().length);
	}

	/**
	 *
	 */
	@Test
	public void testConstructor5() throws Throwable {
		WikiMessage wikiMessage = new WikiMessage("testWikiMessageKey", "testWikiMessageParam1", "testWikiMessageParam2");
		assertEquals("wikiMessage.getKey()", "testWikiMessageKey", wikiMessage.getKey());
		assertEquals("wikiMessage.getParams().length", 2, wikiMessage.getParams().length);
	}

	/**
	 *
	 */
	@Test
	public void testGetKey() throws Throwable {
		String result = new WikiMessage("testWikiMessageKey").getKey();
		assertSame("result", "testWikiMessageKey", result);
	}

	/**
	 *
	 */
	@Test
	public void testGetParams() throws Throwable {
		String[] strings = new String[3];
		WikiMessage wikiMessage = new WikiMessage("testWikiMessageKey");
		wikiMessage.setParamsWithoutEscaping(strings);
		String[] result = wikiMessage.getParams();
		assertSame("result", strings, result);
		assertNull("strings[0]", strings[0]);
	}

	/**
	 *
	 */
	@Test
	public void testSetParamsWithoutEscaping() throws Throwable {
		String[] strings = new String[3];
		WikiMessage wikiMessage = new WikiMessage("testWikiMessageKey");
		wikiMessage.setParamsWithoutEscaping(strings);
		assertSame("wikiMessage.getParams()", strings, wikiMessage.getParams());
	}
}

