/**
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, version 2.1, dated February 1999.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the latest version of the GNU Lesser General
 * Public License as published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program (LICENSE.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Based on code generated by Agitar build: Agitator Version 1.0.2.000071 (Build date: Jan 12, 2007) [1.0.2.000071]
 */
package org.jamwiki.servlets;

import java.util.Properties;
import org.jamwiki.JAMWikiUnitTest;
import org.jamwiki.utils.SortedProperties;
import org.junit.Test;
import static org.junit.Assert.*;

public class ServletUtilTest extends JAMWikiUnitTest {

	/**
	 *
	 */
	@Test
	public void testValidateSystemSettings1() throws Throwable {
		Properties props = new Properties(new SortedProperties());
		props.put("file-dir-full-path", ")%2F");
		props.put("homeDir", "testString");
		props.put("parser", "org.jamwiki.parser.AbstractParser");
		props.put("url", "testString");
		ServletUtil.validateSystemSettings(props);
		assertTrue("Test completed without Exception", true);
		// dependencies on static and environment state led to removal of 1 assertion(s)
	}

	/**
	 *
	 */
	@Test
	public void testValidateSystemSettings2() throws Throwable {
		Properties props = new Properties();
		props.put("file-dir-full-path", "testString");
		props.put("homeDir", "testString");
		props.put("url", "testString");
		ServletUtil.validateSystemSettings(props);
		assertTrue("Test completed without Exception", true);
		// dependencies on static and environment state led to removal of 1 assertion(s)
	}

	/**
	 *
	 */
	@Test(expected=NullPointerException.class)
	public void testValidateSystemSettingsThrowsNullPointerException1() throws Throwable {
		ServletUtil.validateSystemSettings(new Properties());
	}
}
