/**
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, version 2.1, dated February 1999.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the latest version of the GNU Lesser General
 * Public License as published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program (LICENSE.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Based on code generated by Agitar build: Agitator Version 1.0.2.000071 (Build date: Jan 12, 2007) [1.0.2.000071]
 */
package org.jamwiki.utils;

import java.io.FileNotFoundException;
import org.jamwiki.JAMWikiUnitTest;
import org.junit.Test;
import static org.junit.Assert.*;

public class UtilitiesTest extends JAMWikiUnitTest {

	/**
	 *
	 */
	@Test
	public void testConvertEncoding1() throws Throwable {
		String expected="ça va là?";
		String utf8 = "Ã§a va lÃ ?";
		/* data utf8 opened as Latin1*/
		String result = Utilities.convertEncoding(utf8, "ISO-8859-1", "UTF-8");
		assertEquals("Failure during encoding conversion", expected, result);
		/* data Latin1 opened as Latin1 */
		result = Utilities.convertEncoding(expected, "ISO-8859-1", "ISO-8859-1");
		assertEquals("Failure during encoding conversion", expected, result);
	}

	/**
	 *
	 */
	@Test
	public void testdecodeTopicName() throws Throwable {
		String result = Utilities.decodeTopicName("Page_requested", true);
		assertEquals("Failure decoding topic name", "Page requested", result);
		result = Utilities.decodeTopicName("Page_requested", false);
		assertEquals("Failure decoding topic name", "Page_requested", result);
	}

	/**
	 *
	 */
	@Test
	public void testdecodeAndEscapeTopicName() throws Throwable {
		String result = Utilities.decodeAndEscapeTopicName("\u1342%20", true);
		assertEquals("Failure decoding and escaping topic name", "\u1342 ", result);
	}

	/**
	 *
	 */
	@Test
	public void testdecodeAndEscapeTopicName2() throws Throwable {
		String result = Utilities.decodeAndEscapeTopicName(null, true);
		assertNull("Expected null topic name", result);
	}

	/**
	 *
	 */
	@Test
	public void testdecodeAndEscapeTopicName3() throws Throwable {
		String result = Utilities.decodeAndEscapeTopicName(" ", true);
		assertEquals("Expected empty topic name", " ", result);
	}

	/**
	 *
	 */
	@Test
	public void testEncodeAndEscapeTopicName() throws Throwable {
		String result = Utilities.encodeAndEscapeTopicName(null);
		assertNull("Expected null topic name", result);
	}

	/**
	 *
	 */
	@Test
	public void testFindMatchingEndTag() throws Throwable {
		int result = Utilities.findMatchingEndTag("01<b>567</b>23", 0, "<b>", "</b>");
		assertEquals("Incorrect end tag position found", 12, result);
	}

	/**
	 *
	 */
	@Test
	public void testFindMatchingEndTag1() throws Throwable {
		int result = Utilities.findMatchingEndTag("01234567</b>23", 0, "<b>", "</b>");
		assertEquals("Incorrect end tag position found", -1, result);
	}

	/**
	 *
	 */
	@Test
	public void testFindMatchingEndTag2() throws Throwable {
		int result = Utilities.findMatchingEndTag("01<b>567890123", 0, "<b>", "</b>");
		assertEquals("Incorrect end tag position found", -1, result);
	}

	/**
	 *
	 */
	@Test
	public void testFindMatchingEndTag3() throws Throwable {
		int result = Utilities.findMatchingEndTag("01<b>5<b>9</b>4</b>9", 0, "<b>", "</b>");
		assertEquals("Incorrect end tag position found", 19, result);
	}

	/**
	 *
	 */
	@Test
	public void testFindMatchingEndTag4() throws Throwable {
		int result = Utilities.findMatchingEndTag("01<b>5<b>901234</b>9", 0, "<b>", "</b>");
		assertEquals("Incorrect end tag position found", -1, result);
	}

	/**
	 *
	 */
	@Test
	public void testFindMatchingEndTag5() throws Throwable {
		int result = Utilities.findMatchingEndTag("01<b>5<b>9</b>4</b>9", 5, "<b>", "</b>");
		assertEquals("Incorrect end tag position found", 14, result);
	}

	/**
	 *
	 */
	@Test
	public void testFindMatchingEndTag6() throws Throwable {
		int result = Utilities.findMatchingEndTag("01<b>5<b>9</b>4</b>9", -1, "<b>", "</b>");
		assertEquals("Incorrect end tag position found", -1, result);
	}

	/**
	 *
	 */
	@Test
	public void testFindMatchingEndTag7() throws Throwable {
		int result = Utilities.findMatchingEndTag("01<b>5<b>9</b>4</b>9", 20, "<b>", "</b>");
		assertEquals("Incorrect end tag position found", -1, result);
	}

	/**
	 *
	 */
	@Test
	public void testFindMatchingStartTag() throws Throwable {
		int result = Utilities.findMatchingStartTag("01<b>567</b>23", 13, "<b>", "</b>");
		assertEquals("Incorrect start tag position found", 1, result);
	}

	/**
	 *
	 */
	@Test
	public void testFindMatchingStartTag1() throws Throwable {
		int result = Utilities.findMatchingStartTag("01234567</b>23", 13, "<b>", "</b>");
		assertEquals("Incorrect start tag position found", -1, result);
	}

	/**
	 *
	 */
	@Test
	public void testFindMatchingStartTag2() throws Throwable {
		int result = Utilities.findMatchingStartTag("01<b>567890123", 13, "<b>", "</b>");
		assertEquals("Incorrect start tag position found", -1, result);
	}

	/**
	 *
	 */
	@Test
	public void testFindMatchingStartTag3() throws Throwable {
		int result = Utilities.findMatchingStartTag("01<b>5<b>9</b>4</b>9", 19, "<b>", "</b>");
		assertEquals("Incorrect start tag position found", 1, result);
	}

	/**
	 *
	 */
	@Test
	public void testFindMatchingStartTag4() throws Throwable {
		int result = Utilities.findMatchingStartTag("01<b>5</b>901234</b>9", 19, "<b>", "</b>");
		assertEquals("Incorrect start tag position found", -1, result);
	}

	/**
	 *
	 */
	@Test
	public void testFindMatchingStartTag5() throws Throwable {
		int result = Utilities.findMatchingStartTag("01<b>5<b>9</b>4</b>9", 14, "<b>", "</b>");
		assertEquals("Incorrect start tag position found", 5, result);
	}

	/**
	 *
	 */
	@Test
	public void testFindMatchingStartTag6() throws Throwable {
		int result = Utilities.findMatchingStartTag("01<b>5<b>9</b>4</b>9", -1, "<b>", "</b>");
		assertEquals("Incorrect start tag position found", -1, result);
	}

	/**
	 *
	 */
	@Test
	public void testFindMatchingStartTag7() throws Throwable {
		int result = Utilities.findMatchingStartTag("01<b>5<b>9</b>4</b>9", 20, "<b>", "</b>");
		assertEquals("Incorrect start tag position found", -1, result);
	}

	/**
	 *
	 */
	@Test
	public void testIsIpAddress() throws Throwable {
		//test ipv4 addresses
		assertTrue("0.0.0.0", Utilities.isIpAddress("0.0.0.0"));
		assertTrue("1.2.3.4", Utilities.isIpAddress("1.2.3.4"));
		assertTrue("127.0.0.1", Utilities.isIpAddress("127.0.0.1"));
		assertTrue("255.255.255.255", Utilities.isIpAddress("255.255.255.255"));
		assertTrue("240.0.199.200", Utilities.isIpAddress("240.0.199.200"));
		assertFalse("too many numbers", Utilities.isIpAddress("1.2.3.4.5"));
		assertFalse("too many numbers", Utilities.isIpAddress("1.2.3.4."));
		assertFalse("too few numbers", Utilities.isIpAddress("256.1.1"));
		assertFalse("too few numbers", Utilities.isIpAddress("256.1.1."));
		assertFalse("256 is out of range", Utilities.isIpAddress("256.1.1.1"));
		assertFalse("letters instead of numbers", Utilities.isIpAddress("a.b.c.d"));
		assertFalse("extra period", Utilities.isIpAddress("1.2.3..4"));
		//test ipv6 addresses
		assertTrue("0:0:0:0:0:0:0:0", Utilities.isIpAddress("0:0:0:0:0:0:0:0"));
		assertTrue("1234:abcd:eFe9:5500:30:a:99aa:5542", Utilities.isIpAddress("1234:abcd:eFe9:5500:30:a:99aa:5542"));
		assertFalse("too many entries", Utilities.isIpAddress("1234:abcd:eFe9:5500:30:a:99aa:0:0"));
		assertFalse("too many entries", Utilities.isIpAddress("1234:abcd:eFe9:5500:30:a:99aa:0:"));
		assertFalse("too few entries", Utilities.isIpAddress("1234:abcd:eFe9:5500:30:a:99aa"));
		assertFalse("too few entries", Utilities.isIpAddress("1234:abcd:eFe9:5500:30:a:99aa:"));
		assertFalse("g is out of range", Utilities.isIpAddress("123g:abcd:eFe9:5500:30:a:99aa:0"));
		assertFalse("% is out of range", Utilities.isIpAddress("1234:abcd:eFe9:5500:30:a:99aa:0%"));
		assertFalse("extra colon", Utilities.isIpAddress("1234::abcd:eFe9:5500:30:a:99aa:0"));
		//empty and null
		assertFalse("empty string", Utilities.isIpAddress(""));
		assertFalse("null string", Utilities.isIpAddress(null));
	}

	/**
	 *
	 */
	@Test(expected=NullPointerException.class)
	public void testFormatMessageThrowsNullPointerException() throws Throwable {
		Utilities.formatMessage("testUtilitiesKey", null);
	}

	/**
	 *
	 */
	@Test(expected=NullPointerException.class)
	public void testFormatMessageThrowsNullPointerException1() throws Throwable {
		Object[] objects = new Object[2];
		Utilities.formatMessage("testUtilitiesKey", null, objects);
	}

	/**
	 *
	 */
	@Test(expected=Exception.class)
	public void testGetClassLoaderFileThrowsException() throws Throwable {
		Utilities.getClassLoaderFile("testUtilitiesFilename");
	}

	/**
	 *
	 */
	@Test(expected=FileNotFoundException.class)
	public void testReadFileThrowsFileNotFoundException() throws Throwable {
		Utilities.readFile("fakeFileName");
	}

	/**
	 *
	 */
	@Test(expected=FileNotFoundException.class)
	public void testReadFileThrowsFileNotFoundException1() throws Throwable {
		Utilities.readFile("testUtilitiesFilename");
	}

	/**
	 *
	 */
	@Test(expected=NullPointerException.class)
	public void testReadFileThrowsNullPointerException() throws Throwable {
		Utilities.readFile(null);
	}
}