/**
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, version 2.1, dated February 1999.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the latest version of the GNU Lesser General
 * Public License as published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program (LICENSE.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Based on code generated by Agitar build: Agitator Version 1.0.2.000071 (Build date: Jan 12, 2007) [1.0.2.000071]
 */
package org.jamwiki.utils;

import java.util.logging.LogRecord;
import java.util.logging.Level;
import java.util.PropertyResourceBundle;
import java.io.ByteArrayInputStream;
import org.jamwiki.JAMWikiUnitTest;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 */
public class WikiLogFormatterTest extends JAMWikiUnitTest {

	/**
	 *
	 */
	@Test(expected=IllegalArgumentException.class)
	public void testFormatThrowsIllegalArgumentException() throws Throwable {
		new WikiLogFormatter("testWikiLogFormatterDatePattern").format(new LogRecord(Level.FINE, "testWikiLogFormatterParam2"));
	}

	/**
	 *
	 */
	@Test(expected=NullPointerException.class)
	public void testFormatThrowsNullPointerException() throws Throwable {
		new WikiLogFormatter("").format(null);
	}

	/**
	 *
	 */
	@Test(expected=NullPointerException.class)
	public void testFormatThrowsNullPointerException1() throws Throwable {
		byte[] bytes = new byte[2];
		LogRecord record = new LogRecord(Level.OFF, null);
		record.setResourceBundle(new PropertyResourceBundle(new ByteArrayInputStream(bytes)));
		new WikiLogFormatter("").format(record);
	}
}

