/**
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, version 2.1, dated February 1999.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the latest version of the GNU Lesser General
 * Public License as published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program (LICENSE.txt); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Based on code generated by Agitar build: Agitator Version 1.0.2.000071 (Build date: Jan 12, 2007) [1.0.2.000071]
 */
package org.jamwiki.utils;

import java.io.File;
import java.sql.Timestamp;
import org.jamwiki.JAMWikiUnitTest;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 */
public class XMLUtilTest extends JAMWikiUnitTest {

	/**
	 *
	 */
	@Test
	public void testBuildTag() throws Throwable {
		String result = XMLUtil.buildTag("testXMLUtilTagName", 100L);
		assertEquals("result", "<testXMLUtilTagName>100</testXMLUtilTagName>", result);
	}

	/**
	 *
	 */
	@Test
	public void testBuildTag1() throws Throwable {
		String result = XMLUtil.buildTag("testXMLUtilTagName", true);
		assertEquals("result", "<testXMLUtilTagName>true</testXMLUtilTagName>", result);
	}

	/**
	 *
	 */
	@Test
	public void testBuildTag2() throws Throwable {
		String result = XMLUtil.buildTag("testXMLUtilTagName", 0);
		assertEquals("result", "<testXMLUtilTagName>0</testXMLUtilTagName>", result);
	}

	/**
	 *
	 */
	@Test
	public void testBuildTag4() throws Throwable {
		String result = XMLUtil.buildTag("testXMLUtilTagName", (Timestamp) null);
		assertEquals("result", "", result);
	}

	/**
	 *
	 */
	@Test
	public void testBuildTag5() throws Throwable {
		String result = XMLUtil.buildTag("testXMLUtilTagName", 100);
		assertEquals("result", "<testXMLUtilTagName>100</testXMLUtilTagName>", result);
	}

	/**
	 *
	 */
	@Test
	public void testBuildTag6() throws Throwable {
		String result = XMLUtil.buildTag("testXMLUtilTagName", "testXMLUtilTagValue", true);
		assertEquals("result", "<testXMLUtilTagName>testXMLUtilTagValue</testXMLUtilTagName>", result);
	}

	/**
	 *
	 */
	@Test
	public void testBuildTag7() throws Throwable {
		String result = XMLUtil.buildTag("testXMLUtilTagName", "testXMLUtilTagValue", false);
		assertEquals("result", "<testXMLUtilTagName>testXMLUtilTagValue</testXMLUtilTagName>", result);
	}

	/**
	 *
	 */
	@Test
	public void testBuildTag8() throws Throwable {
		String result = XMLUtil.buildTag("testXMLUtilTagName", null, true);
		assertEquals("result", "", result);
	}

	/**
	 *
	 */
	@Test(expected=NullPointerException.class)
	public void testGetTextContentThrowsNullPointerException() throws Throwable {
		XMLUtil.getTextContent(null);
	}

	/**
	 *
	 */
	@Test(expected=NullPointerException.class)
	public void testParseXMLThrowsNullPointerException() throws Throwable {
		XMLUtil.parseXML((File) null, true);
	}
}

