/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.ui.action;

import com.liferay.ide.eclipse.server.core.ILiferayServer;
import com.liferay.ide.eclipse.server.ui.LiferayServerUIPlugin;
import com.liferay.ide.eclipse.server.ui.action.AbstractServerRunningAction;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;

public class OpenPortalAction
extends AbstractServerRunningAction {
    public void run(IAction action) {
        if (this.selectedServer != null) {
            final ILiferayServer portalServer = (ILiferayServer)this.selectedServer.loadAdapter(ILiferayServer.class, null);
            new Job("Open portal home"){

                protected IStatus run(IProgressMonitor monitor) {
                    OpenPortalAction.this.openPortal(portalServer);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    protected int getRequiredServerState() {
        return 2;
    }

    protected void openBrowser(final URL url, final String browserTitle) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchBrowserSupport browserSupport = ServerUIPlugin.getInstance().getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.createBrowser(6, null, browserTitle, null);
                    browser.openURL(url);
                }
                catch (Exception e) {
                    LiferayServerUIPlugin.logError(e);
                }
            }
        });
    }

    protected void openPortal(ILiferayServer portalServer) {
        URL portalHome = portalServer.getPortalHomeUrl();
        if (portalHome == null) {
            MessageDialog.openError((Shell)this.getActiveShell(), (String)"Open Portal Home", (String)"Could not determine portal home URL. Please make sure the server is properly configured.");
            return;
        }
        this.openBrowser(portalHome, "Liferay Portal");
    }
}

