/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.editor;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FlagAttributeEditor
extends AbstractAttributeEditor {
    private String[] values;
    private CCombo combo;
    private Text requesteeText;
    private final int requesteeTextHint;

    public FlagAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute, int requesteeTextHint) {
        super(manager, taskAttribute);
        this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.SINGLE));
        if (taskAttribute.getAttribute("state") != null) {
            this.setReadOnly(taskAttribute.getAttribute("state").getMetaData().isReadOnly());
        }
        this.requesteeTextHint = requesteeTextHint;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 1;
        composite.setLayout((Layout)layout);
        if (this.isReadOnly()) {
            TaskAttribute requestee;
            Text text = new Text(composite, 0x800008);
            toolkit.adapt((Control)text, false, false);
            text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            text.setText(this.getValueLabel());
            text.setBackground(parent.getBackground());
            text.setEditable(false);
            String tooltip = this.getTaskAttribute().getMetaData().getLabel();
            if (tooltip != null) {
                text.setToolTipText(tooltip);
            }
            if (!"".equals((requestee = this.getTaskAttribute().getAttribute("requestee")).getValue())) {
                text = new Text(composite, 0x800008);
                toolkit.adapt((Control)text, false, false);
                text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
                text.setText(requestee.getValue());
                text.setBackground(parent.getBackground());
                text.setEditable(false);
            }
        } else {
            TaskAttribute requestee;
            this.combo = new CCombo(composite, 0x800008);
            toolkit.adapt((Control)this.combo, false, false);
            this.combo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            String tooltip = this.getTaskAttribute().getMetaData().getLabel();
            if (tooltip != null) {
                this.combo.setToolTipText(tooltip);
            }
            EditorUtil.addScrollListener((CCombo)this.combo);
            Map labelByValue = this.getAttributeMapper().getAssoctiatedAttribute(this.getTaskAttribute()).getOptions();
            if (labelByValue != null) {
                String[] stringArray = this.values = labelByValue.keySet().toArray(new String[0]);
                int n = this.values.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    this.combo.add((String)labelByValue.get(value));
                    ++n2;
                }
            }
            this.select(this.getValue(), this.getValueLabel());
            if (this.values != null) {
                this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        int index = FlagAttributeEditor.this.combo.getSelectionIndex();
                        if (index > -1) {
                            Assert.isNotNull((Object)FlagAttributeEditor.this.values);
                            Assert.isLegal((index >= 0 && index <= FlagAttributeEditor.this.values.length - 1 ? 1 : 0) != 0);
                            FlagAttributeEditor.this.setValue(FlagAttributeEditor.this.values[index]);
                            if (FlagAttributeEditor.this.requesteeText != null) {
                                FlagAttributeEditor.this.requesteeText.setEnabled(FlagAttributeEditor.this.values[index].equals("?"));
                            }
                        }
                    }
                });
            }
            if ((requestee = this.getTaskAttribute().getAttribute("requestee")) != null && !requestee.getMetaData().isReadOnly()) {
                this.requesteeText = toolkit.createText(composite, requestee.getValue());
                this.requesteeText.setEnabled("?".equals(this.getValueLabel()));
                GridData requesteeData = new GridData(4, 0x1000000, false, false);
                requesteeData.widthHint = this.requesteeTextHint;
                this.requesteeText.setLayoutData((Object)requesteeData);
                this.requesteeText.setFont(EditorUtil.TEXT_FONT);
                this.requesteeText.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
                this.requesteeText.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                        FlagAttributeEditor.this.setRequestee(FlagAttributeEditor.this.requesteeText.getText());
                    }

                    public void keyPressed(KeyEvent e) {
                    }
                });
                this.requesteeText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        FlagAttributeEditor.this.setRequestee(FlagAttributeEditor.this.requesteeText.getText());
                    }
                });
                toolkit.adapt((Control)this.requesteeText, false, false);
            }
        }
        toolkit.paintBordersFor(composite);
        this.setControl((Control)composite);
    }

    public String getValue() {
        return this.getAttributeMapper().getValue(this.getAttributeMapper().getAssoctiatedAttribute(this.getTaskAttribute()));
    }

    public String getValueLabel() {
        return this.getAttributeMapper().getValueLabel(this.getAttributeMapper().getAssoctiatedAttribute(this.getTaskAttribute()));
    }

    private void select(String value, String label) {
        if (this.values != null) {
            int i = 0;
            while (i < this.values.length) {
                if (this.values[i].equals(value)) {
                    this.combo.select(i);
                    break;
                }
                ++i;
            }
        } else {
            this.combo.setText(label);
        }
    }

    public void setRequestee(String value) {
        TaskAttribute requestee = this.getTaskAttribute().getAttribute("requestee");
        if (requestee != null && !requestee.getValue().equals(value) && !requestee.getValue().equals(value)) {
            this.getAttributeMapper().setValue(requestee, value);
            this.attributeChanged();
        }
    }

    public void setValue(String value) {
        this.getAttributeMapper().setValue(this.getAttributeMapper().getAssoctiatedAttribute(this.getTaskAttribute()), value);
        this.attributeChanged();
    }

    public String getLabel() {
        String setterValue;
        String label = this.getAttributeMapper().getLabel(this.getAttributeMapper().getAssoctiatedAttribute(this.getTaskAttribute()));
        if (label != null) {
            label.replace("&", "&&");
        } else {
            label = "";
        }
        TaskAttribute setter = this.getTaskAttribute().getAttribute("setter");
        if (setter != null && (setterValue = setter.getValue()) != null && !setterValue.equals("")) {
            if (setterValue.indexOf("@") > -1) {
                setterValue = setterValue.substring(0, setterValue.indexOf("@"));
            }
            label = String.valueOf(setterValue) + ": " + label;
        }
        return label;
    }
}

