/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.ui.snippets;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.ui.snippets.SnippetsUIPlugin;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.core.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.ui.EntrySerializer;
import org.eclipse.wst.common.snippets.internal.util.StringUtils;
import org.eclipse.wst.common.snippets.ui.DefaultSnippetInsertion;

public abstract class AbstractSnippetInsertion
extends DefaultSnippetInsertion {
    protected IEditorPart fEditorPart;
    protected ISnippetItem fItem;

    public void dragSetData(DragSourceEvent event, ISnippetItem item) {
        boolean isSimpleText = TextTransfer.getInstance().isSupportedType(event.dataType);
        if (isSimpleText) {
            String content;
            IWorkbenchWindow window = SnippetsUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            Shell shell = null;
            if (window != null) {
                shell = window.getShell();
            }
            if (this.fItem == null) {
                this.fItem = item;
            }
            if (CoreUtil.isNullOrEmpty((String)(content = this.getResolvedString(shell)))) {
                event.dataType = null;
            }
            String systemEOL = System.getProperty("line.separator");
            content = StringUtils.replace((String)content, (String)"\r\n", (String)"\n");
            content = StringUtils.replace((String)content, (String)"\r", (String)"\n");
            if (!"\n".equals(systemEOL) && systemEOL != null) {
                content = StringUtils.replace((String)content, (String)"\n", (String)systemEOL);
            }
            event.data = content;
        } else {
            event.data = EntrySerializer.getInstance().toXML((ISnippetsEntry)item);
        }
    }

    public void setEditorPart(IEditorPart editorPart) {
        super.setEditorPart(editorPart);
        this.fEditorPart = editorPart;
    }

    public void setItem(ISnippetItem item) {
        super.setItem(item);
        this.fItem = item;
    }

    protected String getInsertString(Shell host) {
        if (this.fItem == null) {
            return "";
        }
        String insertString = this.getResolvedString(host);
        return insertString;
    }

    protected abstract String getResolvedString(Shell var1);
}

