/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.tomcat.core;

import com.liferay.ide.eclipse.core.ILiferayConstants;
import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.core.util.FileUtil;
import com.liferay.ide.eclipse.server.core.LiferayServerCorePlugin;
import com.liferay.ide.eclipse.server.tomcat.core.ILiferayTomcatRuntime;
import com.liferay.ide.eclipse.server.tomcat.core.LiferayTomcat60Handler;
import com.liferay.ide.eclipse.server.tomcat.core.LiferayTomcatPlugin;
import com.liferay.ide.eclipse.server.tomcat.core.util.LiferayTomcatUtil;
import com.liferay.ide.eclipse.server.util.JavaUtil;
import com.liferay.ide.eclipse.server.util.PortalSupportHelper;
import com.liferay.ide.eclipse.server.util.ReleaseHelper;
import com.liferay.ide.eclipse.server.util.ServerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.TomcatRuntime;
import org.eclipse.wst.server.core.model.RuntimeDelegate;
import org.osgi.framework.Version;

public class LiferayTomcatRuntime
extends TomcatRuntime
implements ILiferayTomcatRuntime {
    public static final String PROP_BUNDLE_SOURCE_LOCATION = "bundle-source-location";
    public static final String PROP_BUNDLE_ZIP_LOCATION = "bundle-zip-location";
    public static final String RUNTIME_TYPE_ID = "com.liferay.ide.eclipse.server.tomcat.runtime.60";
    private IStatus runtimeDelegateStatus;
    protected HashMap<IPath, ReleaseHelper> releaseHelpers = new HashMap();

    public IVMInstall findPortalBundledJRE(boolean addVM) {
        IPath jrePath = this.findBundledJREPath(this.getRuntime().getLocation());
        if (jrePath == null) {
            return null;
        }
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = iVMInstallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstallType vmInstallType = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = vmInstallType.getVMInstalls();
            int n3 = iVMInstallArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall vmInstall = iVMInstallArray[n4];
                if (vmInstall.getInstallLocation().equals(jrePath.toFile())) {
                    return vmInstall;
                }
                ++n4;
            }
            ++n2;
        }
        if (addVM) {
            IVMInstallType installType = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
            VMStandin newVM = new VMStandin(installType, JavaUtil.createUniqueId((IVMInstallType)installType));
            newVM.setInstallLocation(jrePath.toFile());
            if (!CoreUtil.isNullOrEmpty((String)this.getRuntime().getName())) {
                newVM.setName(String.valueOf(this.getRuntime().getName()) + " JRE");
            } else {
                newVM.setName("Liferay JRE");
            }
            boolean existingVMWithSameName = ServerUtil.isExistingVMName((String)newVM.getName());
            int num = 1;
            while (existingVMWithSameName) {
                newVM.setName(String.valueOf(this.getRuntime().getName()) + " JRE (" + num++ + ")");
                existingVMWithSameName = ServerUtil.isExistingVMName((String)newVM.getName());
            }
            return newVM.convertToRealVM();
        }
        return null;
    }

    public IPath[] getAllUserClasspathLibraries() {
        return LiferayTomcatUtil.getAllUserClasspathLibraries(this.getRuntimeLocation(), this.getPortalDir());
    }

    public IPath getAppServerDir() {
        return this.getRuntime().getLocation();
    }

    public String getAppServerType() {
        return "tomcat";
    }

    public IPath getBundleZipLocation() {
        String zipLocation = this.getAttribute(PROP_BUNDLE_ZIP_LOCATION, null);
        return zipLocation != null ? new Path(zipLocation) : null;
    }

    public Properties getPortletCategories() {
        return LiferayTomcatUtil.getCategories(this.getRuntimeLocation(), this.getPortalDir());
    }

    public IPath getDeployDir() {
        return this.getAppServerDir().append("/webapps");
    }

    public IPath getLibGlobalDir() {
        return this.getAppServerDir().append("/lib/ext");
    }

    public IPath getPortalDir() {
        return LiferayTomcatUtil.getPortalDir(this.getAppServerDir());
    }

    public IPath getPortalSourceLocation() {
        String sourceLocation = this.getAttribute(PROP_BUNDLE_SOURCE_LOCATION, null);
        return sourceLocation != null ? new Path(sourceLocation) : null;
    }

    public String getPortalVersion() {
        try {
            return LiferayTomcatUtil.getVersion(this.getRuntimeLocation(), this.getPortalDir());
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public IPath getRuntimeLocation() {
        return this.getRuntime().getLocation();
    }

    public String getServerInfo() {
        File serverInfoFile;
        IPath location = this.getRuntime().getLocation();
        IPath serverInfosPath = LiferayTomcatPlugin.getDefault().getStateLocation().append("serverInfos.properties");
        String locationKey = location.toPortableString().replaceAll("\\/", "_");
        File serverInfosFile = serverInfosPath.toFile();
        Properties properties = new Properties();
        if (serverInfosFile.exists()) {
            try {
                properties.load(new FileInputStream(serverInfosFile));
                String serverInfo = (String)properties.get(locationKey);
                if (!CoreUtil.isNullOrEmpty((String)serverInfo)) {
                    return serverInfo;
                }
            }
            catch (Exception exception) {}
        }
        if ((serverInfoFile = LiferayTomcatPlugin.getDefault().getStateLocation().append("serverInfo.txt").toFile()).exists()) {
            FileUtil.clearContents((File)serverInfoFile);
        }
        IPath errorPath = LiferayTomcatPlugin.getDefault().getStateLocation().append("serverInfoError.log");
        File errorFile = errorPath.toFile();
        this.loadServerInfoFile(location, serverInfoFile, errorFile);
        String serverInfoString = FileUtil.readContents((File)serverInfoFile);
        if (!CoreUtil.isNullOrEmpty((String)serverInfoString)) {
            properties.put(locationKey, serverInfoString);
            try {
                properties.store(new FileOutputStream(serverInfosFile), "");
            }
            catch (Exception exception) {}
        }
        return serverInfoString;
    }

    public String[] getSupportedHookProperties() {
        try {
            return LiferayTomcatUtil.getSupportedHookProperties(this.getRuntimeLocation(), this.getPortalDir());
        }
        catch (IOException iOException) {
            return new String[0];
        }
    }

    public ITomcatVersionHandler getVersionHandler() {
        String id = this.getRuntime().getRuntimeType().getId();
        if (id.indexOf("runtime.60") > 0) {
            return new LiferayTomcat60Handler();
        }
        return null;
    }

    public IVMInstall getVMInstall() {
        if (this.getVMInstallTypeId() == null) {
            IVMInstall vmInstall = this.findPortalBundledJRE(false);
            if (vmInstall != null) {
                this.setVMInstall(vmInstall);
                return vmInstall;
            }
            return JavaRuntime.getDefaultVMInstall();
        }
        try {
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)this.getVMInstallTypeId());
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            int size = vmInstalls.length;
            String id = this.getVMInstallId();
            int i = 0;
            while (i < size) {
                if (id.equals(vmInstalls[i].getId())) {
                    return vmInstalls[i];
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void setBundleZipLocation(IPath path) {
        if (path != null) {
            this.setAttribute(PROP_BUNDLE_ZIP_LOCATION, path.toPortableString());
        }
    }

    public void setPortalSourceLocation(IPath path) {
        if (path != null) {
            this.setAttribute(PROP_BUNDLE_SOURCE_LOCATION, path.toPortableString());
        }
    }

    public IStatus validate() {
        IPath bundleZip;
        String serverInfo;
        if (this.runtimeDelegateStatus == null) {
            this.runtimeDelegateStatus = LiferayServerCorePlugin.validateRuntimeDelegate((RuntimeDelegate)this);
        }
        if (!this.runtimeDelegateStatus.isOK()) {
            return this.runtimeDelegateStatus;
        }
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        String version = this.getPortalVersion();
        Version portalVersion = Version.parseVersion((String)version);
        if (portalVersion != null && portalVersion.compareTo((Object)this.getLeastSupportedVersion()) < 0) {
            status = LiferayTomcatPlugin.createErrorStatus("Portal version not supported.  Need at least " + this.getLeastSupportedVersion());
        }
        if (!this.getRuntime().isStub() && (CoreUtil.isNullOrEmpty((String)(serverInfo = this.getServerInfo())) || serverInfo.indexOf(this.getExpectedServerInfo()) < 0)) {
            status = LiferayTomcatPlugin.createErrorStatus("Portal server not supported.  Expecting " + this.getExpectedServerInfo());
        }
        if ((bundleZip = this.getBundleZipLocation()) != null && !CoreUtil.isNullOrEmpty((String)bundleZip.toString())) {
            String rootEntryName = null;
            try {
                ZipInputStream zis = new ZipInputStream(new FileInputStream(bundleZip.toFile()));
                ZipEntry rootEntry = zis.getNextEntry();
                rootEntryName = new Path(rootEntry.getName()).segment(0);
                if (rootEntryName.endsWith("/")) {
                    rootEntryName = rootEntryName.substring(0, rootEntryName.length() - 1);
                }
                boolean foundTomcat = false;
                ZipEntry entry = zis.getNextEntry();
                while (entry != null && !foundTomcat) {
                    String entryName = entry.getName();
                    if (entryName.startsWith(String.valueOf(rootEntryName) + "/tomcat-")) {
                        foundTomcat = true;
                    }
                    entry = zis.getNextEntry();
                }
            }
            catch (Exception exception) {
                return LiferayTomcatPlugin.createWarningStatus((String)"Bundle zip location does not specify a valid Liferay Tomcat bundle.");
            }
            IPath location = this.getRuntime().getLocation();
            String bundleDir = location.removeLastSegments(1).lastSegment();
            if (!bundleDir.equals(rootEntryName)) {
                return LiferayTomcatPlugin.createWarningStatus((String)"Runtime location directory layout does not match zip file.");
            }
        }
        return status;
    }

    private IPath findBundledJREPath(IPath location) {
        if (Platform.getOS().equals("win32") && location != null && location.toFile().exists()) {
            String[] jre;
            File tomcat = location.toFile();
            String[] stringArray = jre = tomcat.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("jre");
                }
            });
            int n = jre.length;
            int n2 = 0;
            while (n2 < n) {
                String dir = stringArray[n2];
                File javaw = new File(location.toFile(), String.valueOf(dir) + "/win/bin/javaw.exe");
                if (javaw.exists()) {
                    return new Path(javaw.getPath()).removeLastSegments(2);
                }
                ++n2;
            }
        }
        return null;
    }

    protected String getExpectedServerInfo() {
        return "Liferay Portal";
    }

    protected Version getLeastSupportedVersion() {
        return ILiferayConstants.LEAST_SUPPORTED_VERSION;
    }

    protected ReleaseHelper getReleaseHelper(IPath serviceJar) {
        ReleaseHelper cachedHelper;
        if (this.releaseHelpers == null) {
            this.releaseHelpers = new HashMap();
        }
        if ((cachedHelper = this.releaseHelpers.get(serviceJar)) != null) {
            return cachedHelper;
        }
        ReleaseHelper newHelper = new ReleaseHelper(serviceJar);
        this.releaseHelpers.put(serviceJar, newHelper);
        return newHelper;
    }

    protected void loadServerInfoFile(IPath location, File versionInfoFile, File errorFile) {
        String portalSupportClass = "com.liferay.ide.eclipse.server.core.support.ReleaseInfoGetServerInfo";
        IPath[] libRoots = new IPath[]{location.append("lib"), location.append("lib/ext")};
        IPath portalDir = this.getPortalDir();
        try {
            URL[] supportUrls = new URL[]{FileLocator.toFileURL((URL)LiferayServerCorePlugin.getDefault().getBundle().getEntry("portal-support/portal-support.jar"))};
            PortalSupportHelper helper = new PortalSupportHelper(libRoots, portalDir, portalSupportClass, versionInfoFile, errorFile, supportUrls, new String[0]);
            helper.launch(null);
        }
        catch (Exception e) {
            LiferayTomcatPlugin.logError((Throwable)e);
        }
    }
}

