/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.tomcat.core;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.server.core.ILiferayServer;
import com.liferay.ide.eclipse.server.tomcat.core.ILiferayTomcatConfiguration;
import com.liferay.ide.eclipse.server.tomcat.core.ILiferayTomcatConstants;
import com.liferay.ide.eclipse.server.tomcat.core.ILiferayTomcatServer;
import com.liferay.ide.eclipse.server.tomcat.core.ILiferayTomcatServerWC;
import com.liferay.ide.eclipse.server.tomcat.core.LiferayTomcat60Configuration;
import com.liferay.ide.eclipse.server.tomcat.core.LiferayTomcat60Handler;
import com.liferay.ide.eclipse.server.tomcat.core.LiferayTomcatPlugin;
import com.liferay.ide.eclipse.server.tomcat.core.LiferayTomcatRuntime;
import com.liferay.ide.eclipse.server.tomcat.core.util.LiferayTomcatUtil;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.TomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class LiferayTomcatServer
extends TomcatServer
implements ILiferayTomcatConstants,
ILiferayTomcatServer,
ILiferayTomcatServerWC,
ILiferayServer {
    public String getAutoDeployDirectory() {
        return this.getAttribute("autoDeployDir", "../deploy");
    }

    public String getAutoDeployInterval() {
        return this.getAttribute("autoDeployInterval", "500");
    }

    public String getExternalProperties() {
        return this.getAttribute("externalProperties", "");
    }

    public String getMemoryArgs() {
        return this.getAttribute("memoryArgs", ILiferayTomcatConstants.DEFAULT_MEMORY_ARGS);
    }

    public URL getPortalHomeUrl() {
        TomcatConfiguration config;
        block4: {
            try {
                config = this.getTomcatConfiguration();
                if (config != null) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        String url = "http://" + this.getServer().getHost();
        int port = config.getMainPort().getPort();
        port = ServerUtil.getMonitoredPort((IServer)this.getServer(), (int)port, (String)"web");
        if (port != 80) {
            url = String.valueOf(url) + ":" + port;
        }
        return new URL(url);
    }

    public ILiferayTomcatConfiguration getLiferayTomcatConfiguration() throws CoreException {
        return (ILiferayTomcatConfiguration)this.getTomcatConfiguration();
    }

    public TomcatConfiguration getTomcatConfiguration() throws CoreException {
        if (this.configuration == null) {
            IFolder folder = this.getServer().getServerConfiguration();
            if (folder == null || !folder.exists()) {
                String path = null;
                if (folder != null) {
                    path = folder.getFullPath().toOSString();
                    IProject project = folder.getProject();
                    if (project != null && project.exists() && !project.isOpen()) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorConfigurationProjectClosed, (Object)path, (Object)project.getName()), null));
                    }
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorNoConfiguration, (Object)path), null));
            }
            String id = this.getServer().getServerType().getId();
            if (id.indexOf("60") > 0) {
                this.configuration = new LiferayTomcat60Configuration(folder);
            }
            try {
                ((ILiferayTomcatConfiguration)this.configuration).load(folder, null);
            }
            catch (CoreException ce) {
                this.configuration = null;
                throw ce;
            }
        }
        return this.configuration;
    }

    public ITomcatVersionHandler getTomcatVersionHandler() {
        ITomcatVersionHandler handler = super.getTomcatVersionHandler();
        if (handler instanceof LiferayTomcat60Handler) {
            ((LiferayTomcat60Handler)handler).setCurrentServer(this.getServer());
        }
        return handler;
    }

    public String getUserTimezone() {
        return this.getAttribute("userTimezone", ILiferayTomcatConstants.DEFAULT_USER_TIMEZONE);
    }

    public URL getWebServicesListURL() {
        try {
            return new URL(this.getPortalHomeUrl(), "/tunnel-web/axis");
        }
        catch (MalformedURLException e) {
            LiferayTomcatPlugin.logError("Unable to get web services list URL", e);
            return null;
        }
    }

    public void importRuntimeConfiguration(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        if (runtime == null) {
            this.configuration = null;
            return;
        }
        IPath path = runtime.getLocation().append("conf");
        String id = this.getServer().getServerType().getId();
        IFolder folder = this.getServer().getServerConfiguration();
        if (id.indexOf("60") > 0) {
            this.configuration = new LiferayTomcat60Configuration(folder);
        }
        if (path.toFile().exists()) {
            try {
                this.configuration.importFromPath(path, this.isTestEnvironment(), monitor);
            }
            catch (CoreException ce) {
                this.configuration = null;
                throw ce;
            }
        }
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        boolean addingExt = false;
        boolean removingExt = false;
        if (!CoreUtil.isNullOrEmpty((Object[])add)) {
            IModule[] iModuleArray = add;
            int n = add.length;
            int n2 = 0;
            while (n2 < n) {
                IModule m = iModuleArray[n2];
                if (m.getProject() != null && ProjectUtil.isExtProject((IProject)m.getProject())) {
                    addingExt = true;
                    break;
                }
                ++n2;
            }
        } else if (!CoreUtil.isNullOrEmpty((Object[])remove)) {
            IModule[] iModuleArray = remove;
            int n = remove.length;
            int n3 = 0;
            while (n3 < n) {
                IModule m = iModuleArray[n3];
                if (m.getProject() != null && ProjectUtil.isExtProject((IProject)m.getProject())) {
                    removingExt = true;
                    break;
                }
                ++n3;
            }
        }
        if (!addingExt && removingExt) {
            LiferayTomcatUtil.displayToggleMessage("Removing the Ext plugin will only update the metadata; it will not actually restore any changes made by the Ext plugin.  To restore the server to its original state, use the \"Clean App Server\" action available in the project context menu.", "REMOVE_EXT_PLUGIN_TOGGLE_KEY");
        }
        super.modifyModules(add, remove, monitor);
    }

    public void saveConfiguration(IProgressMonitor monitor) throws CoreException {
        LiferayTomcatRuntime portalRuntime = (LiferayTomcatRuntime)this.getServer().getRuntime().loadAdapter(LiferayTomcatRuntime.class, monitor);
        String serverInfo = portalRuntime.getServerInfo();
        String expectedServerInfo = portalRuntime.getExpectedServerInfo();
        if (serverInfo != null && expectedServerInfo != null && serverInfo.contains("Enterprise Edition") && !expectedServerInfo.contains("Enterprise Edition")) {
            LiferayTomcatUtil.displayToggleMessage("The runtime type for this Server is Liferay Portal CE (Community Edition). However, the actual runtime configured is Liferay Portal Enterprise Edition. The current server will work correctly but please consider switching to the Liferay Portal EE runtime type for enhanced support.\n\nThe Liferay Portal EE adapter is found in Liferay Developer Studio which is available for free to EE customers.  More infomation is on the customer portal home page on http://www.liferay.com/group/customer", "EE_UPGRADE_MSG_TOGGLE_KEY");
        }
        super.saveConfiguration(monitor);
    }

    public void setAutoDeployDirectory(String dir) {
        this.setAttribute("autoDeployDir", dir);
    }

    public void setAutoDeployInterval(String interval) {
        this.setAttribute("autoDeployInterval", interval);
    }

    public void setDefaults(IProgressMonitor monitor) {
        super.setDefaults(monitor);
        this.setTestEnvironment(false);
        this.setDeployDirectory("webapps");
        this.setSaveSeparateContextFiles(true);
    }

    public void setExternalProperties(String externalProperties) {
        this.setAttribute("externalProperties", externalProperties);
    }

    public void setMemoryArgs(String memoryArgs) {
        this.setAttribute("memoryArgs", memoryArgs);
    }

    public void setUserTimezone(String userTimezone) {
        this.setAttribute("userTimezone", userTimezone);
    }

    protected IPersistentPreferenceStore getPrefStore() {
        return LiferayTomcatPlugin.getPreferenceStore();
    }
}

