/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.tomcat.core;

import com.liferay.ide.eclipse.project.core.facet.IPluginFacetConstants;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.server.core.AbstractPluginPublisher;
import com.liferay.ide.eclipse.server.tomcat.core.ILiferayTomcatConstants;
import com.liferay.ide.eclipse.server.tomcat.core.LiferayTomcatPlugin;
import com.liferay.ide.eclipse.server.tomcat.core.util.LiferayTomcatUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;

public class TomcatExtPluginPublisher
extends AbstractPluginPublisher {
    public TomcatExtPluginPublisher() {
    }

    public TomcatExtPluginPublisher(String facetId) {
        super(facetId);
    }

    public IStatus canPublishModule(IServer server, IModule module) {
        if (ILiferayTomcatConstants.PREVENT_MULTI_EXT_PLUGINS_DEPLOY && module != null && server != null && ProjectUtil.isExtProject((IProject)module.getProject())) {
            IModule[] iModuleArray = server.getModules();
            int n = iModuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModule currentModule = iModuleArray[n2];
                if (ProjectUtil.isExtProject((IProject)currentModule.getProject())) {
                    return LiferayTomcatPlugin.createErrorStatus("Portal can only have on Ext-plugin deployed at a time.");
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }

    public boolean prePublishModule(ServerBehaviourDelegate delegate, int kind, int deltaKind, IModule[] moduleTree, IModuleResourceDelta[] delta, IProgressMonitor monitor) {
        if (kind == 3) {
            LiferayTomcatUtil.displayToggleMessage("The Ext plugin does not support auto-publishing.  To redeploy changes from this plugin you will need to manually publish the server from the Servers view.", "ADDED_EXT_PLUGIN_TOGGLE_KEY");
            return false;
        }
        if (kind == 4 || moduleTree == null) {
            return false;
        }
        try {
            if (deltaKind == 1 || deltaKind == 2) {
                this.addExtModule(delegate, moduleTree[0], monitor);
            }
        }
        catch (Exception e) {
            LiferayTomcatPlugin.logError("Failed pre-publishing ext module.", e);
            return false;
        }
        return true;
    }

    protected void addExtModule(ServerBehaviourDelegate delegate, IModule module, IProgressMonitor monitor) throws CoreException {
        String mode;
        SDK sdk = null;
        IProject project = module.getProject();
        sdk = ProjectUtil.getSDK((IProject)project, (IProjectFacet)IPluginFacetConstants.LIFERAY_EXT_PROJECT_FACET);
        if (sdk == null) {
            throw new CoreException(LiferayTomcatPlugin.createErrorStatus("No SDK for project configured. Could not deploy ext module"));
        }
        String string = mode = delegate.getServer().getServerState() == 2 ? delegate.getServer().getMode() : null;
        if (mode != null) {
            LiferayTomcatUtil.syncStopServer(delegate.getServer());
        }
        IStatus status = sdk.directDeploy(project, null, true);
        this.assertStatus(status);
        if (mode != null) {
            delegate.getServer().start(mode, monitor);
        }
    }

    protected void assertStatus(IStatus status) throws CoreException {
        if (status == null) {
            throw new CoreException(LiferayTomcatPlugin.createErrorStatus("null status"));
        }
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    protected void removeExtModule(ServerBehaviourDelegate delegate, IModule module, IProgressMonitor monitor) throws CoreException {
    }
}

