/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.tomcat.core.job;

import com.liferay.ide.eclipse.sdk.job.SDKJob;
import com.liferay.ide.eclipse.server.tomcat.core.ILiferayTomcatRuntime;
import com.liferay.ide.eclipse.server.tomcat.core.LiferayTomcatPlugin;
import com.liferay.ide.eclipse.server.tomcat.core.LiferayTomcatServerBehavior;
import com.liferay.ide.eclipse.server.tomcat.core.util.LiferayTomcatUtil;
import com.liferay.ide.eclipse.server.util.ServerUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

public class CleanAppServerJob
extends SDKJob {
    public CleanAppServerJob(IProject project) {
        super("Clean App Server");
        this.setUser(true);
        this.setProject(project);
    }

    protected void assertStatus(IStatus status) throws CoreException {
        if (status == null) {
            throw new CoreException(LiferayTomcatPlugin.createErrorStatus("null status"));
        }
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus retval = Status.OK_STATUS;
        if (monitor != null) {
            monitor.beginTask("Running clean-app-server task...", -1);
        }
        try {
            IServer[] servers;
            IRuntime runtime = ServerUtil.getRuntime((IProject)this.project);
            IServer[] iServerArray = servers = ServerUtil.getServersForRuntime((IRuntime)runtime);
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                String mode;
                IServer server = iServerArray[n2];
                String string = mode = server.getServerState() == 2 ? server.getMode() : null;
                if (mode != null) {
                    LiferayTomcatUtil.syncStopServer(server);
                }
                ++n2;
            }
            ILiferayTomcatRuntime portalTomcatRuntime = LiferayTomcatUtil.getLiferayTomcatRuntime(runtime);
            IPath bundleZipLocation = portalTomcatRuntime.getBundleZipLocation();
            IStatus status = this.getSDK().cleanAppServer(this.project, bundleZipLocation);
            this.assertStatus(status);
            IServer[] iServerArray2 = servers;
            int n3 = servers.length;
            int n4 = 0;
            while (n4 < n3) {
                IModule[] modules;
                IServer server = iServerArray2[n4];
                IModule[] iModuleArray = modules = server.getModules();
                int n5 = modules.length;
                int n6 = 0;
                while (n6 < n5) {
                    IModule mod = iModuleArray[n6];
                    IModule[] m = new IModule[]{mod};
                    ((LiferayTomcatServerBehavior)((Object)server.loadAdapter(LiferayTomcatServerBehavior.class, monitor))).setModulePublishState2(m, 3);
                    ++n6;
                }
                ++n4;
            }
        }
        catch (Exception ex) {
            retval = LiferayTomcatPlugin.createErrorStatus((Exception)ex);
        }
        if (monitor != null) {
            monitor.done();
        }
        return retval;
    }
}

