/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.sdk.SDK;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorations;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorationsManager;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public abstract class PluginClasspathContainer
implements IClasspathContainer {
    protected static ClasspathDecorationsManager cpDecorations = new ClasspathDecorationsManager("com.liferay.ide.eclipse.server.core");
    protected static final String SEPARATOR = "!";
    protected IClasspathEntry[] classpathEntries;
    protected IJavaProject javaProject;
    protected IPath path;
    protected IPath pluginPackageFilePath;
    protected IPath portalDir;

    public static String getDecorationManagerKey(IProject project, String container) {
        return String.valueOf(project.getName()) + SEPARATOR + container;
    }

    static ClasspathDecorationsManager getDecorationsManager() {
        return cpDecorations;
    }

    public PluginClasspathContainer(IPath containerPath, IJavaProject project, IPath portalDir) {
        this.path = containerPath;
        this.javaProject = project;
        this.portalDir = portalDir;
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.classpathEntries == null) {
            ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
            if (this.portalDir != null) {
                String[] stringArray = this.getPortalJars();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String pluginJar = stringArray[n2];
                    entries.add(this.createPortalJarClasspathEntry(pluginJar));
                    ++n2;
                }
                stringArray = this.getPortalDependencyJars();
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    String pluginPackageJar = stringArray[n2];
                    entries.add(this.createPortalJarClasspathEntry(pluginPackageJar));
                    ++n2;
                }
            }
            this.classpathEntries = entries.toArray(new IClasspathEntry[entries.size()]);
        }
        return this.classpathEntries;
    }

    public abstract String getDescription();

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    public IPath getPortalDir() {
        return this.portalDir;
    }

    protected IClasspathEntry createClasspathEntry(IPath entryPath, IPath sourcePath) {
        IPath sourceRootPath = null;
        IAccessRule[] rules = new IAccessRule[]{};
        IClasspathAttribute[] attrs = new IClasspathAttribute[]{};
        ClasspathDecorations dec = cpDecorations.getDecorations(PluginClasspathContainer.getDecorationManagerKey(this.javaProject.getProject(), this.getPath().toString()), entryPath.toString());
        if (dec != null) {
            sourcePath = dec.getSourceAttachmentPath();
            sourceRootPath = dec.getSourceAttachmentRootPath();
            attrs = dec.getExtraAttributes();
        }
        return JavaCore.newLibraryEntry((IPath)entryPath, (IPath)sourcePath, (IPath)sourceRootPath, (IAccessRule[])rules, (IClasspathAttribute[])attrs, (boolean)false);
    }

    protected IClasspathEntry createContextClasspathEntry(String context) {
        String type;
        IProject project;
        SDK sdk;
        IPath sdkLocation;
        IPath serviceJarPath;
        IClasspathEntry entry = null;
        IFile serviceJar = ProjectUtil.findServiceJarForContext(context);
        if (serviceJar.exists()) {
            IFolder docroot = ProjectUtil.getDocroot(serviceJar.getProject());
            IFolder serviceFolder = docroot.getFolder("WEB-INF/service");
            entry = this.createClasspathEntry(serviceJar.getLocation(), serviceFolder.exists() ? serviceFolder.getLocation() : null);
        }
        if (entry == null && (serviceJarPath = (sdkLocation = (sdk = ProjectUtil.getSDK(project = this.javaProject.getProject())).getLocation()).append(type = ProjectUtil.isPortletProject(project) ? "portlets" : (ProjectUtil.isHookProject(project) ? "hooks" : (ProjectUtil.isExtProject(project) ? "ext" : ""))).append(context).append("docroot/WEB-INF/lib").append(String.valueOf(context) + "-service.jar")).toFile().exists()) {
            IPath servicePath = serviceJarPath.removeLastSegments(2).append("service");
            entry = this.createClasspathEntry(serviceJarPath, (IPath)(servicePath.toFile().exists() ? servicePath : null));
        }
        return entry;
    }

    protected IClasspathEntry createPortalJarClasspathEntry(String portalJar) {
        IPath entryPath = this.portalDir.append("/WEB-INF/lib/" + portalJar);
        return this.createClasspathEntry(entryPath, null);
    }

    protected IClasspathEntry findSuggestedEntry(IPath jarPath, IClasspathEntry[] suggestedEntries) {
        if (jarPath != null && !CoreUtil.isNullOrEmpty((String)jarPath.toString()) && !CoreUtil.isNullOrEmpty((Object[])suggestedEntries)) {
            int matchLength = jarPath.segmentCount();
            IClasspathEntry[] iClasspathEntryArray = suggestedEntries;
            int n = suggestedEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry suggestedEntry = iClasspathEntryArray[n2];
                IPath suggestedPath = suggestedEntry.getPath();
                IPath pathToMatch = suggestedPath.removeFirstSegments(suggestedPath.segmentCount() - matchLength).setDevice(null).makeAbsolute();
                if (jarPath.equals((Object)pathToMatch)) {
                    return suggestedEntry;
                }
                ++n2;
            }
        }
        return null;
    }

    protected IFile getPluginPackageFile() {
        IFile retval = null;
        if (this.pluginPackageFilePath == null) {
            retval = this.lookupPluginPackageFile();
            if (retval != null && retval.exists()) {
                this.pluginPackageFilePath = retval.getFullPath();
                return retval;
            }
        } else {
            retval = ResourcesPlugin.getWorkspace().getRoot().getFile(this.pluginPackageFilePath);
            if (!retval.exists()) {
                this.pluginPackageFilePath = null;
                retval = this.lookupPluginPackageFile();
            }
        }
        return retval;
    }

    protected String[] getPortalDependencyJars() {
        String[] jars = new String[]{};
        IFile pluginPackageFile = this.getPluginPackageFile();
        try {
            String deps = this.getPropertyValue("portal-dependency-jars", pluginPackageFile);
            String[] split = deps.split(",");
            if (split.length > 0 && !CoreUtil.isNullOrEmpty((String)split[0])) {
                return split;
            }
        }
        catch (Exception exception) {}
        return jars;
    }

    protected abstract String[] getPortalJars();

    protected String getPropertyValue(String key, IFile propertiesFile) {
        String retval = null;
        try {
            Properties props = new Properties();
            props.load(this.getPluginPackageFile().getContents());
            retval = props.getProperty(key, "");
        }
        catch (Exception exception) {}
        return retval;
    }

    protected String[] getRequiredDeploymentContexts() {
        String[] jars = new String[]{};
        IFile pluginPackageFile = this.getPluginPackageFile();
        try {
            String context = this.getPropertyValue("required-deployment-contexts", pluginPackageFile);
            String[] split = context.split(",");
            if (split.length > 0 && !CoreUtil.isNullOrEmpty((String)split[0])) {
                return split;
            }
        }
        catch (Exception exception) {}
        return jars;
    }

    protected IFile lookupPluginPackageFile() {
        IFolder webroot;
        IContainer resource;
        IFile pluginPackageFile = null;
        IVirtualComponent comp = ComponentCore.createComponent((IProject)this.javaProject.getProject());
        if (comp != null && (resource = comp.getRootFolder().getUnderlyingFolder()) instanceof IFolder && !(pluginPackageFile = (webroot = (IFolder)resource).getFile("WEB-INF/liferay-plugin-package.properties")).exists() && webroot.getFullPath().toPortableString().endsWith("WEB-INF/ext-web/docroot")) {
            IPath parentDocroot = webroot.getFullPath().removeFirstSegments(1).removeLastSegments(3);
            IFolder parentWebroot = this.javaProject.getProject().getFolder(parentDocroot);
            if (parentWebroot.exists()) {
                pluginPackageFile = parentWebroot.getFile("WEB-INF/liferay-plugin-package.properties");
            }
        }
        return pluginPackageFile;
    }
}

