/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core;

import com.liferay.ide.eclipse.project.core.ExtClasspathContainer;
import com.liferay.ide.eclipse.project.core.HookClasspathContainer;
import com.liferay.ide.eclipse.project.core.PluginClasspathContainer;
import com.liferay.ide.eclipse.project.core.PortletClasspathContainer;
import com.liferay.ide.eclipse.project.core.ProjectCorePlugin;
import com.liferay.ide.eclipse.server.core.LiferayServerCorePlugin;
import com.liferay.ide.eclipse.server.util.ServerUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorations;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorationsManager;

public class PluginClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public static final String ID = "com.liferay.ide.eclipse.server.plugin.container";
    protected static final ClasspathDecorationsManager cpDecorations = PluginClasspathContainer.getDecorationsManager();

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        IClasspathContainer classpathContainer = null;
        int count = containerPath.segmentCount();
        if (count != 2) {
            throw new CoreException(ProjectCorePlugin.createErrorStatus((String)"Invalid plugin classpath container should expecting 2 segments."));
        }
        String root = containerPath.segment(0);
        if (!ID.equals(root)) {
            throw new CoreException(ProjectCorePlugin.createErrorStatus((String)"Invalid plugin classpath container, expecting container root com.liferay.ide.eclipse.server.plugin.container"));
        }
        String finalSegment = containerPath.segment(1);
        IPath portalDir = ServerUtil.getPortalDir((IJavaProject)project);
        if (portalDir == null) {
            return;
        }
        classpathContainer = this.getCorrectContainer(containerPath, finalSegment, project, portalDir);
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{classpathContainer}, null);
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        String key = PluginClasspathContainer.getDecorationManagerKey(project.getProject(), containerPath.toString());
        IClasspathEntry[] entries = containerSuggestion.getClasspathEntries();
        cpDecorations.clearAllDecorations(key);
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            IPath srcpath = entry.getSourceAttachmentPath();
            IPath srcrootpath = entry.getSourceAttachmentRootPath();
            IClasspathAttribute[] attrs = entry.getExtraAttributes();
            if (srcpath != null || attrs.length > 0) {
                String eid = entry.getPath().toString();
                ClasspathDecorations dec = new ClasspathDecorations();
                dec.setSourceAttachmentPath(srcpath);
                dec.setSourceAttachmentRootPath(srcrootpath);
                dec.setExtraAttributes(attrs);
                cpDecorations.setDecorations(key, eid, dec);
            }
            ++i;
        }
        cpDecorations.save();
        IPath portalDir = null;
        portalDir = containerSuggestion instanceof PluginClasspathContainer ? ((PluginClasspathContainer)containerSuggestion).getPortalDir() : ServerUtil.getPortalDir((IJavaProject)project);
        IClasspathContainer newContainer = this.getCorrectContainer(containerPath, containerPath.segment(1), project, portalDir);
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{newContainer}, null);
    }

    protected IClasspathContainer getCorrectContainer(IPath containerPath, String finalSegment, IJavaProject project, IPath portalDir) throws CoreException {
        PluginClasspathContainer classpathContainer = null;
        if ("portlet".equals(finalSegment)) {
            classpathContainer = new PortletClasspathContainer(containerPath, project, portalDir);
        } else if ("hook".equals(finalSegment)) {
            classpathContainer = new HookClasspathContainer(containerPath, project, portalDir);
        } else if ("ext".equals(finalSegment)) {
            classpathContainer = new ExtClasspathContainer(containerPath, project, portalDir);
        } else {
            throw new CoreException(LiferayServerCorePlugin.createErrorStatus((String)("Invalid final segment of type: " + finalSegment)));
        }
        return classpathContainer;
    }
}

