/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core;

import com.liferay.ide.eclipse.core.CorePlugin;
import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.AbstractPortletFramework;
import com.liferay.ide.eclipse.project.core.AbstractProjectDefinition;
import com.liferay.ide.eclipse.project.core.IPortletFramework;
import com.liferay.ide.eclipse.project.core.IProjectDefinition;
import com.liferay.ide.eclipse.project.core.PluginPackageResourceListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.osgi.framework.BundleContext;

public class ProjectCorePlugin
extends CorePlugin {
    public static final String PLUGIN_ID = "com.liferay.ide.eclipse.project.core";
    public static final String USE_PROJECT_SETTINGS = "use-project-settings";
    private static ProjectCorePlugin plugin;
    private static PluginPackageResourceListener pluginPackageResourceListener;
    private static IPortletFramework[] portletFrameworks;
    private static IProjectDefinition[] projectDefinitions;

    static {
        projectDefinitions = null;
    }

    public static ProjectCorePlugin getDefault() {
        return plugin;
    }

    public static IPortletFramework[] getPortletFrameworks() {
        Object[] elements;
        if (portletFrameworks == null && !CoreUtil.isNullOrEmpty((Object[])(elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.eclipse.project.core.portletFrameworks")))) {
            ArrayList<AbstractPortletFramework> frameworks = new ArrayList<AbstractPortletFramework>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                String id = element.getAttribute("id");
                String shortName = element.getAttribute("shortName");
                String displayName = element.getAttribute("displayName");
                String description = element.getAttribute("description");
                String requiredSDKVersion = element.getAttribute("requiredSDKVersion");
                boolean isDefault = Boolean.parseBoolean(element.getAttribute("default"));
                URL helpUrl = null;
                try {
                    helpUrl = new URL(element.getAttribute("helpUrl"));
                }
                catch (Exception exception) {}
                try {
                    AbstractPortletFramework framework = (AbstractPortletFramework)element.createExecutableExtension("class");
                    framework.setId(id);
                    framework.setShortName(shortName);
                    framework.setDisplayName(displayName);
                    framework.setDescription(description);
                    framework.setRequiredSDKVersion(requiredSDKVersion);
                    framework.setHelpUrl(helpUrl);
                    framework.setDefault(isDefault);
                    framework.setBundleId(element.getContributor().getName());
                    frameworks.add(framework);
                }
                catch (Exception e) {
                    ProjectCorePlugin.logError("Could not create portlet framework.", e);
                }
                ++n2;
            }
            portletFrameworks = frameworks.toArray(new IPortletFramework[0]);
            Arrays.sort(portletFrameworks, 0, portletFrameworks.length, new Comparator<IPortletFramework>(){

                @Override
                public int compare(IPortletFramework o1, IPortletFramework o2) {
                    if (o1.isDefault() && !o2.isDefault()) {
                        return -1;
                    }
                    if (!o1.isDefault() && o2.isDefault()) {
                        return 1;
                    }
                    return o1.getShortName().compareTo(o2.getShortName());
                }
            });
        }
        return portletFrameworks;
    }

    public static IProjectDefinition getProjectDefinition(IProjectFacet projectFacet) {
        IProjectDefinition[] definitions = ProjectCorePlugin.getProjectDefinitions();
        if (definitions != null) {
            IProjectDefinition[] iProjectDefinitionArray = definitions;
            int n = definitions.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectDefinition def = iProjectDefinitionArray[n2];
                if (def != null && def.getFacet() != null && def.getFacet().equals(projectFacet)) {
                    return def;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IProjectDefinition getProjectDefinition(String type) {
        IProjectDefinition[] defs = ProjectCorePlugin.getProjectDefinitions();
        if (defs != null && defs.length > 0) {
            IProjectDefinition[] iProjectDefinitionArray = defs;
            int n = defs.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectDefinition def = iProjectDefinitionArray[n2];
                if (def != null && def.getFacetId().equals(type)) {
                    return def;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IProjectDefinition[] getProjectDefinitions() {
        if (projectDefinitions == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.eclipse.project.core.liferayProjects");
            try {
                ArrayList<AbstractProjectDefinition> definitions = new ArrayList<AbstractProjectDefinition>();
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    Object o = element.createExecutableExtension("class");
                    if (o instanceof AbstractProjectDefinition) {
                        AbstractProjectDefinition projectDefinition = (AbstractProjectDefinition)o;
                        projectDefinition.setFacetId(element.getAttribute("facetId"));
                        projectDefinition.setShortName(element.getAttribute("shortName"));
                        projectDefinition.setDisplayName(element.getAttribute("displayName"));
                        projectDefinition.setFacetedProjectTemplateId(element.getAttribute("facetedProjectTemplateId"));
                        int menuIndex = Integer.MAX_VALUE;
                        try {
                            String intVal = element.getAttribute("menuIndex");
                            if (intVal != null) {
                                menuIndex = Integer.parseInt(intVal);
                            }
                        }
                        catch (Exception e) {
                            ProjectCorePlugin.logError("Error reading project definition.", e);
                        }
                        projectDefinition.setMenuIndex(menuIndex);
                        definitions.add(projectDefinition);
                    }
                    ++n2;
                }
                projectDefinitions = definitions.toArray(new IProjectDefinition[0]);
            }
            catch (Exception e) {
                ProjectCorePlugin.logError((Throwable)e);
            }
        }
        return projectDefinitions;
    }

    public static void logError(String msg, Exception e) {
        ProjectCorePlugin.getDefault().getLog().log(ProjectCorePlugin.createErrorStatus((String)msg, (Throwable)e));
    }

    public ProjectCorePlugin() {
        pluginPackageResourceListener = new PluginPackageResourceListener();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)pluginPackageResourceListener, 1);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        if (pluginPackageResourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)pluginPackageResourceListener);
        }
    }

    public static /* bridge */ /* synthetic */ CorePlugin getDefault() {
        return ProjectCorePlugin.getDefault();
    }
}

