/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core;

import com.liferay.ide.eclipse.project.core.ISDKProjectsImportDataModelProperties;
import com.liferay.ide.eclipse.project.core.ProjectCorePlugin;
import com.liferay.ide.eclipse.project.core.ProjectRecord;
import com.liferay.ide.eclipse.project.core.SDKProjectConvertOperation;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.sdk.SDKManager;
import com.liferay.ide.eclipse.sdk.util.SDKUtil;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.datamodel.FacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;
import org.osgi.framework.Version;

public class SDKProjectConvertDataModelProvider
extends FacetProjectCreationDataModelProvider
implements ISDKProjectsImportDataModelProperties {
    private IProject project;

    public SDKProjectConvertDataModelProvider() {
        this(null);
    }

    public SDKProjectConvertDataModelProvider(IProject project) {
        this.project = project;
    }

    public IDataModelOperation getDefaultOperation() {
        return new SDKProjectConvertOperation(this.getDataModel());
    }

    public Object getDefaultProperty(String propertyName) {
        if ("ISDKProjectsImportDataModelProperties.SDK_LOCATION".equals(propertyName)) {
            IPath rawLocation = this.project.getRawLocation();
            if (rawLocation == null) {
                URI absoluteUri = this.project.getLocationURI();
                rawLocation = new Path(absoluteUri.getPath());
            }
            return rawLocation.removeLastSegments(2).toOSString();
        }
        if ("ISDKProjectsImportDataModelProperties.SDK_VERSION".equals(propertyName)) {
            String sdkLoc = this.getStringProperty("ISDKProjectsImportDataModelProperties.SDK_LOCATION");
            try {
                boolean validSDKLocation = SDKUtil.isValidSDKLocation((String)sdkLoc);
                if (validSDKLocation) {
                    String sdkVersionValue = SDKUtil.readSDKVersion((String)sdkLoc);
                    Version v = new Version(sdkVersionValue);
                    return v.toString();
                }
                return "";
            }
            catch (Exception exception) {}
        } else if ("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS".equals(propertyName)) {
            return new ProjectRecord[]{new ProjectRecord(this.project)};
        }
        return super.getDefaultProperty(propertyName);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("ISDKProjectsImportDataModelProperties.SDK_LOCATION");
        propertyNames.add("ISDKProjectsImportDataModelProperties.SDK_VERSION");
        propertyNames.add("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS");
        return propertyNames;
    }

    public void init() {
        super.init();
        IFacetedProjectWorkingCopy facetedProject = this.getFacetedProjectWorkingCopy();
        Set<IProjectFacetVersion> facets = ProjectUtil.getFacetsForPreset("liferay.portlet.preset");
        HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
        for (IProjectFacetVersion pfv : facets) {
            fixedFacets.add(pfv.getProjectFacet());
        }
        facetedProject.setFixedProjectFacets(Collections.unmodifiableSet(fixedFacets));
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("ISDKProjectsImportDataModelProperties.SDK_VERSION".equals(propertyName)) {
            return false;
        }
        if ("ISDKProjectsImportDataModelProperties.SDK_LOCATION".equals(propertyName)) {
            return false;
        }
        if ("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS".equals(propertyName)) {
            return false;
        }
        return super.isPropertyEnabled(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        return super.propertySet(propertyName, propertyValue);
    }

    public IStatus validate(String name) {
        if ("ISDKProjectsImportDataModelProperties.SDK_LOCATION".equals(name)) {
            String sdkLocation = this.getStringProperty("ISDKProjectsImportDataModelProperties.SDK_LOCATION");
            if (SDKUtil.isValidSDKLocation((String)sdkLocation)) {
                return Status.OK_STATUS;
            }
            return ProjectCorePlugin.createErrorStatus((String)"Invalid Plugin SDK location.");
        }
        if ("ISDKProjectsImportDataModelProperties.SDK_VERSION".equals(name)) {
            String sdkVersion = this.getStringProperty("ISDKProjectsImportDataModelProperties.SDK_VERSION");
            if (SDKUtil.isValidSDKVersion((String)sdkVersion, (Version)SDKManager.getLeastValidVersion())) {
                return Status.OK_STATUS;
            }
            return ProjectCorePlugin.createErrorStatus((String)("Invalid Plugin SDK version, must be greater than " + SDKManager.getLeastValidVersion()));
        }
        if ("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS".equals(name)) {
            Object[] selectedProjects;
            Object val = this.getProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS");
            if (val instanceof Object[] && (selectedProjects = (Object[])val).length > 0) {
                return Status.OK_STATUS;
            }
            return ProjectCorePlugin.createErrorStatus((String)"Must select at least one Liferay project to import.");
        }
        if ("IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(name)) {
            Object runtime = this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            if (!(runtime instanceof BridgedRuntime)) {
                return ProjectCorePlugin.createErrorStatus((String)"A valid Liferay runtime must be selected.");
            }
            return Status.OK_STATUS;
        }
        if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(name)) {
            return Status.OK_STATUS;
        }
        return super.validate(name);
    }

    protected IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
        return (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
    }
}

