/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core.facet;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.ProjectCorePlugin;
import com.liferay.ide.eclipse.project.core.facet.IPluginProjectDataModelProperties;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.SDKManager;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public abstract class PluginFacetInstallDataModelProvider
extends FacetInstallDataModelProvider
implements IPluginProjectDataModelProperties {
    protected LibraryInstallDelegate libraryDelegate = null;

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return this.getPluginFacetId();
        }
        if (propertyName.equals("IPluginProjectDataModelProperties.LIFERAY_PLUGIN_LIBRARY_DELEGATE")) {
            if (this.libraryDelegate == null) {
                this.libraryDelegate = new LibraryInstallDelegate((IFacetedProjectBase)((IFacetedProjectWorkingCopy)this.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY")), (IProjectFacetVersion)this.getProperty("IFacetDataModelPropeties.FACET_VERSION"));
            }
            return this.libraryDelegate;
        }
        return super.getDefaultProperty(propertyName);
    }

    public Set getPropertyNames() {
        Set propNames = super.getPropertyNames();
        propNames.add("IPluginProjectDataModelProperties.LIFERAY_PLUGIN_LIBRARY_DELEGATE");
        propNames.add("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME");
        return propNames;
    }

    public void init() {
        super.init();
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IFacetDataModelPropeties.FACET_VERSION") && this.libraryDelegate != null) {
            this.libraryDelegate.setProjectFacetVersion((IProjectFacetVersion)propertyValue);
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public IStatus validate(String name) {
        if ("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME".equals(name)) {
            String sdkName = this.getStringProperty("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME");
            if (CoreUtil.isNullOrEmpty((String)sdkName)) {
                return ProjectCorePlugin.createErrorStatus((String)"No Plugin SDK configured.");
            }
            SDK sdk = SDKManager.getInstance().getSDK(sdkName);
            if (sdk == null) {
                return ProjectCorePlugin.createErrorStatus((String)("Plugin SDK (" + sdkName + ") is not defined."));
            }
            return Status.OK_STATUS;
        }
        return super.validate(name);
    }

    protected abstract String getPluginFacetId();
}

