/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core.facet;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.IPortletFramework;
import com.liferay.ide.eclipse.project.core.IProjectDefinition;
import com.liferay.ide.eclipse.project.core.ProjectCorePlugin;
import com.liferay.ide.eclipse.project.core.facet.IPluginProjectDataModelProperties;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.SDKManager;
import com.liferay.ide.eclipse.server.util.ServerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;
import org.osgi.framework.Version;

public class PluginFacetProjectCreationDataModelProvider
extends WebFacetProjectCreationDataModelProvider
implements IPluginProjectDataModelProperties {
    protected Map<String, IProjectDefinition> projectDefinitions = new HashMap<String, IProjectDefinition>();

    public PluginFacetProjectCreationDataModelProvider() {
        IProjectDefinition[] definitions;
        IProjectDefinition[] iProjectDefinitionArray = definitions = ProjectCorePlugin.getProjectDefinitions();
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectDefinition definition = iProjectDefinitionArray[n2];
            if (definition.getFacetId() != null) {
                this.projectDefinitions.put(definition.getFacetId(), definition);
            }
            ++n2;
        }
    }

    public Object getDefaultProperty(String propertyName) {
        if ("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME".equals(propertyName)) {
            SDK sdk = SDKManager.getInstance().getDefaultSDK();
            if (sdk != null) {
                return sdk.getName();
            }
            return "__NO__SDK__";
        }
        if ("IPluginProjectDataModelProperties.LIFERAY_USE_SDK_LOCATION".equals(propertyName)) {
            return true;
        }
        if ("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION".equals(propertyName)) {
            return false;
        }
        if ("IPluginProjectDataModelProperties.LIFERAY_USE_CUSTOM_LOCATION".equals(propertyName)) {
            return false;
        }
        if ("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET".equals(propertyName)) {
            return true;
        }
        if ("IPluginProjectDataModelProperties.PORTLET_NAME".equals(propertyName)) {
            return this.getProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
        }
        if ("IPluginProjectCreationPropertiesNew.DISPLAY_NAME".equals(propertyName)) {
            return ProjectUtil.convertToDisplayName(this.getStringProperty("IProjectCreationPropertiesNew.PROJECT_NAME"));
        }
        if ("IPluginProjectDataModelProperties.HOOK_NAME".equals(propertyName)) {
            return this.getProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
        }
        if ("IPluginProjectDataModelProperties.EXT_NAME".equals(propertyName)) {
            return this.getProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
        }
        if ("IPluginProjectDataModelProperties.THEME_NAME".equals(propertyName)) {
            return this.getProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
        }
        if ("IPluginProjectDataModelProperties.LAYOUTTPL_NAME".equals(propertyName)) {
            return this.getProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
        }
        if ("IPluginProjectDataModelProperties.CREATE_PROJECT_OPERATION".equals(propertyName)) {
            return true;
        }
        if ("IPluginProjectDataModelProperties.PORTLET_FRAMEWORK".equals(propertyName)) {
            return ProjectCorePlugin.getPortletFrameworks()[0];
        }
        return super.getDefaultProperty(propertyName);
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if ("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME".equals(propertyName)) {
            Object val = this.getProperty(propertyName);
            if ("__NO__SDK__".equals(val) || "".equals(val)) {
                return new DataModelPropertyDescriptor(this.getProperty(propertyName), "<None>");
            }
            return new DataModelPropertyDescriptor(val, val.toString());
        }
        return super.getPropertyDescriptor(propertyName);
    }

    public Set getPropertyNames() {
        Set propNames = super.getPropertyNames();
        propNames.add("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME");
        propNames.add("IPluginProjectDataModelProperties.LIFERAY_USE_SDK_LOCATION");
        propNames.add("IPluginProjectDataModelProperties.LIFERAY_USE_CUSTOM_LOCATION");
        propNames.add("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET");
        propNames.add("IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK");
        propNames.add("IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT");
        propNames.add("IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME");
        propNames.add("IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL");
        propNames.add("IPluginProjectCreationPropertiesNew.DISPLAY_NAME");
        propNames.add("IPluginProjectDataModelProperties.PORTLET_NAME");
        propNames.add("IPluginProjectDataModelProperties.HOOK_NAME");
        propNames.add("IPluginProjectDataModelProperties.EXT_NAME");
        propNames.add("IPluginProjectDataModelProperties.THEME_NAME");
        propNames.add("IPluginProjectDataModelProperties.LAYOUTTPL_NAME");
        propNames.add("IPluginProjectDataModelProperties.CREATE_PROJECT_OPERATION");
        propNames.add("IPluginProjectDataModelProperties.PLUGIN_FRAGMENT_ENABLED");
        propNames.add("IPluginProjectDataModelProperties.PLUGIN_FRAGMENT_DM");
        propNames.add("IPluginProjectDataModelProperties.PORTLET_FRAMEWORK");
        return propNames;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if ("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME".equals(propertyName)) {
            SDK[] validSDKs = SDKManager.getInstance().getSDKs();
            Object[] values = null;
            String[] descriptions = null;
            if (validSDKs.length == 0) {
                values = new String[]{"__NO__SDK__"};
                descriptions = new String[]{"<None>"};
            } else {
                values = new String[validSDKs.length];
                descriptions = new String[validSDKs.length];
                int i = 0;
                while (i < validSDKs.length) {
                    values[i] = validSDKs[i].getName();
                    descriptions[i] = validSDKs[i].getName();
                    ++i;
                }
            }
            return DataModelPropertyDescriptor.createDescriptors((Object[])values, (String[])descriptions);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public void init() {
        DataModelPropertyDescriptor[] validDescriptors;
        super.init();
        this.getDataModel().setProperty("IPluginProjectDataModelProperties.LIFERAY_USE_SDK_LOCATION", (Object)true);
        DataModelPropertyDescriptor[] dataModelPropertyDescriptorArray = validDescriptors = this.getDataModel().getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        int n = validDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            DataModelPropertyDescriptor desc = dataModelPropertyDescriptorArray[n2];
            Object runtime = desc.getPropertyValue();
            if (runtime instanceof BridgedRuntime && ServerUtil.isLiferayRuntime((BridgedRuntime)((BridgedRuntime)runtime))) {
                this.getDataModel().setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", runtime);
                break;
            }
            ++n2;
        }
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName) || "IPluginProjectDataModelProperties.LIFERAY_SDK_NAME".equals(propertyName)) {
            this.updateProjectLocation();
        } else if ("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET".equals(propertyName) && this.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET")) {
            this.setupProject("liferay.portlet");
        } else if ("IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK".equals(propertyName) && this.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK")) {
            this.setupProject("liferay.hook");
        } else if ("IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT".equals(propertyName) && this.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT")) {
            this.setupProject("liferay.ext");
        } else if ("IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME".equals(propertyName) && this.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME")) {
            this.setupProject("liferay.theme");
        } else if ("IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL".equals(propertyName) && this.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL")) {
            this.setupProject("liferay.layouttpl");
        } else {
            if ("IPluginProjectCreationPropertiesNew.DISPLAY_NAME".equals(propertyName)) {
                String displayName = ProjectUtil.removePluginSuffix(propertyValue.toString());
                return super.propertySet("IPluginProjectCreationPropertiesNew.DISPLAY_NAME", (Object)displayName);
            }
            if ("IPluginProjectDataModelProperties.PORTLET_FRAMEWORK".equals(propertyName)) {
                IPortletFramework portletFramework = (IPortletFramework)this.getProperty("IPluginProjectDataModelProperties.PORTLET_FRAMEWORK");
                this.setupPortletFramework(portletFramework);
            }
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public IStatus validate(String propertyName) {
        if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName)) {
            String projectName = this.getNestedModel().getStringProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
            if (CoreUtil.isNullOrEmpty((String)projectName)) {
                return super.validate(propertyName);
            }
            String testProjectName = String.valueOf(projectName) + this.getProjectSuffix();
            if (ProjectUtil.getProject(testProjectName).exists()) {
                return ProjectCorePlugin.createErrorStatus((String)"A project already exists with that name.");
            }
            String nameValidation = testProjectName.replaceAll("-", "");
            IStatus status = JavaConventions.validateIdentifier((String)nameValidation, (String)"1.5", (String)"1.5");
            if (!status.isOK()) {
                return ProjectCorePlugin.createErrorStatus((String)"Project name is invalid.");
            }
        } else if ("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME".equals(propertyName)) {
            Object sdkVal = this.getModel().getProperty("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME");
            if (sdkVal instanceof String && "__NO__SDK__".equals(sdkVal)) {
                return ProjectCorePlugin.createErrorStatus((String)"Plugin SDK must be configured.");
            }
            if (!CoreUtil.isNullOrEmpty((String)sdkVal.toString())) {
                SDK sdk = SDKManager.getInstance().getSDK(sdkVal.toString());
                if (sdk == null || !sdk.isValid()) {
                    return ProjectCorePlugin.createErrorStatus((String)"Plugin SDK is invalid.");
                }
                return Status.OK_STATUS;
            }
        } else if ("IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(propertyName)) {
            IStatus status = this.validate("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME");
            if (!status.isOK()) {
                return status;
            }
            Object facetRuntime = this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            if (facetRuntime == null) {
                return ProjectCorePlugin.createErrorStatus((String)"Liferay Portal runtime must be configured and selected.");
            }
            if (facetRuntime instanceof BridgedRuntime) {
                if (ServerUtil.isLiferayRuntime((BridgedRuntime)((BridgedRuntime)facetRuntime))) {
                    return Status.OK_STATUS;
                }
                return ProjectCorePlugin.createErrorStatus((String)"Must select a Liferay Portal runtime.");
            }
        } else {
            if ("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET".equals(propertyName) || "IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK".equals(propertyName) || "IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT".equals(propertyName) || "IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME".equals(propertyName) || "IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL".equals(propertyName)) {
                return this.validate("IFacetDataModelProperties.FACET_PROJECT_NAME");
            }
            if ("IPluginProjectDataModelProperties.PORTLET_FRAMEWORK".equals(propertyName) && this.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET")) {
                IPortletFramework framework;
                Version requiredSDKVersion;
                String sdkName = this.getStringProperty("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME");
                SDK selectedSDK = SDKManager.getInstance().getSDK(sdkName);
                if (selectedSDK == null) {
                    return ProjectCorePlugin.createErrorStatus((String)("Unable to determine SDK version for " + sdkName));
                }
                Version sdkVersion = new Version(selectedSDK.getVersion());
                if (sdkVersion.compareTo((Object)(requiredSDKVersion = new Version((framework = (IPortletFramework)this.getProperty("IPluginProjectDataModelProperties.PORTLET_FRAMEWORK")).getRequiredSDKVersion()))) < 0) {
                    return ProjectCorePlugin.createErrorStatus((String)("At least SDK version " + requiredSDKVersion + " is required to use the selected portlet framework."));
                }
                return Status.OK_STATUS;
            }
        }
        return super.validate(propertyName);
    }

    protected IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
        return (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
    }

    protected IDataModel getModel() {
        return this.model;
    }

    protected IDataModel getNestedModel() {
        return this.getDataModel().getNestedModel("IFacetProjectCreationDataModelProperties.NESTED_PROJECT_DM");
    }

    protected String getProjectLocation() {
        IPath sdkLoc = this.getSDKLocation();
        if (sdkLoc == null) {
            return null;
        }
        if (this.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET")) {
            return sdkLoc.append("portlets").toOSString();
        }
        if (this.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK")) {
            return sdkLoc.append("hooks").toOSString();
        }
        if (this.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT")) {
            return sdkLoc.append("ext").toOSString();
        }
        if (this.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME")) {
            return sdkLoc.append("themes").toOSString();
        }
        if (this.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL")) {
            return sdkLoc.append("layouttpl").toOSString();
        }
        return null;
    }

    protected String getProjectSuffix() {
        if (this.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET")) {
            return "-portlet";
        }
        if (this.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK")) {
            return "-hook";
        }
        if (this.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT")) {
            return "-ext";
        }
        if (this.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME")) {
            return "-theme";
        }
        if (this.getBooleanProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL")) {
            return "-layouttpl";
        }
        return null;
    }

    protected IPath getSDKLocation() {
        SDK sdk = SDKManager.getInstance().getSDK((String)this.getProperty("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME"));
        return sdk != null ? sdk.getLocation() : null;
    }

    protected void removeFacet(IFacetedProjectWorkingCopy facetedProject, IProjectFacet facet) {
        if (facetedProject == null || facet == null) {
            return;
        }
        HashSet<IProjectFacetVersion> newFacetSet = new HashSet<IProjectFacetVersion>();
        Set facets = facetedProject.getProjectFacets();
        for (IProjectFacetVersion fv : facets) {
            if (fv.getProjectFacet().equals(facet)) continue;
            newFacetSet.add(fv);
        }
        facetedProject.setProjectFacets(newFacetSet);
    }

    protected void setupPortletFramework(IPortletFramework portletFramework) {
        IPortletFramework[] portletFrameworks;
        IPortletFramework[] iPortletFrameworkArray = portletFrameworks = ProjectCorePlugin.getPortletFrameworks();
        int n = portletFrameworks.length;
        int n2 = 0;
        while (n2 < n) {
            IPortletFramework framework = iPortletFrameworkArray[n2];
            if (!framework.equals(portletFramework)) {
                IProjectFacet[] facets;
                IProjectFacet[] iProjectFacetArray = facets = framework.getFacets();
                int n3 = facets.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProjectFacet facet = iProjectFacetArray[n4];
                    this.removeFacet(this.getFacetedProjectWorkingCopy(), facet);
                    ++n4;
                }
            }
            ++n2;
        }
        portletFramework.configureNewProject(this.getDataModel(), this.getFacetedProjectWorkingCopy());
    }

    protected void setupProject(String facetId) {
        this.updateProjectLocation();
        IProjectDefinition projectDefinition = this.projectDefinitions.get(facetId);
        if (projectDefinition != null) {
            IFacetedProjectWorkingCopy facetedProject = this.getFacetedProjectWorkingCopy();
            for (IProjectDefinition def : this.projectDefinitions.values()) {
                this.removeFacet(facetedProject, def.getFacet());
            }
            IFacetedProjectTemplate template = projectDefinition.getFacetedProjectTemplate();
            if (template != null) {
                facetedProject.setFixedProjectFacets(Collections.unmodifiableSet(template.getFixedProjectFacets()));
            }
            projectDefinition.setupNewProject(this.getDataModel(), facetedProject);
        }
    }

    protected void updateProjectLocation() {
        String projectLocation = this.getProjectLocation();
        if (projectLocation == null) {
            this.getNestedModel().setProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION", (Object)true);
        } else {
            this.getNestedModel().setProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION", (Object)false);
            this.getNestedModel().setProperty("IProjectCreationPropertiesNew.USER_DEFINED_BASE_LOCATION", (Object)projectLocation);
        }
    }
}

