/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core.facet;

import com.liferay.ide.eclipse.project.core.ProjectCorePlugin;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.sdk.SDK;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectValidator;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

public abstract class PluginFacetValidator
implements IFacetedProjectValidator {
    public static final String MARKER_ID = "com.liferay.ide.eclipse.project.core.facet.validator";
    public static final String PREFERENCE_NODE_QUALIFIER = ProjectCorePlugin.getDefault().getBundle().getSymbolicName();
    protected IPreferencesService fPreferencesService = Platform.getPreferencesService();

    public void validate(IFacetedProject fproj) throws CoreException {
        IStatus status;
        if (fproj == null) {
            return;
        }
        IScopeContext[] scopes = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        ProjectScope projectScope = new ProjectScope(fproj.getProject());
        boolean useProjectSettings = projectScope.getNode(PREFERENCE_NODE_QUALIFIER).getBoolean("use-project-settings", false);
        if (useProjectSettings) {
            scopes = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
        }
        SDK projectSDK = null;
        try {
            projectSDK = ProjectUtil.getSDK(fproj, this.getProjectFacet());
        }
        catch (Exception e) {
            ProjectCorePlugin.logError((Throwable)e);
        }
        if (projectSDK == null) {
            Integer severity = this.getMessageSeverity(PREFERENCE_NODE_QUALIFIER, scopes, "validation-sdk-not-valid");
            if (severity == null) {
                return;
            }
            String msg = "No Liferay Plugin SDK configured on project " + fproj.getProject().getName();
            if (((Object)severity).equals(2)) {
                fproj.createErrorMarker(msg);
            } else if (((Object)severity).equals(1)) {
                fproj.createWarningMarker(msg);
            }
            return;
        }
        if (projectSDK != null && !(status = projectSDK.validate()).isOK()) {
            fproj.createErrorMarker("com.liferay.ide.eclipse.project.core.facet.validator.sdkError", "Configured Liferay Plugin SDK is invalid: " + status.getMessage());
        }
    }

    protected Integer getMessageSeverity(String qualifier, IScopeContext[] preferenceScopes, String key) {
        int sev = this.fPreferencesService.getInt(qualifier, key, 2, preferenceScopes);
        switch (sev) {
            case 1: {
                return new Integer(2);
            }
            case 2: {
                return new Integer(1);
            }
            case 3: {
                return new Integer(0);
            }
            case -1: {
                return null;
            }
        }
        return new Integer(1);
    }

    protected abstract IProjectFacet getProjectFacet();
}

