/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core.util;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.IProjectDefinition;
import com.liferay.ide.eclipse.project.core.ProjectCorePlugin;
import com.liferay.ide.eclipse.project.core.ProjectRecord;
import com.liferay.ide.eclipse.project.core.facet.IPluginFacetConstants;
import com.liferay.ide.eclipse.project.core.facet.PluginFacetProjectCreationDataModelProvider;
import com.liferay.ide.eclipse.project.core.util.PluginFacetUtil;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.SDKManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.util.internal.FileUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUtil {
    public static final String METADATA_FOLDER = ".metadata";

    public static boolean collectProjectsFromDirectory(Collection<File> eclipseProjectFiles, Collection<File> liferayProjectDirs, File directory, Set<String> directoriesVisited, boolean recurse, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)directory.getPath()));
        File[] contents = directory.listFiles();
        if (contents == null) {
            return false;
        }
        if (directoriesVisited == null) {
            directoriesVisited = new HashSet<String>();
            try {
                directoriesVisited.add(directory.getCanonicalPath());
            }
            catch (IOException exception) {
                StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)exception.getLocalizedMessage(), (Throwable)exception));
            }
        }
        int i = 0;
        while (i < contents.length) {
            File file = contents[i];
            if (ProjectUtil.isLiferayProjectDir(file)) {
                int currentSize = eclipseProjectFiles.size();
                ProjectUtil.collectProjectsFromDirectory(eclipseProjectFiles, liferayProjectDirs, contents[i], directoriesVisited, false, monitor);
                int newSize = eclipseProjectFiles.size();
                if (newSize == currentSize) {
                    liferayProjectDirs.add(file);
                }
            } else if (file.isFile() && file.getName().equals(".project") && !eclipseProjectFiles.contains(file) && ProjectUtil.isLiferayProjectDir(file.getParentFile())) {
                eclipseProjectFiles.add(file);
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < contents.length) {
            block16: {
                if (contents[i].isDirectory() && !contents[i].getName().equals(METADATA_FOLDER)) {
                    block15: {
                        try {
                            String canonicalPath = contents[i].getCanonicalPath();
                            if (directoriesVisited.add(canonicalPath)) break block15;
                            break block16;
                        }
                        catch (IOException exception) {
                            StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)exception.getLocalizedMessage(), (Throwable)exception));
                        }
                    }
                    if (!liferayProjectDirs.contains(contents[i]) && recurse) {
                        ProjectUtil.collectProjectsFromDirectory(eclipseProjectFiles, liferayProjectDirs, contents[i], directoriesVisited, recurse, monitor);
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public static String convertToDisplayName(String name) {
        if (CoreUtil.isNullOrEmpty((String)name)) {
            return "";
        }
        String displayName = ProjectUtil.removePluginSuffix(name);
        displayName = displayName.replaceAll("-", " ").replaceAll("_", " ");
        displayName = WordUtils.capitalize((String)displayName);
        return displayName;
    }

    public static void createDefaultWebXml(File webxmlFile) {
        try {
            FileUtil.writeFile((File)webxmlFile, (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\">\n<web-app>\n</web-app>");
        }
        catch (Exception e) {
            ProjectCorePlugin.logError("Unable to create default web xml", e);
        }
    }

    public static IFile createEmptyProjectFile(String fileName, IFolder folder) throws CoreException {
        IFile emptyFile = folder.getFile(fileName);
        if (emptyFile.exists()) {
            return emptyFile;
        }
        emptyFile.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        return emptyFile;
    }

    public static IProject createExistingProject(ProjectRecord record, IRuntime runtime, String sdkLocation, IProgressMonitor monitor) throws CoreException {
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (record.description == null) {
            record.description = workspace.newProjectDescription(projectName);
            Path locationPath = new Path(record.projectSystemFile.getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                record.description.setLocation(null);
            } else {
                record.description.setLocation((IPath)locationPath);
            }
        } else {
            record.description.setName(projectName);
        }
        monitor.beginTask("Importing project", 100);
        project.create(record.description, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
        project.open(1, (IProgressMonitor)new SubProgressMonitor(monitor, 70));
        if (project.getName().endsWith("-ext")) {
            ProjectUtil.fixExtProjectClasspathEntries(project);
        }
        IFacetedProject fProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        FacetedProjectWorkingCopy fpwc = new FacetedProjectWorkingCopy(fProject);
        PluginFacetUtil.configureProjectAsPlugin((IFacetedProjectWorkingCopy)fpwc, runtime, sdkLocation);
        fpwc.commitChanges(monitor);
        final IJavaProject javaProject = JavaCore.create((IProject)fProject.getProject());
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 5 && entry.getPath().segment(0).equals("com.liferay.ide.eclipse.server.plugin.container")) {
                        JavaCore.getClasspathContainerInitializer((String)"com.liferay.ide.eclipse.server.plugin.container").initialize(entry.getPath(), javaProject);
                        break;
                    }
                    ++n2;
                }
                monitor.done();
            }
        }, monitor);
        return project;
    }

    public static IProject createNewProject(ProjectRecord projectRecord, IRuntime runtime, String sdkLocation, IProgressMonitor monitor) throws CoreException {
        IDataModel newProjectDataModel = DataModelFactory.createDataModel((IDataModelProvider)new PluginFacetProjectCreationDataModelProvider());
        newProjectDataModel.setBooleanProperty("IPluginProjectDataModelProperties.CREATE_PROJECT_OPERATION", false);
        String sdkName = PluginFacetUtil.getSDKName(sdkLocation);
        newProjectDataModel.setProperty("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME", (Object)sdkName);
        ProjectUtil.setGenerateDD(newProjectDataModel, false);
        IPath webXmlPath = projectRecord.getProjectLocation().append("docroot/WEB-INF/web.xml");
        if (projectRecord.getProjectName().endsWith("-portlet")) {
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET", (Object)true);
            if (!webXmlPath.toFile().exists()) {
                ProjectUtil.createDefaultWebXml(webXmlPath.toFile());
            }
        } else if (projectRecord.getProjectName().endsWith("-hook")) {
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK", (Object)true);
            if (!webXmlPath.toFile().exists()) {
                ProjectUtil.createDefaultWebXml(webXmlPath.toFile());
            }
        } else if (projectRecord.getProjectName().endsWith("-ext")) {
            webXmlPath = webXmlPath.removeLastSegments(3).append((IPath)new Path("docroot/WEB-INF/ext-web/docroot/WEB-INF/web.xml"));
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT", (Object)true);
            if (!webXmlPath.toFile().exists()) {
                ProjectUtil.createDefaultWebXml(webXmlPath.toFile());
            }
        } else if (projectRecord.getProjectName().endsWith("-layouttpl")) {
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL", (Object)true);
        } else if (projectRecord.getProjectName().endsWith("-theme")) {
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME", (Object)true);
        }
        IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)newProjectDataModel.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        fpjwc.setProjectName(projectRecord.getProjectName());
        fpjwc.setProjectLocation(projectRecord.getProjectLocation());
        PluginFacetUtil.configureProjectAsPlugin(fpjwc, runtime, sdkLocation);
        fpjwc.commitChanges(monitor);
        return fpjwc.getProject();
    }

    public static IFile findServiceJarForContext(String context) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IFile serviceJar;
            IFolder docroot;
            IProject project = iProjectArray[n2];
            if (project.getName().equals(context) && (docroot = ProjectUtil.getDocroot(project)) != null && docroot.exists() && (serviceJar = docroot.getFile("WEB-INF/lib/" + project.getName() + "-service.jar")).exists()) {
                return serviceJar;
            }
            ++n2;
        }
        return null;
    }

    public static void fixExtProjectSrcFolderLinks(IProject extProject) throws JavaModelException {
        IVirtualFolder jsrc;
        IVirtualComponent c;
        IJavaProject javaProject;
        if (extProject != null && (javaProject = JavaCore.create((IProject)extProject)) != null && (c = ComponentCore.createComponent((IProject)extProject, (boolean)false)) != null && (jsrc = c.getRootFolder().getFolder("/WEB-INF/classes")) != null) {
            IClasspathEntry[] cp = javaProject.getRawClasspath();
            int i = 0;
            while (i < cp.length) {
                IClasspathEntry cpe = cp[i];
                if (cpe.getEntryKind() == 3 && cpe.getPath().removeFirstSegments(1).segmentCount() > 0) {
                    try {
                        IFolder srcFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(cpe.getPath());
                        IVirtualResource[] virtualResource = ComponentCore.createResources((IResource)srcFolder);
                        if (virtualResource.length == 0) {
                            jsrc.createLink(cpe.getPath().removeFirstSegments(1), 0, null);
                        }
                    }
                    catch (Exception e) {
                        ProjectCorePlugin.logError((Throwable)e);
                    }
                }
                ++i;
            }
        }
    }

    public static IFolder getDocroot(IProject project) {
        IVirtualFolder rootFolder;
        IVirtualComponent comp;
        IContainer retval = null;
        if (project != null && (comp = ComponentCore.createComponent((IProject)project)) != null && (rootFolder = comp.getRootFolder()) != null) {
            retval = rootFolder.getUnderlyingFolder();
        }
        return retval instanceof IFolder ? (IFolder)retval : null;
    }

    public static IFolder getDocroot(String projectName) {
        IProject project = CoreUtil.getProject((String)projectName);
        return ProjectUtil.getDocroot(project);
    }

    public static IFacetedProject getFacetedProject(IProject project) {
        try {
            return ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static Set<IProjectFacetVersion> getFacetsForPreset(String presetId) {
        IPreset preset = ProjectFacetsManager.getPreset((String)presetId);
        return preset.getProjectFacets();
    }

    public static IProjectFacet getLiferayFacet(IFacetedProject facetedProject) {
        for (IProjectFacetVersion projectFacet : facetedProject.getProjectFacets()) {
            if (!ProjectUtil.isLiferayFacet(projectFacet.getProjectFacet())) continue;
            return projectFacet.getProjectFacet();
        }
        return null;
    }

    public static String getLiferayPluginType(String projectLocation) {
        if (ProjectUtil.isLiferayProjectDir(new File(projectLocation))) {
            String suffix = "";
            if (projectLocation.endsWith("-portlet")) {
                suffix = "-portlet";
            } else if (projectLocation.endsWith("-hook")) {
                suffix = "-hook";
            } else if (projectLocation.endsWith("-ext")) {
                suffix = "-ext";
            } else if (projectLocation.endsWith("-layouttpl")) {
                suffix = "-layouttpl";
            } else if (projectLocation.endsWith("-theme")) {
                suffix = "-theme";
            }
            return suffix.replace("-", "");
        }
        return null;
    }

    public static IProject getProject(IDataModel model) {
        if (model != null) {
            String projectName = model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
            return CoreUtil.getProject((String)projectName);
        }
        return null;
    }

    public static IProject getProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static ProjectRecord getProjectRecordForDir(String dir) {
        ProjectRecord projectRecord = null;
        File projectDir = new File(dir);
        if (ProjectUtil.isLiferayProjectDir(projectDir)) {
            String[] files;
            String[] stringArray = files = projectDir.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (".project".equals(file)) {
                    projectRecord = new ProjectRecord(new File(projectDir, file));
                }
                ++n2;
            }
            if (projectRecord == null) {
                projectRecord = new ProjectRecord(projectDir);
            }
        }
        return projectRecord;
    }

    public static String getRelativePathFromDocroot(IProject project, String path) {
        Path pathValue = new Path(path);
        IFolder docroot = ProjectUtil.getDocroot(project);
        IPath relativePath = pathValue.makeRelativeTo(docroot.getFullPath());
        String retval = relativePath.toPortableString();
        return retval.startsWith("/") ? retval : "/" + retval;
    }

    public static SDK getSDK(IFacetedProject facetedProject, IProjectFacet facet) throws BackingStoreException {
        Preferences prefs = facetedProject.getPreferences(facet).node("liferay-plugin-project");
        String name = prefs.get("sdk-name", null);
        return SDKManager.getInstance().getSDK(name);
    }

    public static SDK getSDK(IProject project) {
        IProjectFacet liferayFacet;
        IFacetedProject facetedProject;
        SDK retval = null;
        if (ProjectUtil.isLiferayProject(project) && (facetedProject = ProjectUtil.getFacetedProject(project)) != null && (liferayFacet = ProjectUtil.getLiferayFacet(facetedProject)) != null) {
            try {
                retval = ProjectUtil.getSDK(facetedProject, liferayFacet);
            }
            catch (BackingStoreException backingStoreException) {}
        }
        return retval;
    }

    public static SDK getSDK(IProject proj, IProjectFacet projectFacet) {
        IFacetedProject facetedProject = ProjectUtil.getFacetedProject(proj);
        SDK sdk = null;
        try {
            sdk = ProjectUtil.getSDK(facetedProject, projectFacet);
        }
        catch (BackingStoreException e) {
            ProjectCorePlugin.logError("Could not get SDK.", (Exception)((Object)e));
        }
        return sdk;
    }

    public static IPackageFragmentRoot[] getSourceContainers(IProject project) {
        IJavaProject jProject = JavaCore.create((IProject)project);
        if (jProject == null) {
            return new IPackageFragmentRoot[0];
        }
        ArrayList<IPackageFragmentRoot> list = new ArrayList<IPackageFragmentRoot>();
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        try {
            IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IResource resource;
                if (roots[i].getKind() == 1 && (resource = roots[i].getResource()) != null) {
                    IVirtualResource[] vResources = ComponentCore.createResources((IResource)resource);
                    boolean found = false;
                    int j = 0;
                    while (!found && j < vResources.length) {
                        if (vResources[j].getComponent().equals(vc)) {
                            if (!list.contains(roots[i])) {
                                list.add(roots[i]);
                            }
                            found = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            ProjectCorePlugin.logError((Throwable)e);
        }
        return list.toArray(new IPackageFragmentRoot[list.size()]);
    }

    public static IFolder[] getSourceFolders(IProject project) {
        IPackageFragmentRoot[] sources;
        ArrayList<IFolder> sourceFolders = new ArrayList<IFolder>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = sources = ProjectUtil.getSourceContainers(project);
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot source = iPackageFragmentRootArray[n2];
            if (source.getResource() instanceof IFolder) {
                sourceFolders.add((IFolder)source.getResource());
            }
            ++n2;
        }
        return sourceFolders.toArray(new IFolder[sourceFolders.size()]);
    }

    public static boolean hasFacet(IProject project, IProjectFacet checkProjectFacet) {
        boolean retval;
        block4: {
            retval = false;
            if (project == null || checkProjectFacet == null) {
                return retval;
            }
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject == null || checkProjectFacet == null) break block4;
                for (IProjectFacetVersion facet : facetedProject.getProjectFacets()) {
                    IProjectFacet projectFacet = facet.getProjectFacet();
                    if (!checkProjectFacet.equals(projectFacet)) continue;
                    retval = true;
                    break;
                }
            }
            catch (CoreException coreException) {}
        }
        return retval;
    }

    public static boolean hasFacet(IProject project, String facetId) {
        return ProjectUtil.hasFacet(project, ProjectFacetsManager.getProjectFacet((String)facetId));
    }

    public static boolean hasProperty(IDataModel model, String propertyName) {
        boolean retval = false;
        if (model == null || CoreUtil.isNullOrEmpty((String)propertyName)) {
            return retval;
        }
        for (Object property : model.getAllProperties()) {
            if (!propertyName.equals(property)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    public static IProject importProject(ProjectRecord projectRecord, IRuntime runtime, String sdkLocation, IProgressMonitor monitor) throws CoreException {
        IProject project = null;
        if (projectRecord.projectSystemFile != null) {
            try {
                project = ProjectUtil.createExistingProject(projectRecord, runtime, sdkLocation, monitor);
            }
            catch (CoreException e) {
                throw new CoreException(ProjectCorePlugin.createErrorStatus((Exception)((Object)e)));
            }
        }
        if (projectRecord.liferayProjectDir != null) {
            try {
                project = ProjectUtil.createNewProject(projectRecord, runtime, sdkLocation, monitor);
            }
            catch (CoreException e) {
                throw new CoreException(ProjectCorePlugin.createErrorStatus((Exception)((Object)e)));
            }
        }
        return project;
    }

    public static boolean isDynamicWebFacet(IProjectFacet facet) {
        return facet != null && facet.getId().equals("jst.web");
    }

    public static boolean isDynamicWebFacet(IProjectFacetVersion facetVersion) {
        return facetVersion != null && ProjectUtil.isDynamicWebFacet(facetVersion.getProjectFacet());
    }

    public static boolean isExtProject(IProject project) {
        return ProjectUtil.hasFacet(project, IPluginFacetConstants.LIFERAY_EXT_PROJECT_FACET);
    }

    public static boolean isHookProject(IProject project) {
        return ProjectUtil.hasFacet(project, IPluginFacetConstants.LIFERAY_HOOK_PROJECT_FACET);
    }

    public static boolean isJavaFacet(IProjectFacet facet) {
        return facet != null && (facet.getId().equals("java") || facet.getId().equals("jst.java"));
    }

    public static boolean isJavaFacet(IProjectFacetVersion facetVersion) {
        return facetVersion != null && ProjectUtil.isJavaFacet(facetVersion.getProjectFacet());
    }

    public static boolean isLayoutTplProject(IProject project) {
        return ProjectUtil.hasFacet(project, "liferay.layouttpl");
    }

    public static boolean isLiferayFacet(IProjectFacet projectFacet) {
        return ProjectCorePlugin.getProjectDefinition(projectFacet) != null;
    }

    public static boolean isLiferayFacet(IProjectFacetVersion projectFacetVersion) {
        return projectFacetVersion != null && ProjectCorePlugin.getProjectDefinition(projectFacetVersion.getProjectFacet()) != null;
    }

    public static boolean isLiferayPluginType(String type) {
        return type != null && ("-portlet".endsWith(type) || "-hook".endsWith(type) || "-ext".endsWith(type) || "-layouttpl".endsWith(type) || "-theme".endsWith(type));
    }

    public static boolean isLiferayProject(IProject project) {
        boolean retval;
        block4: {
            retval = false;
            if (project == null) {
                return retval;
            }
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject == null) break block4;
                for (IProjectFacetVersion facet : facetedProject.getProjectFacets()) {
                    IProjectFacet projectFacet = facet.getProjectFacet();
                    IProjectDefinition projectDefinition = ProjectCorePlugin.getProjectDefinition(projectFacet);
                    if (projectDefinition == null) continue;
                    retval = true;
                    break;
                }
            }
            catch (Exception exception) {}
        }
        return retval;
    }

    public static boolean isLiferayProjectDir(File file) {
        if (file.isDirectory() && ProjectUtil.isValidLiferayProjectDir(file)) {
            File[] contents = file.listFiles();
            boolean hasBuildXml = false;
            boolean hasDocroot = false;
            File[] fileArray = contents;
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                File content = fileArray[n2];
                if (content.getName().equals("build.xml")) {
                    hasBuildXml = true;
                } else if (content.getName().equals("docroot")) {
                    hasDocroot = true;
                }
                ++n2;
            }
            if (hasBuildXml && hasDocroot) {
                return true;
            }
        }
        return false;
    }

    public static boolean isParent(IFolder folder, IResource resource) {
        if (folder == null || resource == null) {
            return false;
        }
        if (resource.getParent() != null && resource.getParent().equals((Object)folder)) {
            return true;
        }
        boolean retval = ProjectUtil.isParent(folder, (IResource)resource.getParent());
        return retval;
    }

    public static boolean isPortletProject(IProject project) {
        return ProjectUtil.hasFacet(project, IPluginFacetConstants.LIFERAY_PORTLET_PROJECT_FACET);
    }

    public static boolean isThemeProject(IProject project) {
        return ProjectUtil.hasFacet(project, "liferay.theme");
    }

    public static boolean isValidLiferayProjectDir(File dir) {
        String name = dir.getName();
        return name.endsWith("-portlet") || name.endsWith("-ext") || name.endsWith("-hook") || name.endsWith("-theme") || name.endsWith("-layouttpl");
    }

    public static String removePluginSuffix(String string) {
        if (string == null) {
            return null;
        }
        String regex = null;
        if (string.endsWith("-portlet")) {
            regex = "-portlet$";
        } else if (string.endsWith("-hook")) {
            regex = "-hook$";
        } else if (string.endsWith("-ext")) {
            regex = "-ext$";
        } else if (string.endsWith("-layouttpl")) {
            regex = "-layouttpl$";
        } else if (string.endsWith("-theme")) {
            regex = "-theme$";
        } else {
            return string;
        }
        return string.replaceFirst(regex, "");
    }

    public static void setGenerateDD(IDataModel model, boolean generateDD) {
        IDataModel ddModel = null;
        if (ProjectUtil.hasProperty(model, "IJ2EEFacetInstallDataModelProperties.GENERATE_DD")) {
            ddModel = model;
        } else if (ProjectUtil.hasProperty(model, "IFacetProjectCreationDataModelProperties.FACET_DM_MAP")) {
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            ddModel = map.getFacetDataModel(IJ2EEFacetConstants.DYNAMIC_WEB_FACET.getId());
        }
        if (ddModel != null) {
            ddModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", generateDD);
        }
    }

    public static void setSDK(IProject project, IProjectFacet facet, SDK sdk) throws BackingStoreException, CoreException {
        Preferences prefs = ProjectFacetsManager.create((IProject)project).getPreferences(facet).node("liferay-plugin-project");
        prefs.put("sdk-name", sdk.getName());
        prefs.flush();
    }

    private static void fixExtProjectClasspathEntries(IProject project) {
        try {
            IClasspathEntry[] entries;
            boolean fixedAttr = false;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                IClasspathEntry newEntry = null;
                if (entry.getEntryKind() == 3) {
                    ArrayList<Object> newAttrs = new ArrayList<Object>();
                    Object[] attrs = entry.getExtraAttributes();
                    if (!CoreUtil.isNullOrEmpty((Object[])attrs)) {
                        Object[] objectArray = attrs;
                        int n3 = attrs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object attr = objectArray[n4];
                            Object newAttr = null;
                            if ("owner.project.facets".equals(attr.getName()) && "liferay.plugin".equals(attr.getValue())) {
                                newAttr = JavaCore.newClasspathAttribute((String)attr.getName(), (String)"liferay.ext");
                                fixedAttr = true;
                            } else {
                                newAttr = attr;
                            }
                            newAttrs.add(newAttr);
                            ++n4;
                        }
                        newEntry = JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])entry.getInclusionPatterns(), (IPath[])entry.getExclusionPatterns(), (IPath)entry.getOutputLocation(), (IClasspathAttribute[])newAttrs.toArray(new IClasspathAttribute[0]));
                    }
                }
                if (newEntry == null) {
                    newEntry = entry;
                }
                newEntries.add(newEntry);
                ++n2;
            }
            if (fixedAttr) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[0]), (IProgressMonitor)monitor);
                javaProject.getProject().refreshLocal(2, (IProgressMonitor)monitor);
            }
            ProjectUtil.fixExtProjectSrcFolderLinks(project);
        }
        catch (Exception ex) {
            ProjectCorePlugin.logError("Exception trying to fix Ext project classpath entries.", ex);
        }
    }
}

