/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.project.core.util;

import com.liferay.ide.eclipse.core.util.DescriptorHelper;
import com.liferay.ide.eclipse.core.util.NodeUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.jsp.JSPConfig;
import org.eclipse.jst.j2ee.jsp.JspFactory;
import org.eclipse.jst.j2ee.jsp.TagLibRefType;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebXMLDescriptorHelper
extends DescriptorHelper {
    public WebXMLDescriptorHelper(IProject project) {
        super(project);
        this.setDescriptorPath("web.xml");
    }

    public IStatus addTagLib(final TagLibRefType tagLibRefType) {
        IFile file = this.getDescriptorFile(this.getDescriptorPath());
        IStatus status = null;
        if (file != null && file.exists()) {
            status = new DescriptorHelper.DOMModelEditOperation(this, file){

                protected IStatus doExecute(IDOMDocument document) {
                    return WebXMLDescriptorHelper.this.doAddTagLib(document, tagLibRefType);
                }
            }.execute();
        } else {
            WebArtifactEdit webArtifactEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)this.project);
            webArtifactEdit.getJ2EEVersion();
            WebApp webApp = webArtifactEdit.getWebApp();
            if (this.tagLibReferenceExists(webApp, tagLibRefType)) {
                return Status.OK_STATUS;
            }
            JSPConfig jspConfig = webApp.getJspConfig();
            if (jspConfig == null && webApp.getVersionID() != 23) {
                jspConfig = JspFactory.eINSTANCE.createJSPConfig();
            }
            if (jspConfig != null) {
                jspConfig.getTagLibs().add((Object)tagLibRefType);
            } else {
                EList tagLibs = webApp.getTagLibs();
                tagLibs.add((Object)tagLibRefType);
            }
            if (jspConfig != null) {
                webApp.setJspConfig(jspConfig);
            }
            webArtifactEdit.save(null);
            webArtifactEdit.dispose();
            status = Status.OK_STATUS;
        }
        if (!status.isOK()) {
            return status;
        }
        return status;
    }

    protected IStatus doAddTagLib(IDOMDocument document, TagLibRefType tagLibRefType) {
        if (this.tagLibReferenceExists(document, tagLibRefType)) {
            return Status.OK_STATUS;
        }
        String typeId = document.getDocumentTypeId();
        Element docRoot = document.getDocumentElement();
        if (typeId != null && typeId.contains("2.3")) {
            Element taglibNextSibling = WebXMLDescriptorHelper.findChildElement((Element)docRoot, (String)"resource-env-ref");
            if (taglibNextSibling == null) {
                taglibNextSibling = WebXMLDescriptorHelper.findChildElement((Element)docRoot, (String)"resource-ref");
            }
            if (taglibNextSibling == null) {
                taglibNextSibling = WebXMLDescriptorHelper.findChildElement((Element)docRoot, (String)"security-constraint");
            }
            if (taglibNextSibling == null) {
                taglibNextSibling = WebXMLDescriptorHelper.findChildElement((Element)docRoot, (String)"login-config");
            }
            if (taglibNextSibling == null) {
                taglibNextSibling = WebXMLDescriptorHelper.findChildElement((Element)docRoot, (String)"security-role");
            }
            if (taglibNextSibling == null) {
                taglibNextSibling = WebXMLDescriptorHelper.findChildElement((Element)docRoot, (String)"env-entry");
            }
            if (taglibNextSibling == null) {
                taglibNextSibling = WebXMLDescriptorHelper.findChildElement((Element)docRoot, (String)"ejb-ref");
            }
            if (taglibNextSibling == null) {
                taglibNextSibling = WebXMLDescriptorHelper.findChildElement((Element)docRoot, (String)"ejb-local-ref");
            }
            Element taglib = WebXMLDescriptorHelper.insertChildElement((Element)docRoot, (Node)taglibNextSibling, (String)"taglib", (String)"");
            WebXMLDescriptorHelper.appendChildElement((Element)taglib, (String)"taglib-uri", (String)tagLibRefType.getTaglibURI());
            WebXMLDescriptorHelper.appendChildElement((Element)taglib, (String)"taglib-location", (String)tagLibRefType.getTaglibLocation());
            if (taglibNextSibling == null) {
                docRoot.appendChild(document.createTextNode(System.getProperty("line.separator")));
            }
            FormatProcessorXML processor = new FormatProcessorXML();
            processor.formatNode((Node)taglib);
        } else {
            Element jspConfig = WebXMLDescriptorHelper.findChildElement((Element)docRoot, (String)"jsp-config");
            if (jspConfig == null) {
                jspConfig = WebXMLDescriptorHelper.appendChildElement((Element)docRoot, (String)"jsp-config");
            }
            Element taglib = WebXMLDescriptorHelper.appendChildElement((Element)jspConfig, (String)"taglib");
            WebXMLDescriptorHelper.appendChildElement((Element)taglib, (String)"taglib-uri", (String)tagLibRefType.getTaglibURI());
            WebXMLDescriptorHelper.appendChildElement((Element)taglib, (String)"taglib-location", (String)tagLibRefType.getTaglibLocation());
            docRoot.appendChild(document.createTextNode(System.getProperty("line.separator")));
            FormatProcessorXML processor = new FormatProcessorXML();
            processor.formatNode((Node)jspConfig);
        }
        return Status.OK_STATUS;
    }

    protected boolean tagLibReferenceExists(IDOMDocument document, TagLibRefType tagLibRefType) {
        NodeList taglibs = document.getElementsByTagName("taglib");
        int i = 0;
        while (i < taglibs.getLength()) {
            Node taglib = taglibs.item(i);
            boolean taglibUriEquals = NodeUtil.getChildElementContent((Node)taglib, (String)"taglib-uri").trim().equals(tagLibRefType.getTaglibURI().trim());
            boolean taglibLocationEquals = NodeUtil.getChildElementContent((Node)taglib, (String)"taglib-location").trim().equals(tagLibRefType.getTaglibLocation().trim());
            if (taglibUriEquals && taglibLocationEquals) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean tagLibReferenceExists(WebApp webApp, TagLibRefType tagLibRefType) {
        JSPConfig config;
        EList taglibs = webApp.getTagLibs();
        if (taglibs != null) {
            for (Object taglib : taglibs) {
                TagLibRefType existingTaglib;
                if (!(taglib instanceof TagLibRefType) || !(existingTaglib = (TagLibRefType)taglib).equals(tagLibRefType)) continue;
                return true;
            }
        }
        if ((config = webApp.getJspConfig()) != null && (taglibs = config.getTagLibs()) != null) {
            for (Object taglib : taglibs) {
                TagLibRefType existingTaglib;
                if (!(taglib instanceof TagLibRefType) || !(existingTaglib = (TagLibRefType)taglib).equals(tagLibRefType)) continue;
                return true;
            }
        }
        return false;
    }
}

