/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.AddStructureVisitor;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableFolderSyncInfo;

public class Add
extends Command {
    protected Add() {
    }

    protected String getRequestId() {
        return "add";
    }

    protected ICVSResource[] sendLocalResourceState(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor) throws CVSException {
        int i = 0;
        while (i < resources.length) {
            Assert.isNotNull((Object)resources[i].getRemoteLocation(session.getLocalRoot()));
            ++i;
        }
        AddStructureVisitor visitor = new AddStructureVisitor(session, localOptions);
        visitor.visit(session, resources, monitor);
        return resources;
    }

    protected IStatus commandFinished(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor, IStatus status) throws CVSException {
        if (status.getCode() == -10) {
            return status;
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i].isFolder()) {
                ICVSFolder mFolder = (ICVSFolder)resources[i];
                FolderSyncInfo info = mFolder.getParent().getFolderSyncInfo();
                if (info == null) {
                    status = this.mergeStatus(status, (IStatus)new CVSStatus(4, NLS.bind((String)CVSMessages.Add_invalidParent, (Object[])new String[]{mFolder.getRelativePath(session.getLocalRoot())})));
                } else {
                    String repository = String.valueOf(info.getRepository()) + "/" + mFolder.getName();
                    MutableFolderSyncInfo newInfo = info.cloneMutable();
                    newInfo.setRepository(repository);
                    mFolder.setFolderSyncInfo(newInfo);
                }
            }
            ++i;
        }
        return status;
    }

    protected ICommandOutputListener getDefaultCommandOutputListener() {
        return new CommandOutputListener(){

            public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
                String serverMessage = this.getServerMessage(line, location);
                if (serverMessage != null) {
                    if (serverMessage.indexOf("cvs commit") != -1 && serverMessage.indexOf("add") != -1 && serverMessage.indexOf("permanently") != -1) {
                        return OK;
                    }
                    if (serverMessage.startsWith("scheduling file") && serverMessage.indexOf("for addition") != -1) {
                        return OK;
                    }
                }
                return super.errorLine(line, location, commandRoot, monitor);
            }
        };
    }
}

