/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.ui.cmd;

import com.liferay.ide.eclipse.layouttpl.ui.model.LayoutConstraint;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletColumn;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletLayout;
import com.liferay.ide.eclipse.layouttpl.ui.util.LayoutTplUtil;
import org.eclipse.gef.commands.Command;

public class PortletColumnChangeConstraintCommand
extends Command {
    protected PortletColumn column;
    protected PortletLayout currentParent;
    protected PortletLayout newParent;
    protected LayoutConstraint layoutConstraint;

    public PortletColumnChangeConstraintCommand(PortletColumn column, PortletLayout currentParent, PortletLayout newParent, LayoutConstraint constraint) {
        this.column = column;
        this.currentParent = currentParent;
        this.newParent = newParent;
        this.layoutConstraint = constraint;
        this.setLabel("Portlet column changed");
    }

    public boolean canExecute() {
        return this.column != null && this.currentParent != null && this.newParent != null && this.layoutConstraint != null;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        if (this.currentParent.equals(this.newParent)) {
            int currentColumnIndex = LayoutTplUtil.getColumnIndex(this.currentParent, this.column);
            int cfr_ignored_0 = this.layoutConstraint.newColumnIndex;
            int existingWeight = this.column.getWeight();
            this.column.setWeight(this.layoutConstraint.weight);
            int diffWeight = existingWeight - this.layoutConstraint.weight;
            PortletColumn refColumn = this.layoutConstraint.refColumn;
            int newWeight = refColumn.getWeight() + diffWeight;
            newWeight = LayoutTplUtil.adjustWeight(newWeight);
            refColumn.setWeight(newWeight);
        }
    }

    public void undo() {
        System.out.println("UNDO");
    }
}

