/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.ui.editor;

import com.liferay.ide.eclipse.layouttpl.ui.LayoutTplUI;
import com.liferay.ide.eclipse.layouttpl.ui.editor.LayoutTplContextMenuProvider;
import com.liferay.ide.eclipse.layouttpl.ui.editor.LayoutTplEditorPaletteFactory;
import com.liferay.ide.eclipse.layouttpl.ui.editor.LayoutTplOutlinePage;
import com.liferay.ide.eclipse.layouttpl.ui.editor.LayoutTplPaletteViewerPreferences;
import com.liferay.ide.eclipse.layouttpl.ui.gef.GraphicalEditorWithFlyoutPalette;
import com.liferay.ide.eclipse.layouttpl.ui.model.LayoutTplDiagram;
import com.liferay.ide.eclipse.layouttpl.ui.parts.LayoutTplEditPartFactory;
import com.liferay.ide.eclipse.layouttpl.ui.parts.LayoutTplRootEditPart;
import java.util.EventObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class LayoutTplEditor
extends GraphicalEditorWithFlyoutPalette {
    protected static PaletteRoot PALETTE_MODEL;
    protected LayoutTplDiagram diagram;
    protected StructuredTextEditor sourceEditor;

    public LayoutTplEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public LayoutTplEditor(StructuredTextEditor sourceEditor) {
        this();
        this.sourceEditor = sourceEditor;
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    public void dispose() {
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.refreshSourceModel();
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception e) {
            LayoutTplUI.logError(e);
        }
    }

    public void doSaveAs() {
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            return new LayoutTplOutlinePage(this, (EditPartViewer)new TreeViewer());
        }
        return super.getAdapter(type);
    }

    public LayoutTplDiagram getDiagram() {
        return this.diagram;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void refreshSourceModel() {
        IDOMModel domModel = this.getSourceModel();
        domModel.aboutToChangeModel();
        String name = this.getSourceFile().getFullPath().removeFileExtension().lastSegment();
        String templateSource = this.diagram.getTemplateSource(name);
        domModel.getStructuredDocument().setText((Object)this, templateSource);
        domModel.changedModel();
        domModel.releaseFromEdit();
    }

    public void refreshVisualModel() {
        IDOMModel domModel = this.getSourceModel(true);
        if (domModel != null) {
            this.diagram = LayoutTplDiagram.createFromModel(domModel);
            domModel.releaseFromRead();
        } else {
            this.diagram = LayoutTplDiagram.createDefaultDiagram();
        }
        GraphicalViewer viewer = this.getGraphicalViewer();
        if (viewer != null) {
            viewer.setContents((Object)this.diagram);
            this.refreshViewer(viewer);
        }
    }

    public void updateActions() {
        this.updateActions(this.getSelectionActions());
    }

    private void refreshViewer(final GraphicalViewer viewer) {
        viewer.getControl().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                LayoutTplEditor.this.getGraphicalViewer().getContents().refresh();
                viewer.getControl().removePaintListener((PaintListener)this);
            }
        });
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new LayoutTplEditPartFactory());
        viewer.setRootEditPart((RootEditPart)new LayoutTplRootEditPart());
        viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(viewer));
        LayoutTplContextMenuProvider cmProvider = new LayoutTplContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)cmProvider);
        this.getSite().registerContextMenu((MenuManager)cmProvider, (ISelectionProvider)viewer);
    }

    protected void createGraphicalViewer(Composite parent) {
        GraphicalViewerImpl viewer = new GraphicalViewerImpl();
        viewer.createControl(parent);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.setPaletteViewerPreferences((PaletteViewerPreferences)new LayoutTplPaletteViewerPreferences());
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }

    protected TransferDropTargetListener createTransferDropTargetListener() {
        return new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()){

            protected CreationFactory getFactory(Object template) {
                return new SimpleFactory((Class)template);
            }
        };
    }

    protected PaletteRoot getPaletteRoot() {
        if (PALETTE_MODEL == null) {
            PALETTE_MODEL = LayoutTplEditorPaletteFactory.createPalette();
        }
        return PALETTE_MODEL;
    }

    protected IFile getSourceFile() {
        return ((IFileEditorInput)this.getEditorInput()).getFile();
    }

    protected IDOMModel getSourceModel() {
        return this.getSourceModel(false);
    }

    protected IDOMModel getSourceModel(boolean readOnly) {
        IDOMModel domModel = null;
        if (this.sourceEditor != null && this.sourceEditor.getDocumentProvider() != null) {
            IDocumentProvider documentProvider = this.sourceEditor.getDocumentProvider();
            IDocument doc = documentProvider.getDocument((Object)this.getEditorInput());
            IStructuredModel model = readOnly ? StructuredModelManager.getModelManager().getExistingModelForRead(doc) : StructuredModelManager.getModelManager().getExistingModelForEdit(doc);
            if (model instanceof IDOMModel) {
                domModel = (IDOMModel)model;
            }
        }
        return domModel;
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setContents((Object)this.getDiagram());
        this.refreshViewer(viewer);
        viewer.addDropTargetListener(this.createTransferDropTargetListener());
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.refreshVisualModel();
        IFile file = ((IFileEditorInput)input).getFile();
        this.setPartName(file.getName());
    }
}

