/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.ui.model;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.layouttpl.ui.LayoutTplUI;
import com.liferay.ide.eclipse.layouttpl.ui.model.ModelElement;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletColumn;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletLayout;
import com.liferay.ide.eclipse.layouttpl.ui.util.LayoutTplUtil;
import com.liferay.ide.eclipse.templates.core.ITemplateOperation;
import com.liferay.ide.eclipse.templates.core.TemplatesCore;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.VelocityContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutTplDiagram
extends ModelElement
implements PropertyChangeListener {
    public static final String ROW_ADDED_PROP = "LayoutTplDiagram.RowAdded";
    public static final String ROW_REMOVED_PROP = "LayoutTplDiagram.RowRemoved";
    protected String id = "main-content";
    protected String role = "main";
    protected List<ModelElement> rows = new ArrayList<ModelElement>();

    public static LayoutTplDiagram createDefaultDiagram() {
        return new LayoutTplDiagram();
    }

    public static LayoutTplDiagram createFromFile(IFile file) {
        if (file == null || !file.exists()) {
            return null;
        }
        LayoutTplDiagram model = null;
        try {
            IDOMModel domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(file);
            model = LayoutTplDiagram.createFromModel(domModel);
        }
        catch (Exception e) {
            LayoutTplUI.logError("Unable to read layout template file " + file.getName(), e);
            model = new LayoutTplDiagram();
        }
        return model;
    }

    public static LayoutTplDiagram createFromModel(IDOMModel model) {
        if (model == null) {
            return null;
        }
        LayoutTplDiagram newDiagram = null;
        IDOMDocument rootDocument = model.getDocument();
        IDOMElement mainContentElement = LayoutTplUtil.findMainContentElement(rootDocument);
        newDiagram = new LayoutTplDiagram();
        newDiagram.setId("main-content");
        if (mainContentElement != null) {
            newDiagram.setRole(LayoutTplUtil.getRoleValue(mainContentElement, "main"));
            Object[] portletLayoutElements = LayoutTplUtil.findChildElementsByClassName(mainContentElement, "div", "portlet-layout");
            if (!CoreUtil.isNullOrEmpty((Object[])portletLayoutElements)) {
                Object[] objectArray = portletLayoutElements;
                int n = portletLayoutElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object portletLayoutElement = objectArray[n2];
                    PortletLayout newPortletLayout = PortletLayout.createFromElement((IDOMElement)portletLayoutElement);
                    newDiagram.addRow(newPortletLayout);
                    ++n2;
                }
            }
        } else {
            newDiagram.setRole("main");
        }
        return newDiagram;
    }

    public void addRow(PortletLayout newRow) {
        this.addRow(newRow, -1);
    }

    public boolean addRow(PortletLayout newRow, int index) {
        if (newRow != null) {
            if (index < 0) {
                this.rows.add(newRow);
            } else {
                this.rows.add(index, newRow);
            }
            newRow.setParent(this);
            newRow.addPropertyChangeListener(this);
            this.updateColumns();
            this.firePropertyChange(ROW_ADDED_PROP, null, newRow);
            return true;
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public String getRole() {
        return this.role;
    }

    public List<ModelElement> getRows() {
        return this.rows;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("PortletLayout.ColumnAdded".equals(prop) || "PortletLayout.ColumnRemoved".equals(prop)) {
            this.updateColumns();
        }
    }

    @Override
    public void removeChild(ModelElement child) {
        if (this.rows.contains(child)) {
            this.removeRow((PortletLayout)child);
        }
    }

    public boolean removeRow(PortletLayout existingRow) {
        if (existingRow != null && this.rows.remove(existingRow)) {
            this.firePropertyChange(ROW_REMOVED_PROP, null, existingRow);
            return true;
        }
        return false;
    }

    public void saveToFile(IFile file, IProgressMonitor monitor) {
        ITemplateOperation templateOperation = TemplatesCore.getTemplateOperation((String)"layouttpl.tpl");
        templateOperation.setOutputFile(file);
        try {
            VelocityContext ctx = templateOperation.getContext();
            ctx.put("root", (Object)this);
            String name = file.getFullPath().removeFileExtension().lastSegment();
            ctx.put("templateName", (Object)name);
            templateOperation.execute(monitor);
        }
        catch (Exception e) {
            LayoutTplUI.logError(e);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRole(String role) {
        this.role = role;
    }

    protected void updateColumns() {
        int numIdCount = 1;
        for (ModelElement row : this.rows) {
            List<ModelElement> cols = ((PortletLayout)row).getColumns();
            int i = 0;
            while (i < cols.size()) {
                PortletColumn col = (PortletColumn)cols.get(i);
                col.setNumId(numIdCount++);
                if (i == 0 && cols.size() > 1) {
                    col.setFirst(true);
                } else if (cols.size() > 1 && i == cols.size() - 1) {
                    col.setLast(true);
                }
                ++i;
            }
        }
    }

    public String getTemplateSource(String templateName) {
        ITemplateOperation templateOperation = TemplatesCore.getTemplateOperation((String)"layouttpl.tpl");
        StringBuffer buffer = new StringBuffer();
        templateOperation.setOutputBuffer(buffer);
        templateOperation.getContext().put("root", (Object)this);
        templateOperation.getContext().put("templateName", (Object)templateName);
        try {
            templateOperation.execute((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception ex) {
            LayoutTplUI.logError("Error getting template source.", ex);
        }
        return buffer.toString();
    }
}

