/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.ui.model;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.layouttpl.ui.model.ModelElement;
import com.liferay.ide.eclipse.layouttpl.ui.util.LayoutTplUtil;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class PortletColumn
extends ModelElement {
    public static final int DEFAULT_WEIGHT = -1;
    public static final String WEIGHT_PROP = "PortletColumn.weight";
    protected static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"PortletColumn.weight", "Weight")};
    protected String className;
    protected boolean first = false;
    protected boolean last = false;
    protected int numId = 0;
    protected int weight;

    static {
        int i = 0;
        while (i < descriptors.length) {
            ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    int intValue = -1;
                    try {
                        intValue = Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "Not a number";
                    }
                    return intValue >= 0 ? null : "Value must be >=  0";
                }
            });
            ++i;
        }
    }

    public static PortletColumn createFromElement(IDOMElement portletColumnElement) {
        if (portletColumnElement == null) {
            return null;
        }
        PortletColumn newPortletColumn = new PortletColumn();
        String existingClassName = portletColumnElement.getAttribute("class");
        if (!CoreUtil.isNullOrEmpty((String)existingClassName) && existingClassName.contains("portlet-column")) {
            newPortletColumn.setClassName(existingClassName);
        } else {
            newPortletColumn.setClassName("portlet-column");
        }
        newPortletColumn.setWeight(LayoutTplUtil.getWeightValue(portletColumnElement, -1));
        return newPortletColumn;
    }

    public PortletColumn() {
        this(-1, "portlet-column");
    }

    public PortletColumn(int weight) {
        this(weight, "portlet-column");
    }

    public PortletColumn(int weight, String className) {
        this.weight = weight;
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public int getNumId() {
        return this.numId;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public Object getPropertyValue(Object propertyId) {
        if (WEIGHT_PROP.equals(propertyId)) {
            if (this.getWeight() == -1) {
                return "100%";
            }
            return String.valueOf(Integer.toString(this.getWeight())) + "%";
        }
        return super.getPropertyValue(propertyId);
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean isLast() {
        return this.last;
    }

    public void removeChild(ModelElement child) {
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public void setNumId(int numId) {
        this.numId = numId;
    }

    public void setPropertyValue(Object propertyId, Object value) {
        if (WEIGHT_PROP.equals(propertyId)) {
            String val = value.toString().replaceAll("%", "");
            int weight = Integer.parseInt(val);
            this.setWeight(weight);
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }

    public void setWeight(int weight) {
        int oldValue = this.weight;
        this.weight = weight;
        this.firePropertyChange(WEIGHT_PROP, oldValue, this.weight);
    }
}

