/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.ui.parts;

import com.liferay.ide.eclipse.layouttpl.ui.LayoutTplUI;
import com.liferay.ide.eclipse.layouttpl.ui.model.ModelElement;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletLayout;
import com.liferay.ide.eclipse.layouttpl.ui.parts.BaseTreeEditPart;
import com.liferay.ide.eclipse.layouttpl.ui.policies.PortletLayoutComponentEditPolicy;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.List;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletLayoutTreeEditPart
extends BaseTreeEditPart {
    protected Image icon;

    public PortletLayoutTreeEditPart(PortletLayout model) {
        super(model);
        URL url = LayoutTplUI.getDefault().getBundle().getEntry("/icons/e16/layout.png");
        this.icon = ImageDescriptor.createFromURL((URL)url).createImage();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new PortletLayoutComponentEditPolicy());
    }

    protected PortletLayout getCastedModel() {
        return (PortletLayout)this.getModel();
    }

    protected List<ModelElement> getModelChildren() {
        return this.getCastedModel().getColumns();
    }

    protected Image getImage() {
        return this.icon;
    }

    protected String getText() {
        String text = "Portlet Row";
        int numcols = this.getCastedModel().getColumns().size();
        if (numcols == 1) {
            text = String.valueOf(text) + " - 1 column";
        } else if (numcols > 1) {
            text = String.valueOf(text) + " - " + numcols + " columns";
        }
        return text;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("PortletLayout.ColumnAdded".equals(prop)) {
            this.addChild(this.createChild(evt.getNewValue()), -1);
        } else if ("PortletLayout.ColumnRemoved".equals(prop)) {
            this.removeChild(this.getEditPartForChild(evt.getNewValue()));
        } else {
            this.refreshVisuals();
        }
    }
}

