/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.ui.policies;

import com.liferay.ide.eclipse.layouttpl.ui.draw2d.ColumnFigure;
import com.liferay.ide.eclipse.layouttpl.ui.parts.RoundedRectangleResizeHandle;
import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class RoundedRectangleEditPolicy
extends ResizableEditPolicy {
    private Label feedbackLabel;

    protected List createSelectionHandles() {
        List handles = super.createSelectionHandles();
        MoveHandle moveHandle = null;
        ResizeHandle resizeHandle = null;
        for (Object handle : handles) {
            if (handle instanceof MoveHandle) {
                moveHandle = (MoveHandle)handle;
                continue;
            }
            if (!(handle instanceof ResizeHandle)) continue;
            ResizeHandle tempResizeHandle = (ResizeHandle)handle;
            try {
                Field f = ResizeHandle.class.getDeclaredField("cursorDirection");
                f.setAccessible(true);
                int cursorDirection = f.getInt(tempResizeHandle);
                if (cursorDirection != 9) continue;
                resizeHandle = tempResizeHandle;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (moveHandle != null) {
            handles.remove(moveHandle);
        }
        if (resizeHandle != null) {
            handles.remove(resizeHandle);
            handles.add(new RoundedRectangleResizeHandle((GraphicalEditPart)this.getHost(), 9));
        }
        return handles;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.showChangeBoundsFeedback(request);
        IFigure feedbackFigure = this.getDragSourceFeedbackFigure();
        if (this.feedbackLabel == null) {
            this.feedbackLabel = new Label(){

                protected void finalize() throws Throwable {
                    super.finalize();
                    Font font = this.getFont();
                    if (font != null && !font.isDisposed()) {
                        font.dispose();
                    }
                }
            };
            this.feedbackLabel.setText("50%");
            Font font = feedbackFigure.getFont();
            FontData[] fontData = font.getFontData();
            int i = 0;
            while (i < fontData.length) {
                fontData[i].setHeight(24);
                ++i;
            }
            Font correctedFont = new Font(font.getDevice(), fontData);
            this.feedbackLabel.setFont(correctedFont);
        }
        this.feedbackLabel.setLocation(feedbackFigure.getBounds().getCenter());
        this.feedbackLabel.setSize(this.feedbackLabel.getPreferredSize());
        this.addFeedback((IFigure)this.feedbackLabel);
        ((ColumnFigure)this.getHostFigure()).setDrawText(false);
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.eraseChangeBoundsFeedback(request);
        if (this.feedbackLabel != null) {
            this.removeFeedback((IFigure)this.feedbackLabel);
            this.feedbackLabel = null;
        }
        ((ColumnFigure)this.getHostFigure()).setDrawText(true);
    }
}

