/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.ui.wizard;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.layouttpl.core.LayoutTplCore;
import com.liferay.ide.eclipse.layouttpl.core.operation.INewLayoutTplDataModelProperties;
import com.liferay.ide.eclipse.layouttpl.core.operation.LayoutTplDescriptorHelper;
import com.liferay.ide.eclipse.layouttpl.ui.LayoutTplUI;
import com.liferay.ide.eclipse.layouttpl.ui.model.LayoutTplDiagram;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletColumn;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletLayout;
import com.liferay.ide.eclipse.project.core.util.LiferayDataModelOperation;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class AddLayoutTplOperation
extends LiferayDataModelOperation
implements INewLayoutTplDataModelProperties {
    public AddLayoutTplOperation(IDataModel model, TemplateStore templateStore, TemplateContextType contextType) {
        super(model, templateStore, contextType);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus retval = null;
        IStatus status = this.checkDescriptorFile(this.getTargetProject());
        if (!status.isOK()) {
            return status;
        }
        IDataModel dm = this.getDataModel();
        LayoutTplDiagram diagramModel = this.createLayoutTplDigram(dm);
        try {
            String thumbnailFile;
            String templateFile = this.getDataModel().getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE");
            IFile templateFileValue = null;
            if (!CoreUtil.isNullOrEmpty((String)templateFile)) {
                templateFileValue = this.createTemplateFile(templateFile, diagramModel);
            }
            this.getDataModel().setProperty("INewLayoutTplModelProperties.LAYOUT_TPL_FILE_CREATED", (Object)templateFileValue);
            String wapTemplateFile = this.getDataModel().getStringProperty("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE");
            if (!CoreUtil.isNullOrEmpty((String)wapTemplateFile)) {
                this.createTemplateFile(wapTemplateFile, diagramModel);
            }
            if (!CoreUtil.isNullOrEmpty((String)(thumbnailFile = this.getDataModel().getStringProperty("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE")))) {
                this.createThumbnailFile(thumbnailFile, diagramModel);
            }
        }
        catch (CoreException ex) {
            LayoutTplUI.logError((Exception)((Object)ex));
            return LayoutTplUI.createErrorStatus((Exception)((Object)ex));
        }
        catch (IOException ex) {
            LayoutTplUI.logError(ex);
            return LayoutTplUI.createErrorStatus(ex);
        }
        LayoutTplDescriptorHelper layoutTplDescHelper = new LayoutTplDescriptorHelper(this.getTargetProject());
        retval = layoutTplDescHelper.addNewLayoutTemplate(dm);
        return retval;
    }

    protected void createThumbnailFile(String thumbnailFile, LayoutTplDiagram diagramModel) throws CoreException, IOException {
        IFolder docroot = ProjectUtil.getDocroot((IProject)this.getTargetProject());
        IFile thumbnailFileValue = docroot.getFile(thumbnailFile);
        URL iconFileURL = LayoutTplUI.getDefault().getBundle().getEntry("/icons/blank_columns.png");
        CoreUtil.prepareFolder((IFolder)((IFolder)thumbnailFileValue.getParent()));
        if (thumbnailFileValue.exists()) {
            thumbnailFileValue.setContents(iconFileURL.openStream(), 1, null);
        } else {
            thumbnailFileValue.create(iconFileURL.openStream(), true, null);
        }
    }

    protected IFile createTemplateFile(String templateFile, LayoutTplDiagram diagramModel) throws CoreException {
        IFolder docroot = ProjectUtil.getDocroot((IProject)this.getTargetProject());
        IFile templateFileValue = docroot.getFile(templateFile);
        CoreUtil.prepareFolder((IFolder)((IFolder)templateFileValue.getParent()));
        if (diagramModel != null) {
            diagramModel.saveToFile(templateFileValue, null);
        } else {
            ByteArrayInputStream input = new ByteArrayInputStream("".getBytes());
            if (templateFileValue.exists()) {
                templateFileValue.setContents((InputStream)input, 1, null);
            } else {
                templateFileValue.create((InputStream)input, true, null);
            }
        }
        return templateFileValue;
    }

    protected LayoutTplDiagram createLayoutTplDigram(IDataModel dm) {
        LayoutTplDiagram diagram = new LayoutTplDiagram();
        if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_BLANK_COLUMN")) {
            diagram = null;
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(), 0);
            diagram.addRow(row);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_I_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(), 0);
            PortletLayout row2 = new PortletLayout();
            row2.addColumn(new PortletColumn(70), 0);
            row2.addColumn(new PortletColumn(30), 0);
            diagram.addRow(row);
            diagram.addRow(row2);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_II_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(), 0);
            PortletLayout row2 = new PortletLayout();
            row2.addColumn(new PortletColumn(30), 0);
            row2.addColumn(new PortletColumn(70), 0);
            diagram.addRow(row);
            diagram.addRow(row2);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_1_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(), 0);
            PortletLayout row2 = new PortletLayout();
            row2.addColumn(new PortletColumn(50), 0);
            row2.addColumn(new PortletColumn(50), 0);
            PortletLayout row3 = new PortletLayout();
            row3.addColumn(new PortletColumn(), 0);
            diagram.addRow(row);
            diagram.addRow(row2);
            diagram.addRow(row3);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_I_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(50), 0);
            row.addColumn(new PortletColumn(50), 0);
            diagram.addRow(row);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_II_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(70), 0);
            row.addColumn(new PortletColumn(30), 0);
            diagram.addRow(row);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_III_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(30), 0);
            row.addColumn(new PortletColumn(70), 0);
            diagram.addRow(row);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_2_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(30), 0);
            row.addColumn(new PortletColumn(70), 0);
            PortletLayout row2 = new PortletLayout();
            row2.addColumn(new PortletColumn(70), 0);
            row2.addColumn(new PortletColumn(30), 0);
            diagram.addRow(row);
            diagram.addRow(row2);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_3_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(33), 0);
            row.addColumn(new PortletColumn(33), 0);
            row.addColumn(new PortletColumn(33), 0);
            diagram.addRow(row);
        }
        return diagram;
    }

    public IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtil.getProject((String)projectName);
    }

    protected IStatus checkDescriptorFile(IProject project) {
        IFolder docroot = ProjectUtil.getDocroot((IProject)project);
        IFile layoutTplDescriptorFile = docroot.getFile("WEB-INF/liferay-layout-templates.xml");
        if (!layoutTplDescriptorFile.exists()) {
            try {
                this.createDefaultLayoutTplDescriptorFile(layoutTplDescriptorFile);
            }
            catch (Exception ex) {
                return LayoutTplCore.createErrorStatus((Exception)ex);
            }
        }
        return Status.OK_STATUS;
    }

    protected void createDefaultLayoutTplDescriptorFile(IFile layoutTplDescriptorFile) throws UnsupportedEncodingException, CoreException, BadLocationException, TemplateException {
        String templateString = null;
        Document document = new Document();
        DocumentTemplateContext context = new DocumentTemplateContext(this.contextType, (IDocument)document, 0, 0);
        Template template = this.templateStore.findTemplateById("com.liferay.ide.eclipse.templates.layouttpl.descriptor");
        TemplateBuffer buffer = context.evaluate(template);
        templateString = buffer.getString();
        layoutTplDescriptorFile.create((InputStream)new ByteArrayInputStream(templateString.getBytes("UTF-8")), 1, null);
    }
}

