/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.ui.wizard;

import com.liferay.ide.eclipse.layouttpl.core.operation.INewLayoutTplDataModelProperties;
import com.liferay.ide.eclipse.layouttpl.ui.LayoutTplUI;
import com.liferay.ide.eclipse.ui.util.SWTUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class NewLayoutTplLayoutWizardPage
extends DataModelWizardPage
implements INewLayoutTplDataModelProperties {
    protected static final ImageDescriptor[] layoutOptionsImages = new ImageDescriptor[]{ImageDescriptor.createFromURL((URL)LayoutTplUI.getDefault().getBundle().getEntry("/icons/layouts/blank_column.png")), ImageDescriptor.createFromURL((URL)LayoutTplUI.getDefault().getBundle().getEntry("/icons/layouts/1_column.png")), ImageDescriptor.createFromURL((URL)LayoutTplUI.getDefault().getBundle().getEntry("/icons/layouts/1_2_columns_i.png")), ImageDescriptor.createFromURL((URL)LayoutTplUI.getDefault().getBundle().getEntry("/icons/layouts/1_2_columns_ii.png")), ImageDescriptor.createFromURL((URL)LayoutTplUI.getDefault().getBundle().getEntry("/icons/layouts/1_2_1_columns.png")), ImageDescriptor.createFromURL((URL)LayoutTplUI.getDefault().getBundle().getEntry("/icons/layouts/2_columns_i.png")), ImageDescriptor.createFromURL((URL)LayoutTplUI.getDefault().getBundle().getEntry("/icons/layouts/2_columns_ii.png")), ImageDescriptor.createFromURL((URL)LayoutTplUI.getDefault().getBundle().getEntry("/icons/layouts/2_columns_iii.png")), ImageDescriptor.createFromURL((URL)LayoutTplUI.getDefault().getBundle().getEntry("/icons/layouts/2_2_columns.png")), ImageDescriptor.createFromURL((URL)LayoutTplUI.getDefault().getBundle().getEntry("/icons/layouts/3_columns.png"))};
    protected static final String[] layoutOptionsText = new String[]{"Blank", "1 Column", "1-2 Columns (30/70)", "1-2 Columns (70/30)", "1-2-1 Columns", "2 Columns (50/50)", "2 Columns (30/70)", "2 Columns (70/30)", "2-2 Columns", "3 Columns"};
    protected List<Image> imagesToDispose;

    public NewLayoutTplLayoutWizardPage(IDataModel dataModel, String pageName) {
        super(dataModel, pageName, "Create Layout Template", LayoutTplUI.imageDescriptorFromPlugin((String)"com.liferay.ide.eclipse.layouttpl.ui", (String)"/icons/wizban/layout_template_wiz.png"));
        this.setDescription("Select initial template to start designing.");
    }

    public void dispose() {
        super.dispose();
        if (this.imagesToDispose != null && this.imagesToDispose.size() > 0) {
            for (Image img : this.imagesToDispose) {
                if (img == null || img.isDisposed()) continue;
                img.dispose();
            }
        }
    }

    protected void createLayoutOption(Composite parent, final String property, String text, Image image) {
        Composite optionParent = new Composite(parent, 0);
        optionParent.setLayout((Layout)new GridLayout(1, false));
        Label imageLabel = new Label(optionParent, 0);
        imageLabel.setImage(image);
        imageLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                NewLayoutTplLayoutWizardPage.this.getDataModel().setProperty(property, (Object)true);
            }
        });
        Button radio = new Button(optionParent, 16);
        radio.setText(text);
        this.synchHelper.synchRadio(radio, property, null);
    }

    protected void createSelectLayoutGroup(Composite parent) {
        SWTUtil.createLabel((Composite)parent, (String)"Select an initial layout to use for the new template:", (int)1);
        Composite group = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 575;
        group.setLayoutData((Object)gd);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        rowLayout.pack = false;
        group.setLayout((Layout)rowLayout);
        if (LAYOUT_PROPERTIES.length == layoutOptionsText.length && LAYOUT_PROPERTIES.length == layoutOptionsImages.length) {
            this.imagesToDispose = new ArrayList<Image>();
            int i = 0;
            while (i < LAYOUT_PROPERTIES.length) {
                Image img = layoutOptionsImages[i].createImage();
                this.createLayoutOption(group, LAYOUT_PROPERTIES[i], layoutOptionsText[i], img);
                this.imagesToDispose.add(img);
                ++i;
            }
        }
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite topComposite = SWTUtil.createTopComposite((Composite)parent, (int)1);
        this.createSelectLayoutGroup(topComposite);
        return topComposite;
    }

    protected String[] getValidationPropertyNames() {
        return LAYOUT_PROPERTIES;
    }
}

