/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.Serializable;

public class BooleanReference
implements Cloneable,
Serializable {
    private volatile boolean value;
    private static final long serialVersionUID = 1L;

    public BooleanReference(boolean value) {
        this.value = value;
    }

    public BooleanReference() {
        this(false);
    }

    public boolean getValue() {
        return this.value;
    }

    public boolean is(boolean v) {
        return this.value == v;
    }

    public boolean isNot(boolean v) {
        return this.value ^ v;
    }

    public boolean isTrue() {
        return this.value;
    }

    public boolean isFalse() {
        return !this.value;
    }

    public boolean setValue(boolean value) {
        boolean old = this.value;
        this.value = value;
        return old;
    }

    public boolean flip() {
        this.value = !this.value;
        return this.value;
    }

    public boolean setNot(boolean v) {
        return this.setValue(!v);
    }

    public boolean setTrue() {
        return this.setValue(true);
    }

    public boolean setFalse() {
        return this.setValue(false);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        return o instanceof BooleanReference && this.value == ((BooleanReference)o).value;
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.value) + ']';
    }
}

